/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.exec.scan.index;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.query.impl.AbstractIndex;
import com.hazelcast.query.impl.Comparison;
import com.hazelcast.query.impl.InternalIndex;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.sql.impl.SqlDataSerializerHook;
import com.hazelcast.sql.impl.exec.scan.index.IndexFilter;
import com.hazelcast.sql.impl.exec.scan.index.IndexFilterValue;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;

public class IndexRangeFilter
implements IndexFilter,
IdentifiedDataSerializable {
    private IndexFilterValue from;
    private boolean fromInclusive;
    private IndexFilterValue to;
    private boolean toInclusive;

    public IndexRangeFilter() {
    }

    public IndexRangeFilter(IndexFilterValue from, boolean fromInclusive, IndexFilterValue to, boolean toInclusive) {
        assert (from != null || to != null);
        this.from = from;
        this.fromInclusive = fromInclusive;
        this.to = to;
        this.toInclusive = toInclusive;
    }

    @Override
    public Iterator<QueryableEntry> getEntries(InternalIndex index, boolean descending, ExpressionEvalContext evalContext) {
        Comparison toComparison;
        if (this.from != null) {
            Comparison fromComparison;
            if (this.to != null) {
                Comparable fromValue = this.from.getValue(evalContext);
                if (IndexRangeFilter.isNull(fromValue)) {
                    return Collections.emptyIterator();
                }
                Comparable toValue = this.to.getValue(evalContext);
                if (IndexRangeFilter.isNull(toValue)) {
                    return Collections.emptyIterator();
                }
                return index.getSqlRecordIterator(fromValue, this.fromInclusive, toValue, this.toInclusive, descending);
            }
            Comparable fromValue = this.from.getValue(evalContext);
            Comparison comparison = fromComparison = this.fromInclusive ? Comparison.GREATER_OR_EQUAL : Comparison.GREATER;
            if (IndexRangeFilter.isNull(fromValue)) {
                return Collections.emptyIterator();
            }
            return index.getSqlRecordIterator(fromComparison, fromValue, descending);
        }
        assert (this.to != null);
        Comparable toValue = this.to.getValue(evalContext);
        Comparison comparison = toComparison = this.toInclusive ? Comparison.LESS_OR_EQUAL : Comparison.LESS;
        if (IndexRangeFilter.isNull(toValue)) {
            return Collections.emptyIterator();
        }
        return index.getSqlRecordIterator(toComparison, toValue, descending);
    }

    private static boolean isNull(Object value) {
        assert (value != AbstractIndex.NULL);
        return value == null;
    }

    @Override
    public Comparable getComparable(ExpressionEvalContext evalContext) {
        return this.from != null ? this.from.getValue(evalContext) : this.to.getValue(evalContext);
    }

    public IndexFilterValue getFrom() {
        return this.from;
    }

    public boolean isFromInclusive() {
        return this.fromInclusive;
    }

    public IndexFilterValue getTo() {
        return this.to;
    }

    public boolean isToInclusive() {
        return this.toInclusive;
    }

    @Override
    public int getFactoryId() {
        return SqlDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 50;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.from);
        out.writeBoolean(this.fromInclusive);
        out.writeObject(this.to);
        out.writeBoolean(this.toInclusive);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.from = (IndexFilterValue)in.readObject();
        this.fromInclusive = in.readBoolean();
        this.to = (IndexFilterValue)in.readObject();
        this.toInclusive = in.readBoolean();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexRangeFilter that = (IndexRangeFilter)o;
        return Objects.equals(this.from, that.from) && this.fromInclusive == that.fromInclusive && Objects.equals(this.to, that.to) && this.toInclusive == that.toInclusive;
    }

    public int hashCode() {
        int result = this.from != null ? this.from.hashCode() : 0;
        result = 31 * result + (this.fromInclusive ? 1 : 0);
        result = 31 * result + (this.to != null ? this.to.hashCode() : 0);
        result = 31 * result + (this.toInclusive ? 1 : 0);
        return result;
    }

    public String toString() {
        return "IndexRangeFilter {from=" + this.from + ", fromInclusive=" + this.fromInclusive + ", to=" + this.to + ", toInclusive=" + this.toInclusive + '}';
    }
}

