/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql2rel;

import com.hazelcast.org.apache.calcite.plan.RelOptTable;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.schema.ColumnStrategy;
import com.hazelcast.org.apache.calcite.sql.SqlFunction;
import com.hazelcast.org.apache.calcite.sql2rel.InitializerContext;
import com.hazelcast.org.apache.calcite.sql2rel.InitializerExpressionFactory;
import java.util.List;
import java.util.function.BiFunction;

public class NullInitializerExpressionFactory
implements InitializerExpressionFactory {
    public static final InitializerExpressionFactory INSTANCE = new NullInitializerExpressionFactory();

    @Override
    public boolean isGeneratedAlways(RelOptTable table, int iColumn) {
        switch (this.generationStrategy(table, iColumn)) {
            case VIRTUAL: 
            case STORED: {
                return true;
            }
        }
        return false;
    }

    @Override
    public ColumnStrategy generationStrategy(RelOptTable table, int iColumn) {
        return table.getRowType().getFieldList().get(iColumn).getType().isNullable() ? ColumnStrategy.NULLABLE : ColumnStrategy.NOT_NULLABLE;
    }

    @Override
    public RexNode newColumnDefaultValue(RelOptTable table, int iColumn, InitializerContext context) {
        RelDataType fieldType = table.getRowType().getFieldList().get(iColumn).getType();
        return context.getRexBuilder().makeNullLiteral(fieldType);
    }

    @Override
    public BiFunction<InitializerContext, RelNode, RelNode> postExpressionConversionHook() {
        return null;
    }

    @Override
    public RexNode newAttributeInitializer(RelDataType type, SqlFunction constructor, int iAttribute, List<RexNode> constructorArgs, InitializerContext context) {
        RelDataType fieldType = type.getFieldList().get(iAttribute).getType();
        return context.getRexBuilder().makeNullLiteral(fieldType);
    }
}

