/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql.parser;

import com.hazelcast.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.org.apache.calcite.util.CalciteParserException;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;

public class SqlParseException
extends Exception
implements CalciteParserException {
    private final SqlParserPos pos;
    private final int[][] expectedTokenSequences;
    private final String[] tokenImages;
    private final transient Throwable parserException;

    public SqlParseException(String message, SqlParserPos pos, int[][] expectedTokenSequences, String[] tokenImages, Throwable parserException) {
        super(message, null);
        this.pos = pos;
        this.expectedTokenSequences = expectedTokenSequences;
        this.tokenImages = tokenImages;
        this.parserException = parserException;
    }

    public SqlParserPos getPos() {
        return this.pos;
    }

    public Collection<String> getExpectedTokenNames() {
        if (this.expectedTokenSequences == null) {
            return Collections.emptyList();
        }
        int maxLength = 0;
        for (int[] expectedTokenSequence : this.expectedTokenSequences) {
            maxLength = Math.max(expectedTokenSequence.length, maxLength);
        }
        TreeSet<String> set = new TreeSet<String>();
        for (int[] expectedTokenSequence : this.expectedTokenSequences) {
            if (expectedTokenSequence.length != maxLength) continue;
            set.add(this.tokenImages[expectedTokenSequence[expectedTokenSequence.length - 1]]);
        }
        return set;
    }

    public String[] getTokenImages() {
        return this.tokenImages;
    }

    public int[][] getExpectedTokenSequences() {
        return this.expectedTokenSequences;
    }

    @Override
    public Throwable getCause() {
        return this.parserException;
    }

    private Object writeReplace() {
        return new RuntimeException(this.getClass().getName() + ": " + this.getMessage());
    }
}

