/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.nearcache.impl.preloader;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.util.EmptyStatement;
import com.hazelcast.logging.ILogger;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;

class NearCachePreloaderLock {
    private final ILogger logger;
    private final File lockFile;
    private final FileChannel channel;
    private final FileLock lock;

    NearCachePreloaderLock(ILogger logger, String lockFilename) {
        this.logger = logger;
        this.lockFile = new File(lockFilename);
        this.channel = this.openChannel(this.lockFile);
        this.lock = this.acquireLock(this.lockFile, this.channel);
    }

    void release() {
        try {
            this.lock.release();
        }
        catch (ClosedChannelException e) {
            EmptyStatement.ignore(e);
        }
        catch (IOException e) {
            this.logger.severe("Problem while releasing the lock on " + this.lockFile, e);
        }
        try {
            this.channel.close();
        }
        catch (IOException e) {
            this.logger.severe("Problem while closing the channel " + this.lockFile, e);
        }
        finally {
            IOUtil.delete(this.lockFile);
        }
    }

    FileLock acquireLock(File lockFile, FileChannel channel) {
        FileLock fileLock = null;
        try {
            fileLock = channel.tryLock();
            if (fileLock != null) {
                FileLock fileLock2 = fileLock;
                return fileLock2;
            }
            try {
                throw new HazelcastException("Cannot acquire lock on " + lockFile.getAbsolutePath() + ". File is already being used by another Hazelcast instance.");
            }
            catch (OverlappingFileLockException e) {
                throw new HazelcastException("Cannot acquire lock on " + lockFile.getAbsolutePath() + ". File is already being used by this Hazelcast instance.", e);
            }
            catch (IOException e) {
                throw new HazelcastException("Unknown failure while acquiring lock on " + lockFile.getAbsolutePath(), e);
            }
        }
        finally {
            if (fileLock == null) {
                IOUtil.closeResource(channel);
            }
        }
    }

    private FileChannel openChannel(File lockFile) {
        try {
            return new RandomAccessFile(lockFile, "rw").getChannel();
        }
        catch (IOException e) {
            throw new HazelcastException("Cannot create lock file " + lockFile.getAbsolutePath(), e);
        }
    }
}

