/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import java.util.HashMap;
import java.util.Map;

public final class RemoveSuperMethodsPass
implements CompilerPass {
    private static final String SUPERCLASS_MARKER = "\\.superClass_\\.";
    private static final String PROTOTYPE_MARKER = "\\.prototype\\.";
    private final AbstractCompiler compiler;
    private final Map<String, Node> removeCandidates;

    public RemoveSuperMethodsPass(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.removeCandidates = new HashMap<String, Node>();
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, new RemoveSuperMethodsCallback());
        NodeTraversal.traverse(this.compiler, root, new FilterDuplicateMethods());
        for (Map.Entry<String, Node> entry : this.removeCandidates.entrySet()) {
            Node removalTarget = entry.getValue().getGrandparent();
            Node removalParent = removalTarget.getParent();
            removalTarget.detach();
            NodeUtil.markFunctionsDeleted(removalTarget, this.compiler);
            this.compiler.reportChangeToEnclosingScope(removalParent);
        }
    }

    private class FilterDuplicateMethods
    extends NodeTraversal.AbstractPostOrderCallback {
        private FilterDuplicateMethods() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isFunction() && parent.isAssign() && parent.getParent().isExprResult()) {
                String methodName = NodeUtil.getName(n);
                if (RemoveSuperMethodsPass.this.removeCandidates.containsKey(methodName) && RemoveSuperMethodsPass.this.removeCandidates.get(methodName) != n) {
                    RemoveSuperMethodsPass.this.removeCandidates.remove(methodName);
                }
            }
        }
    }

    private class RemoveSuperMethodsCallback
    extends NodeTraversal.AbstractPostOrderCallback {
        private RemoveSuperMethodsCallback() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isFunction() && parent.isAssign() && parent.getParent().isExprResult()) {
                if (parent.getJSDocInfo() != null && parent.getJSDocInfo().isWizaction()) {
                    return;
                }
                Node block = n.getLastChild();
                if (!block.hasOneChild()) {
                    return;
                }
                Node statement = block.getFirstChild();
                if ((statement.isExprResult() || statement.isReturn()) && statement.hasOneChild() && statement.getFirstChild().isCall()) {
                    String methodName = NodeUtil.getName(n);
                    if (methodName == null) {
                        return;
                    }
                    Node call = statement.getFirstChild();
                    if (this.argumentsMatch(n, call) && this.returnMatches(call) && this.functionNameMatches(methodName, call)) {
                        RemoveSuperMethodsPass.this.removeCandidates.put(methodName, n);
                    }
                }
            }
        }

        private boolean functionNameMatches(String enclosingMethodName, Node call) {
            String callName = call.getFirstChild().getQualifiedName();
            if (callName == null) {
                return false;
            }
            String[] methodNameSplitted = enclosingMethodName.split(RemoveSuperMethodsPass.PROTOTYPE_MARKER);
            if (methodNameSplitted.length != 2) {
                return false;
            }
            String enclosingClassName = methodNameSplitted[0];
            String shortMethodNameConcatedWithCall = methodNameSplitted[1].concat(".call");
            String[] callNameSplittedBySuperClassMarker = callName.split(RemoveSuperMethodsPass.SUPERCLASS_MARKER);
            if (callNameSplittedBySuperClassMarker.length == 2 && callNameSplittedBySuperClassMarker[0].equals(enclosingClassName) && callNameSplittedBySuperClassMarker[1].equals(shortMethodNameConcatedWithCall)) {
                return true;
            }
            String[] callNameSplittedByPrototypeMarker = callName.split(RemoveSuperMethodsPass.PROTOTYPE_MARKER);
            if (callNameSplittedByPrototypeMarker.length != 2 || !callNameSplittedByPrototypeMarker[1].equals(shortMethodNameConcatedWithCall)) {
                return false;
            }
            String calledClass = callNameSplittedByPrototypeMarker[0];
            JSType subclassType = RemoveSuperMethodsPass.this.compiler.getTypeRegistry().getGlobalType(enclosingClassName);
            JSType calledClassType = RemoveSuperMethodsPass.this.compiler.getTypeRegistry().getGlobalType(calledClass);
            if (subclassType == null || calledClassType == null) {
                return false;
            }
            if (subclassType.toMaybeObjectType() == null || subclassType.toMaybeObjectType().getConstructor() == null) {
                return false;
            }
            FunctionType superClassConstructor = subclassType.toMaybeObjectType().getSuperClassConstructor();
            if (superClassConstructor == null) {
                return false;
            }
            return superClassConstructor.getInstanceType().equals(calledClassType);
        }

        private boolean returnMatches(Node call) {
            JSType childType = call.getFirstChild().getJSType();
            if (childType == null || !childType.isFunctionType()) {
                return false;
            }
            JSType returnType = childType.toMaybeFunctionType().getReturnType();
            if (returnType != null && !returnType.isVoidType() && !returnType.isUnknownType()) {
                return call.getParent().isReturn();
            }
            return true;
        }

        private boolean argumentsMatch(Node enclosingMethod, Node call) {
            Node paramList = enclosingMethod.getSecondChild();
            int numExtraCallChildren = 2;
            if (paramList.getChildCount() + numExtraCallChildren != call.getChildCount()) {
                return false;
            }
            if (!call.getSecondChild().isThis()) {
                return false;
            }
            Node callArg = call.getChildAtIndex(numExtraCallChildren);
            Node param = paramList.getFirstChild();
            while (param != null) {
                if (!callArg.isName() || !param.matchesQualifiedName(callArg)) {
                    return false;
                }
                param = param.getNext();
                callArg = callArg.getNext();
            }
            return true;
        }
    }
}

