/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.javascript.jscomp.AutoValue_ModuleMetadataMap_ModuleMetadata;
import com.google.javascript.jscomp.deps.ModuleLoader;
import java.util.Map;
import javax.annotation.Nullable;

public final class ModuleMetadataMap {
    private final ImmutableMap<String, ModuleMetadata> modulesByPath;
    private final ImmutableMap<String, ModuleMetadata> modulesByGoogNamespace;

    public ModuleMetadataMap(Map<String, ModuleMetadata> modulesByPath, Map<String, ModuleMetadata> modulesByGoogNamespace) {
        this.modulesByPath = ImmutableMap.copyOf(modulesByPath);
        this.modulesByGoogNamespace = ImmutableMap.copyOf(modulesByGoogNamespace);
    }

    public ImmutableMap<String, ModuleMetadata> getModulesByPath() {
        return this.modulesByPath;
    }

    public ImmutableMap<String, ModuleMetadata> getModulesByGoogNamespace() {
        return this.modulesByGoogNamespace;
    }

    public static abstract class ModuleMetadata {
        public abstract ModuleType moduleType();

        public boolean isEs6Module() {
            return this.moduleType() == ModuleType.ES6_MODULE;
        }

        public boolean isGoogModule() {
            return this.isNonLegacyGoogModule() || this.isLegacyGoogModule();
        }

        public boolean isNonLegacyGoogModule() {
            return this.moduleType() == ModuleType.GOOG_MODULE;
        }

        public boolean isLegacyGoogModule() {
            return this.moduleType() == ModuleType.LEGACY_GOOG_MODULE;
        }

        public boolean isGoogProvide() {
            return this.moduleType() == ModuleType.GOOG_PROVIDE;
        }

        public boolean isCommonJs() {
            return this.moduleType() == ModuleType.COMMON_JS;
        }

        public boolean isScript() {
            return this.moduleType() == ModuleType.SCRIPT;
        }

        public abstract boolean usesClosure();

        public abstract boolean isTestOnly();

        public abstract ImmutableMultiset<String> googNamespaces();

        public abstract ImmutableMultiset<String> requiredGoogNamespaces();

        public abstract ImmutableMultiset<String> requiredTypes();

        public abstract ImmutableMultiset<String> es6ImportSpecifiers();

        abstract ImmutableList<ModuleMetadata> nestedModules();

        @Nullable
        public abstract ModuleLoader.ModulePath path();

        public static Builder builder() {
            return new AutoValue_ModuleMetadataMap_ModuleMetadata.Builder();
        }

        static abstract class Builder {
            Builder() {
            }

            abstract ModuleMetadata build();

            abstract ImmutableMultiset.Builder<String> googNamespacesBuilder();

            abstract ImmutableMultiset.Builder<String> requiredGoogNamespacesBuilder();

            abstract ImmutableMultiset.Builder<String> requiredTypesBuilder();

            abstract ImmutableMultiset.Builder<String> es6ImportSpecifiersBuilder();

            abstract ImmutableList.Builder<ModuleMetadata> nestedModulesBuilder();

            abstract Builder path(@Nullable ModuleLoader.ModulePath var1);

            abstract Builder usesClosure(boolean var1);

            abstract Builder isTestOnly(boolean var1);

            abstract ModuleType moduleType();

            abstract Builder moduleType(ModuleType var1);
        }
    }

    public static enum ModuleType {
        ES6_MODULE("an ES6 module"),
        GOOG_PROVIDE("a goog.provide'd file"),
        GOOG_MODULE("a goog.module"),
        LEGACY_GOOG_MODULE("a goog.module"),
        COMMON_JS("a CommonJS module"),
        SCRIPT("a script");

        public final String description;

        private ModuleType(String description) {
            this.description = description;
        }
    }
}

