/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.debugging.sourcemap.proto.Mapping;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JsMessage;
import com.google.javascript.jscomp.JsMessageDefinition;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.parsing.parser.util.format.SimpleFormat;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

@GwtIncompatible(value="JsMessage, java.util.regex")
public abstract class JsMessageVisitor
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    private static final String MSG_FUNCTION_NAME = "goog.getMsg";
    private static final String MSG_FALLBACK_FUNCTION_NAME = "goog.getMsgWithFallback";
    static final DiagnosticType MESSAGE_HAS_NO_DESCRIPTION = DiagnosticType.warning("JSC_MSG_HAS_NO_DESCRIPTION", "Message {0} has no description. Add @desc JsDoc tag.");
    static final DiagnosticType MESSAGE_HAS_NO_TEXT = DiagnosticType.warning("JSC_MSG_HAS_NO_TEXT", "Message value of {0} is just an empty string. Empty messages are forbidden.");
    static final DiagnosticType MESSAGE_TREE_MALFORMED = DiagnosticType.error("JSC_MSG_TREE_MALFORMED", "Message parse tree malformed. {0}");
    static final DiagnosticType MESSAGE_HAS_NO_VALUE = DiagnosticType.error("JSC_MSG_HAS_NO_VALUE", "message node {0} has no value");
    static final DiagnosticType MESSAGE_DUPLICATE_KEY = DiagnosticType.error("JSC_MSG_KEY_DUPLICATED", "duplicate message variable name found for {0}, initial definition {1}:{2}");
    static final DiagnosticType MESSAGE_NODE_IS_ORPHANED = DiagnosticType.warning("JSC_MSG_ORPHANED_NODE", "goog.getMsg() function could be used only with MSG_* property or variable");
    static final DiagnosticType MESSAGE_NOT_INITIALIZED_USING_NEW_SYNTAX = DiagnosticType.warning("JSC_MSG_NOT_INITIALIZED_USING_NEW_SYNTAX", "message not initialized using goog.getMsg");
    static final DiagnosticType BAD_FALLBACK_SYNTAX = DiagnosticType.error("JSC_MSG_BAD_FALLBACK_SYNTAX", SimpleFormat.format("Bad syntax. Expected syntax: %s(MSG_1, MSG_2)", "goog.getMsgWithFallback"));
    static final DiagnosticType FALLBACK_ARG_ERROR = DiagnosticType.error("JSC_MSG_FALLBACK_ARG_ERROR", "Could not find message entry for fallback argument {0}");
    private static final String PH_JS_PREFIX = "{$";
    private static final String PH_JS_SUFFIX = "}";
    static final String MSG_PREFIX = "MSG_";
    private static final Pattern MSG_UNNAMED_PATTERN = Pattern.compile("MSG_UNNAMED.*");
    private static final Pattern CAMELCASE_PATTERN = Pattern.compile("[a-z][a-zA-Z\\d]*[_\\d]*");
    static final String HIDDEN_DESC_PREFIX = "@hidden";
    private static final String DESC_SUFFIX = "_HELP";
    private final boolean needToCheckDuplications;
    private final JsMessage.Style style;
    private final JsMessage.IdGenerator idGenerator;
    final AbstractCompiler compiler;
    private final Map<String, MessageLocation> messageNames = new HashMap<String, MessageLocation>();
    private final Map<Var, JsMessage> unnamedMessages = new HashMap<Var, JsMessage>();
    private final Set<Node> googMsgNodes = new HashSet<Node>();
    private final CheckLevel checkLevel;

    protected JsMessageVisitor(AbstractCompiler compiler, boolean needToCheckDuplications, JsMessage.Style style, JsMessage.IdGenerator idGenerator) {
        this.compiler = compiler;
        this.needToCheckDuplications = needToCheckDuplications;
        this.style = style;
        this.idGenerator = idGenerator;
        this.checkLevel = style == JsMessage.Style.CLOSURE ? CheckLevel.ERROR : CheckLevel.WARNING;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
        for (Node msgNode : this.googMsgNodes) {
            this.compiler.report(JSError.make(msgNode, this.checkLevel, MESSAGE_NODE_IS_ORPHANED, new String[0]));
        }
    }

    @Override
    public void visit(NodeTraversal traversal, Node node, Node parent) {
        boolean isNewStyleMessage;
        Node msgNode;
        boolean isVar;
        String originalMessageKey;
        String messageKey;
        switch (node.getToken()) {
            case NAME: {
                if (parent == null || !NodeUtil.isNameDeclaration(parent)) {
                    return;
                }
                messageKey = node.getString();
                originalMessageKey = node.getOriginalName();
                isVar = true;
                msgNode = node.getFirstChild();
                break;
            }
            case ASSIGN: {
                isVar = false;
                Node getProp = node.getFirstChild();
                if (!getProp.isGetProp()) {
                    return;
                }
                Node propNode = getProp.getLastChild();
                messageKey = propNode.getString();
                originalMessageKey = getProp.getOriginalName();
                msgNode = node.getLastChild();
                break;
            }
            case STRING_KEY: {
                if (node.isQuotedString() || !node.hasChildren()) {
                    return;
                }
                isVar = false;
                messageKey = node.getString();
                originalMessageKey = node.getOriginalName();
                msgNode = node.getFirstChild();
                break;
            }
            case CALL: {
                if (node.getFirstChild().matchesQualifiedName(MSG_FUNCTION_NAME)) {
                    this.googMsgNodes.add(node);
                } else if (node.getFirstChild().matchesQualifiedName(MSG_FALLBACK_FUNCTION_NAME)) {
                    this.visitFallbackFunctionCall(traversal, node);
                }
                return;
            }
            default: {
                return;
            }
        }
        if (originalMessageKey != null) {
            messageKey = originalMessageKey;
        }
        boolean bl = isNewStyleMessage = msgNode != null && msgNode.isCall();
        if (!this.isMessageName(messageKey, isNewStyleMessage)) {
            return;
        }
        if (msgNode == null) {
            this.compiler.report(traversal.makeError(node, MESSAGE_HAS_NO_VALUE, messageKey));
            return;
        }
        if (msgNode.isGetProp() && msgNode.isQualifiedName() && msgNode.getLastChild().getString().equals(messageKey)) {
            return;
        }
        if (isNewStyleMessage) {
            this.googMsgNodes.remove(msgNode);
        } else if (this.style != JsMessage.Style.LEGACY) {
            this.compiler.report(traversal.makeError(node, MESSAGE_NOT_INITIALIZED_USING_NEW_SYNTAX, new String[0]));
            if (this.style == JsMessage.Style.CLOSURE) {
                return;
            }
        }
        boolean isUnnamedMsg = JsMessageVisitor.isUnnamedMessageName(messageKey);
        JsMessage.Builder builder = new JsMessage.Builder(isUnnamedMsg ? null : messageKey);
        Mapping.OriginalMapping mapping = this.compiler.getSourceMapping(traversal.getSourceName(), traversal.getLineNumber(), traversal.getCharno());
        if (mapping != null) {
            builder.setSourceName(mapping.getOriginalFile());
        } else {
            builder.setSourceName(traversal.getSourceName());
        }
        try {
            if (isVar) {
                this.extractMessageFromVariable(builder, node, parent, parent.getParent());
            } else {
                this.extractMessageFrom(builder, msgNode, node);
            }
        }
        catch (MalformedException ex) {
            this.compiler.report(traversal.makeError(ex.getNode(), MESSAGE_TREE_MALFORMED, ex.getMessage()));
            return;
        }
        JsMessage extractedMessage = builder.build(this.idGenerator);
        if (this.needToCheckDuplications && !isUnnamedMsg && !extractedMessage.isExternal()) {
            this.checkIfMessageDuplicated(messageKey, msgNode);
        }
        this.trackMessage(traversal, extractedMessage, messageKey, msgNode, isUnnamedMsg);
        if (extractedMessage.isEmpty()) {
            this.compiler.report(traversal.makeError(node, MESSAGE_HAS_NO_TEXT, messageKey));
        }
        String desc = extractedMessage.getDesc();
        if (isNewStyleMessage && (desc == null || desc.trim().isEmpty()) && !extractedMessage.isExternal()) {
            this.compiler.report(traversal.makeError(node, MESSAGE_HAS_NO_DESCRIPTION, messageKey));
        }
        JsMessageDefinition msgDefinition = new JsMessageDefinition(msgNode);
        this.processJsMessage(extractedMessage, msgDefinition);
    }

    private void trackMessage(NodeTraversal t, JsMessage message, String msgName, Node msgNode, boolean isUnnamedMessage) {
        if (!isUnnamedMessage) {
            MessageLocation location = new MessageLocation(message, msgNode);
            this.messageNames.put(msgName, location);
        } else {
            Var var = (Var)t.getScope().getVar(msgName);
            if (var != null) {
                this.unnamedMessages.put(var, message);
            }
        }
    }

    private JsMessage getTrackedMessage(NodeTraversal t, String msgName) {
        boolean isUnnamedMessage = JsMessageVisitor.isUnnamedMessageName(msgName);
        if (!isUnnamedMessage) {
            MessageLocation location = this.messageNames.get(msgName);
            return location == null ? null : location.message;
        }
        Var var = (Var)t.getScope().getVar(msgName);
        if (var != null) {
            return this.unnamedMessages.get(var);
        }
        return null;
    }

    private void checkIfMessageDuplicated(String msgName, Node msgNode) {
        if (this.messageNames.containsKey(msgName)) {
            MessageLocation location = this.messageNames.get(msgName);
            this.compiler.report(JSError.make(msgNode, MESSAGE_DUPLICATE_KEY, msgName, location.messageNode.getSourceFileName(), Integer.toString(location.messageNode.getLineno())));
        }
    }

    private void extractMessageFromVariable(JsMessage.Builder builder, Node nameNode, Node parentNode, @Nullable Node grandParentNode) throws MalformedException {
        Node valueNode = nameNode.getFirstChild();
        switch (valueNode.getToken()) {
            case STRING: 
            case ADD: {
                this.maybeInitMetaDataFromJsDocOrHelpVar(builder, parentNode, grandParentNode);
                builder.appendStringPart(JsMessageVisitor.extractStringFromStringExprNode(valueNode));
                break;
            }
            case FUNCTION: {
                this.maybeInitMetaDataFromJsDocOrHelpVar(builder, parentNode, grandParentNode);
                this.extractFromFunctionNode(builder, valueNode);
                break;
            }
            case CALL: {
                JsMessageVisitor.maybeInitMetaDataFromJsDoc(builder, parentNode);
                this.extractFromCallNode(builder, valueNode);
                break;
            }
            default: {
                throw new MalformedException("Cannot parse value of message " + builder.getKey(), valueNode);
            }
        }
    }

    private void extractMessageFrom(JsMessage.Builder builder, Node valueNode, Node docNode) throws MalformedException {
        JsMessageVisitor.maybeInitMetaDataFromJsDoc(builder, docNode);
        this.extractFromCallNode(builder, valueNode);
    }

    private void maybeInitMetaDataFromJsDocOrHelpVar(JsMessage.Builder builder, Node varNode, @Nullable Node parentOfVarNode) throws MalformedException {
        if (JsMessageVisitor.maybeInitMetaDataFromJsDoc(builder, varNode)) {
            return;
        }
        if (parentOfVarNode != null && JsMessageVisitor.maybeInitMetaDataFromHelpVar(builder, varNode.getPrevious())) {
            return;
        }
        JsMessageVisitor.maybeInitMetaDataFromHelpVar(builder, varNode.getNext());
    }

    private static boolean maybeInitMetaDataFromHelpVar(JsMessage.Builder builder, @Nullable Node sibling) throws MalformedException {
        Node nameNode;
        String name;
        if (sibling != null && sibling.isVar() && (name = (nameNode = sibling.getFirstChild()).getString()).equals(builder.getKey() + DESC_SUFFIX)) {
            Node valueNode = nameNode.getFirstChild();
            String desc = JsMessageVisitor.extractStringFromStringExprNode(valueNode);
            if (desc.startsWith(HIDDEN_DESC_PREFIX)) {
                builder.setDesc(desc.substring(HIDDEN_DESC_PREFIX.length()).trim());
                builder.setIsHidden(true);
            } else {
                builder.setDesc(desc);
            }
            return true;
        }
        return false;
    }

    private static boolean maybeInitMetaDataFromJsDoc(JsMessage.Builder builder, Node node) {
        boolean messageHasDesc = false;
        JSDocInfo info = node.getJSDocInfo();
        if (info != null) {
            String desc = info.getDescription();
            if (desc != null) {
                builder.setDesc(desc);
                messageHasDesc = true;
            }
            if (info.isHidden()) {
                builder.setIsHidden(true);
            }
            if (info.getMeaning() != null) {
                builder.setMeaning(info.getMeaning());
            }
        }
        return messageHasDesc;
    }

    private static String extractStringFromStringExprNode(Node node) throws MalformedException {
        switch (node.getToken()) {
            case STRING: {
                return node.getString();
            }
            case TEMPLATELIT: {
                if (node.hasOneChild()) {
                    return (String)Preconditions.checkNotNull((Object)node.getFirstChild().getCookedString());
                }
                throw new MalformedException("Template literals with substitutions are not allowed.", node);
            }
            case ADD: {
                StringBuilder sb = new StringBuilder();
                for (Node child : node.children()) {
                    sb.append(JsMessageVisitor.extractStringFromStringExprNode(child));
                }
                return sb.toString();
            }
        }
        throw new MalformedException("STRING or ADD node expected; found: " + (Object)((Object)node.getToken()), node);
    }

    private void extractFromFunctionNode(JsMessage.Builder builder, Node node) throws MalformedException {
        HashSet<String> phNames = new HashSet<String>();
        block5: for (Node fnChild : node.children()) {
            switch (fnChild.getToken()) {
                case NAME: {
                    break;
                }
                case PARAM_LIST: {
                    for (Node argumentNode : fnChild.children()) {
                        if (!argumentNode.isName()) continue;
                        String phName = argumentNode.getString();
                        if (phNames.contains(phName)) {
                            throw new MalformedException("Duplicate placeholder name: " + phName, argumentNode);
                        }
                        phNames.add(phName);
                    }
                    continue block5;
                }
                case BLOCK: {
                    Node returnNode = fnChild.getFirstChild();
                    if (!returnNode.isReturn()) {
                        throw new MalformedException("RETURN node expected; found: " + (Object)((Object)returnNode.getToken()), returnNode);
                    }
                    for (Node child : returnNode.children()) {
                        JsMessageVisitor.extractFromReturnDescendant(builder, child);
                    }
                    for (String phName : builder.getPlaceholders()) {
                        if (phNames.contains(phName)) continue;
                        throw new MalformedException("Unrecognized message placeholder referenced: " + phName, returnNode);
                    }
                    continue block5;
                }
                default: {
                    throw new MalformedException("NAME, PARAM_LIST, or BLOCK node expected; found: " + node, fnChild);
                }
            }
        }
    }

    private static void extractFromReturnDescendant(JsMessage.Builder builder, Node node) throws MalformedException {
        switch (node.getToken()) {
            case STRING: {
                builder.appendStringPart(node.getString());
                break;
            }
            case NAME: {
                builder.appendPlaceholderReference(node.getString());
                break;
            }
            case ADD: {
                for (Node child : node.children()) {
                    JsMessageVisitor.extractFromReturnDescendant(builder, child);
                }
                break;
            }
            default: {
                throw new MalformedException("STRING, NAME, or ADD node expected; found: " + (Object)((Object)node.getToken()), node);
            }
        }
    }

    private void extractFromCallNode(JsMessage.Builder builder, Node node) throws MalformedException {
        if (!node.isCall()) {
            throw new MalformedException("Message must be initialized using goog.getMsg function.", node);
        }
        Node fnNameNode = node.getFirstChild();
        if (!fnNameNode.matchesQualifiedName(MSG_FUNCTION_NAME)) {
            throw new MalformedException("Message initialized using unrecognized function. Please use goog.getMsg() instead.", fnNameNode);
        }
        Node stringLiteralNode = fnNameNode.getNext();
        if (stringLiteralNode == null) {
            throw new MalformedException("Message string literal expected", stringLiteralNode);
        }
        JsMessageVisitor.parseMessageTextNode(builder, stringLiteralNode);
        Node objLitNode = stringLiteralNode.getNext();
        HashSet<String> phNames = new HashSet<String>();
        if (objLitNode != null) {
            if (!objLitNode.isObjectLit()) {
                throw new MalformedException("OBJLIT node expected", objLitNode);
            }
            for (Node aNode = objLitNode.getFirstChild(); aNode != null; aNode = aNode.getNext()) {
                if (!aNode.isStringKey()) {
                    throw new MalformedException("STRING_KEY node expected as OBJLIT key", aNode);
                }
                String phName = aNode.getString();
                if (!JsMessageVisitor.isLowerCamelCaseWithNumericSuffixes(phName)) {
                    throw new MalformedException("Placeholder name not in lowerCamelCase: " + phName, aNode);
                }
                if (phNames.contains(phName)) {
                    throw new MalformedException("Duplicate placeholder name: " + phName, aNode);
                }
                phNames.add(phName);
            }
        }
        Set<String> usedPlaceholders = builder.getPlaceholders();
        for (String phName : usedPlaceholders) {
            if (phNames.contains(phName)) continue;
            throw new MalformedException("Unrecognized message placeholder referenced: " + phName, node);
        }
        for (String phName : phNames) {
            if (usedPlaceholders.contains(phName)) continue;
            throw new MalformedException("Unused message placeholder: " + phName, node);
        }
    }

    private static void parseMessageTextNode(JsMessage.Builder builder, Node node) throws MalformedException {
        String value = JsMessageVisitor.extractStringFromStringExprNode(node);
        while (true) {
            int phEnd;
            int phBegin;
            if ((phBegin = value.indexOf(PH_JS_PREFIX)) < 0) {
                builder.appendStringPart(value);
                return;
            }
            if (phBegin > 0) {
                builder.appendStringPart(value.substring(0, phBegin));
            }
            if ((phEnd = value.indexOf(PH_JS_SUFFIX, phBegin)) < 0) {
                throw new MalformedException("Placeholder incorrectly formatted in: " + builder.getKey(), node);
            }
            String phName = value.substring(phBegin + PH_JS_PREFIX.length(), phEnd);
            builder.appendPlaceholderReference(phName);
            int nextPos = phEnd + PH_JS_SUFFIX.length();
            if (nextPos >= value.length()) break;
            value = value.substring(nextPos);
        }
    }

    private void visitFallbackFunctionCall(NodeTraversal t, Node call) {
        JsMessage secondMessage;
        JsMessage firstMessage;
        if (call.getChildCount() != 3 || !call.getSecondChild().isName() || !call.getLastChild().isName()) {
            this.compiler.report(t.makeError(call, BAD_FALLBACK_SYNTAX, new String[0]));
            return;
        }
        Node firstArg = call.getSecondChild();
        String name = firstArg.getOriginalName();
        if (name == null) {
            name = firstArg.getString();
        }
        if ((firstMessage = this.getTrackedMessage(t, name)) == null) {
            this.compiler.report(t.makeError(firstArg, FALLBACK_ARG_ERROR, name));
            return;
        }
        Node secondArg = firstArg.getNext();
        name = secondArg.getOriginalName();
        if (name == null) {
            name = secondArg.getString();
        }
        if ((secondMessage = this.getTrackedMessage(t, name)) == null) {
            this.compiler.report(t.makeError(secondArg, FALLBACK_ARG_ERROR, name));
            return;
        }
        this.processMessageFallback(call, firstMessage, secondMessage);
    }

    protected abstract void processJsMessage(JsMessage var1, JsMessageDefinition var2);

    void processMessageFallback(Node callNode, JsMessage message1, JsMessage message2) {
    }

    boolean isMessageName(String identifier, boolean isNewStyleMessage) {
        return identifier.startsWith(MSG_PREFIX) && (this.style == JsMessage.Style.CLOSURE || isNewStyleMessage || !identifier.endsWith(DESC_SUFFIX));
    }

    private static boolean isUnnamedMessageName(String identifier) {
        return MSG_UNNAMED_PATTERN.matcher(identifier).matches();
    }

    static boolean isLowerCamelCaseWithNumericSuffixes(String input) {
        return CAMELCASE_PATTERN.matcher(input).matches();
    }

    static String toLowerCamelCaseWithNumericSuffixes(String input) {
        int suffixStart = input.length();
        while (suffixStart > 0) {
            int numberStart;
            char ch = '\u0000';
            for (numberStart = suffixStart; numberStart > 0 && Character.isDigit(ch = input.charAt(numberStart - 1)); --numberStart) {
            }
            if (numberStart <= 0 || numberStart >= suffixStart || ch != '_') break;
            suffixStart = numberStart - 1;
        }
        if (suffixStart == input.length()) {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, input);
        }
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, input.substring(0, suffixStart)) + input.substring(suffixStart);
    }

    protected void checkNode(@Nullable Node node, Token type) throws MalformedException {
        if (node == null) {
            throw new MalformedException("Expected node type " + (Object)((Object)type) + "; found: null", node);
        }
        if (node.getToken() != type) {
            throw new MalformedException("Expected node type " + (Object)((Object)type) + "; found: " + (Object)((Object)node.getToken()), node);
        }
    }

    private static class MessageLocation {
        private final JsMessage message;
        private final Node messageNode;

        private MessageLocation(JsMessage message, Node messageNode) {
            this.message = message;
            this.messageNode = messageNode;
        }
    }

    static class MalformedException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final Node node;

        MalformedException(String message, Node node) {
            super(message);
            this.node = node;
        }

        Node getNode() {
            return this.node;
        }
    }
}

