/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Ordering;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.DependencyOptions;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.ModuleIdentifier;
import com.google.javascript.jscomp.deps.Es6SortedDependencies;
import com.google.javascript.jscomp.deps.SortedDependencies;
import com.google.javascript.jscomp.graph.LinkedDirectedGraph;
import com.google.javascript.jscomp.parsing.parser.util.format.SimpleFormat;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public final class JSModuleGraph
implements Serializable {
    private final JSModule[] modules;
    private final BitSet[] selfPlusTransitiveDeps;
    private final int[] subtreeSize;
    private final List<List<JSModule>> modulesByDepth;
    private final Map<JSModule, Set<JSModule>> dependencyMap = new IdentityHashMap<JSModule, Set<JSModule>>();

    public JSModuleGraph(JSModule[] modulesInDepOrder) {
        this(Arrays.asList(modulesInDepOrder));
    }

    public JSModuleGraph(List<JSModule> modulesInDepOrder) {
        Preconditions.checkState((!modulesInDepOrder.isEmpty() ? 1 : 0) != 0);
        this.modules = new JSModule[modulesInDepOrder.size()];
        for (int moduleIndex = 0; moduleIndex < this.modules.length; ++moduleIndex) {
            JSModule module = modulesInDepOrder.get(moduleIndex);
            Preconditions.checkState((module.getIndex() == -1 ? 1 : 0) != 0, (String)"Module index already set: %s", (Object)module);
            module.setIndex(moduleIndex);
            this.modules[moduleIndex] = module;
        }
        this.modulesByDepth = this.initModulesByDepth();
        this.selfPlusTransitiveDeps = this.initTransitiveDepsBitSets();
        this.subtreeSize = this.initSubtreeSize();
    }

    private List<List<JSModule>> initModulesByDepth() {
        ArrayList<List<JSModule>> tmpModulesByDepth = new ArrayList<List<JSModule>>();
        for (int moduleIndex = 0; moduleIndex < this.modules.length; ++moduleIndex) {
            JSModule module = this.modules[moduleIndex];
            Preconditions.checkState((module.getDepth() == -1 ? 1 : 0) != 0, (String)"Module depth already set: %s", (Object)module);
            int depth = 0;
            for (JSModule dep : module.getDependencies()) {
                int depDepth = dep.getDepth();
                if (depDepth < 0) {
                    throw new ModuleDependenceException(SimpleFormat.format("Modules not in dependency order: %s preceded %s", module.getName(), dep.getName()), module, dep);
                }
                depth = Math.max(depth, depDepth + 1);
            }
            module.setDepth(depth);
            if (depth == tmpModulesByDepth.size()) {
                tmpModulesByDepth.add(new ArrayList());
            }
            ((List)tmpModulesByDepth.get(depth)).add(module);
        }
        return tmpModulesByDepth;
    }

    private BitSet[] initTransitiveDepsBitSets() {
        BitSet[] array = new BitSet[this.modules.length];
        for (int moduleIndex = 0; moduleIndex < this.modules.length; ++moduleIndex) {
            BitSet selfPlusTransitiveDeps;
            JSModule module = this.modules[moduleIndex];
            array[moduleIndex] = selfPlusTransitiveDeps = new BitSet(moduleIndex + 1);
            selfPlusTransitiveDeps.set(moduleIndex);
            for (JSModule dep : module.getDependencies()) {
                selfPlusTransitiveDeps.or(array[dep.getIndex()]);
            }
        }
        return array;
    }

    private int[] initSubtreeSize() {
        int[] subtreeSize = new int[this.modules.length];
        for (int dependentIndex = 0; dependentIndex < this.modules.length; ++dependentIndex) {
            BitSet dependencies = this.selfPlusTransitiveDeps[dependentIndex];
            int requiredIndex = dependentIndex;
            while (requiredIndex >= 0) {
                int n = requiredIndex;
                subtreeSize[n] = subtreeSize[n] + 1;
                requiredIndex = dependencies.previousSetBit(requiredIndex - 1);
            }
        }
        return subtreeSize;
    }

    @Deprecated
    public void breakThisGraphSoItsModulesCanBeReused() {
        for (JSModule m : this.modules) {
            m.resetThisModuleSoItCanBeReused();
        }
    }

    Iterable<CompilerInput> getAllInputs() {
        return Iterables.concat((Iterable)Iterables.transform(Arrays.asList(this.modules), JSModule::getInputs));
    }

    int getInputCount() {
        int count = 0;
        for (JSModule module : this.modules) {
            count += module.getInputCount();
        }
        return count;
    }

    Iterable<JSModule> getAllModules() {
        return Arrays.asList(this.modules);
    }

    @Nullable
    JSModule getModuleByName(String name) {
        for (JSModule m : this.modules) {
            if (!m.getName().equals(name)) continue;
            return m;
        }
        return null;
    }

    Map<String, JSModule> getModulesByName() {
        HashMap<String, JSModule> result = new HashMap<String, JSModule>();
        for (JSModule m : this.modules) {
            result.put(m.getName(), m);
        }
        return result;
    }

    int getModuleCount() {
        return this.modules.length;
    }

    JSModule getRootModule() {
        return (JSModule)Iterables.getOnlyElement((Iterable)this.modulesByDepth.get(0));
    }

    @GwtIncompatible(value="com.google.gson")
    JsonArray toJson() {
        JsonArray modules = new JsonArray();
        for (JSModule module : this.getAllModules()) {
            Object m2;
            JsonObject node = new JsonObject();
            node.add("name", (JsonElement)new JsonPrimitive(module.getName()));
            JsonArray deps = new JsonArray();
            node.add("dependencies", (JsonElement)deps);
            for (Object m2 : module.getDependencies()) {
                deps.add((JsonElement)new JsonPrimitive(((JSModule)m2).getName()));
            }
            JsonArray transitiveDeps = new JsonArray();
            node.add("transitive-dependencies", (JsonElement)transitiveDeps);
            m2 = this.getTransitiveDepsDeepestFirst(module).iterator();
            while (m2.hasNext()) {
                JSModule m3 = (JSModule)m2.next();
                transitiveDeps.add((JsonElement)new JsonPrimitive(m3.getName()));
            }
            JsonArray inputs = new JsonArray();
            node.add("inputs", (JsonElement)inputs);
            for (CompilerInput input : module.getInputs()) {
                inputs.add((JsonElement)new JsonPrimitive(input.getSourceFile().getOriginalPath()));
            }
            modules.add((JsonElement)node);
        }
        return modules;
    }

    public boolean dependsOn(JSModule src, JSModule m) {
        return src != m && this.selfPlusTransitiveDeps[src.getIndex()].get(m.getIndex());
    }

    public JSModule getSmallestCoveringSubtree(JSModule parentTree, BitSet dependentModules) {
        int parentTreeIndex;
        Preconditions.checkState((!dependentModules.isEmpty() ? 1 : 0) != 0);
        int minDependentModuleIndex = this.modules.length;
        BitSet candidates = new BitSet(this.modules.length);
        candidates.set(0, this.modules.length, true);
        int dependentIndex = dependentModules.nextSetBit(0);
        while (dependentIndex >= 0) {
            minDependentModuleIndex = Math.min(minDependentModuleIndex, dependentIndex);
            candidates.and(this.selfPlusTransitiveDeps[dependentIndex]);
            dependentIndex = dependentModules.nextSetBit(dependentIndex + 1);
        }
        Preconditions.checkState((!candidates.isEmpty() ? 1 : 0) != 0, (String)"No common dependency found for %s", (Object)dependentModules);
        int bestCandidateIndex = parentTreeIndex = parentTree.getIndex();
        int candidateIndex = candidates.previousSetBit(minDependentModuleIndex);
        while (candidateIndex >= 0) {
            BitSet candidatePlusTransitiveDeps = this.selfPlusTransitiveDeps[candidateIndex];
            if (candidatePlusTransitiveDeps.get(parentTreeIndex)) {
                candidates.andNot(candidatePlusTransitiveDeps);
                if (this.subtreeSize[candidateIndex] < this.subtreeSize[bestCandidateIndex]) {
                    bestCandidateIndex = candidateIndex;
                }
            }
            candidateIndex = candidates.previousSetBit(candidateIndex - 1);
        }
        return this.modules[bestCandidateIndex];
    }

    JSModule getDeepestCommonDependency(JSModule m1, JSModule m2) {
        int m1Depth = m1.getDepth();
        int m2Depth = m2.getDepth();
        for (int depth = Math.min(m1Depth, m2Depth) - 1; depth >= 0; --depth) {
            List<JSModule> modulesAtDepth = this.modulesByDepth.get(depth);
            for (int i = modulesAtDepth.size() - 1; i >= 0; --i) {
                JSModule m = modulesAtDepth.get(i);
                if (!this.dependsOn(m1, m) || !this.dependsOn(m2, m)) continue;
                return m;
            }
        }
        return null;
    }

    public JSModule getDeepestCommonDependencyInclusive(JSModule m1, JSModule m2) {
        if (m2 == m1 || this.dependsOn(m2, m1)) {
            return m1;
        }
        if (this.dependsOn(m1, m2)) {
            return m2;
        }
        return this.getDeepestCommonDependency(m1, m2);
    }

    public JSModule getDeepestCommonDependencyInclusive(Collection<JSModule> modules) {
        Iterator<JSModule> iter = modules.iterator();
        JSModule dep = iter.next();
        while (iter.hasNext()) {
            dep = this.getDeepestCommonDependencyInclusive(dep, iter.next());
        }
        return dep;
    }

    @VisibleForTesting
    List<JSModule> getTransitiveDepsDeepestFirst(JSModule m) {
        return InverseDepthComparator.INSTANCE.sortedCopy(this.getTransitiveDeps(m));
    }

    private Set<JSModule> getTransitiveDeps(JSModule m) {
        Set deps = this.dependencyMap.computeIfAbsent(m, JSModule::getAllDependencies);
        return deps;
    }

    public ImmutableList<CompilerInput> manageDependencies(DependencyOptions depOptions) throws SortedDependencies.MissingProvideException, MissingModuleException {
        ImmutableList originalInputs = ImmutableList.copyOf(this.getAllInputs());
        Es6SortedDependencies<CompilerInput> sorter = new Es6SortedDependencies<CompilerInput>((List<CompilerInput>)originalInputs);
        Set<CompilerInput> entryPointInputs = this.createEntryPointInputs(depOptions, this.getAllInputs(), sorter);
        HashMap<String, CompilerInput> inputsByProvide = new HashMap<String, CompilerInput>();
        for (CompilerInput input : originalInputs) {
            for (String provide : input.getKnownProvides()) {
                inputsByProvide.put(provide, input);
            }
            String moduleName = input.getPath().toModuleName();
            inputsByProvide.putIfAbsent(moduleName, input);
        }
        for (CompilerInput input : originalInputs) {
            for (String require : input.getDynamicRequires()) {
                if (!inputsByProvide.containsKey(require)) continue;
                entryPointInputs.add((CompilerInput)inputsByProvide.get(require));
            }
        }
        List<CompilerInput> absoluteOrder = sorter.getDependenciesOf((List<CompilerInput>)originalInputs, depOptions.shouldSortDependencies());
        LinkedListMultimap entryPointInputsPerModule = LinkedListMultimap.create();
        for (CompilerInput input : entryPointInputs) {
            Iterator<Object> module = input.getModule();
            Preconditions.checkNotNull((Object)module);
            entryPointInputsPerModule.put((Object)module, (Object)input);
        }
        for (JSModule module : this.getAllModules()) {
            module.removeAll();
        }
        List<Object> orderedInputs = new ArrayList();
        HashSet<CompilerInput> reachedInputs = new HashSet<CompilerInput>();
        for (JSModule module : entryPointInputsPerModule.keySet()) {
            List<Object> transitiveClosure;
            if (depOptions.shouldSortDependencies() && depOptions.shouldPruneDependencies()) {
                transitiveClosure = new ArrayList();
                HashSet<CompilerInput> inputsNotYetReached = new HashSet<CompilerInput>((Collection<CompilerInput>)originalInputs);
                for (CompilerInput entryPoint : entryPointInputsPerModule.get((Object)module)) {
                    transitiveClosure.addAll(this.getDepthFirstDependenciesOf(entryPoint, inputsNotYetReached, inputsByProvide));
                }
                for (CompilerInput orderedInput : transitiveClosure) {
                    if (!reachedInputs.add(orderedInput)) continue;
                    orderedInputs.add(orderedInput);
                }
            } else {
                transitiveClosure = sorter.getDependenciesOf((List<CompilerInput>)entryPointInputsPerModule.get((Object)module), depOptions.shouldSortDependencies());
            }
            for (CompilerInput input : transitiveClosure) {
                JSModule oldModule = input.getModule();
                if (oldModule == null) {
                    input.setModule(module);
                    continue;
                }
                input.setModule(null);
                input.setModule(this.getDeepestCommonDependencyInclusive(oldModule, module));
            }
        }
        if (!depOptions.shouldSortDependencies() || !depOptions.shouldPruneDependencies() || entryPointInputsPerModule.isEmpty()) {
            orderedInputs = absoluteOrder;
        }
        for (CompilerInput input : orderedInputs) {
            JSModule module = input.getModule();
            if (module == null) continue;
            module.add(input);
        }
        ImmutableList.Builder result = ImmutableList.builder();
        for (JSModule module : this.getAllModules()) {
            result.addAll(module.getInputs());
        }
        return result.build();
    }

    private List<CompilerInput> getDepthFirstDependenciesOf(CompilerInput rootInput, Set<CompilerInput> unreachedInputs, Map<String, CompilerInput> inputsByProvide) {
        ArrayList<CompilerInput> orderedInputs = new ArrayList<CompilerInput>();
        if (!unreachedInputs.remove(rootInput)) {
            return orderedInputs;
        }
        for (String importedNamespace : rootInput.getRequiredSymbols()) {
            CompilerInput dependency = null;
            if (inputsByProvide.containsKey(importedNamespace) && unreachedInputs.contains(inputsByProvide.get(importedNamespace))) {
                dependency = inputsByProvide.get(importedNamespace);
            }
            if (dependency == null) continue;
            orderedInputs.addAll(this.getDepthFirstDependenciesOf(dependency, unreachedInputs, inputsByProvide));
        }
        orderedInputs.add(rootInput);
        return orderedInputs;
    }

    private Set<CompilerInput> createEntryPointInputs(DependencyOptions depOptions, Iterable<CompilerInput> inputs, SortedDependencies<CompilerInput> sorter) throws MissingModuleException, SortedDependencies.MissingProvideException {
        LinkedHashSet<CompilerInput> entryPointInputs = new LinkedHashSet<CompilerInput>();
        Map<String, JSModule> modulesByName = this.getModulesByName();
        if (depOptions.shouldPruneDependencies()) {
            CompilerInput baseJs = sorter.maybeGetInputProviding("goog");
            if (baseJs != null) {
                entryPointInputs.add(baseJs);
            }
            if (!depOptions.shouldDropMoochers()) {
                entryPointInputs.addAll(sorter.getInputsWithoutProvides());
            }
            for (ModuleIdentifier entryPoint : depOptions.getEntryPoints()) {
                CompilerInput entryPointInput = null;
                try {
                    if (entryPoint.getClosureNamespace().equals(entryPoint.getModuleName())) {
                        entryPointInput = sorter.maybeGetInputProviding(entryPoint.getClosureNamespace());
                        if (entryPointInput == null) {
                            entryPointInput = sorter.getInputProviding(entryPoint.getName());
                        }
                    } else {
                        JSModule module = modulesByName.get(entryPoint.getModuleName());
                        if (module == null) {
                            throw new MissingModuleException(entryPoint.getModuleName());
                        }
                        entryPointInput = sorter.getInputProviding(entryPoint.getClosureNamespace());
                        entryPointInput.overrideModule(module);
                    }
                }
                catch (SortedDependencies.MissingProvideException e) {
                    throw new SortedDependencies.MissingProvideException(entryPoint.getName(), e);
                }
                entryPointInputs.add(entryPointInput);
            }
        } else {
            Iterables.addAll(entryPointInputs, inputs);
        }
        return entryPointInputs;
    }

    LinkedDirectedGraph<JSModule, String> toGraphvizGraph() {
        LinkedDirectedGraph<JSModule, String> graphViz = LinkedDirectedGraph.create();
        for (JSModule module : this.getAllModules()) {
            graphViz.createNode((Object)module);
            for (JSModule dep : module.getDependencies()) {
                graphViz.createNode((Object)dep);
                graphViz.connect(module, "->", dep);
            }
        }
        return graphViz;
    }

    private static int depthCompare(JSModule m1, JSModule m2) {
        int d2;
        if (m1 == m2) {
            return 0;
        }
        int d1 = m1.getDepth();
        return d1 < (d2 = m2.getDepth()) ? -1 : (d2 == d1 ? m1.getName().compareTo(m2.getName()) : 1);
    }

    public static class MissingModuleException
    extends Exception {
        MissingModuleException(String moduleName) {
            super(moduleName);
        }
    }

    protected static class ModuleDependenceException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;
        private final JSModule module;
        private final JSModule dependentModule;

        protected ModuleDependenceException(String message, JSModule module, JSModule dependentModule) {
            super(message);
            this.module = module;
            this.dependentModule = dependentModule;
        }

        public JSModule getModule() {
            return this.module;
        }

        public JSModule getDependentModule() {
            return this.dependentModule;
        }
    }

    private static final class InverseDepthComparator
    extends Ordering<JSModule> {
        static final InverseDepthComparator INSTANCE = new InverseDepthComparator();

        private InverseDepthComparator() {
        }

        public int compare(JSModule m1, JSModule m2) {
            return JSModuleGraph.depthCompare(m2, m1);
        }
    }
}

