/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import com.google.api.client.util.Key;
import com.google.common.collect.ImmutableMap;
import com.google.firebase.internal.NonNull;
import com.google.firebase.messaging.WebpushNotification;
import java.util.HashMap;
import java.util.Map;

public class WebpushConfig {
    @Key(value="headers")
    private final Map<String, String> headers;
    @Key(value="data")
    private final Map<String, String> data;
    @Key(value="notification")
    private final WebpushNotification notification;

    private WebpushConfig(Builder builder) {
        this.headers = builder.headers.isEmpty() ? null : ImmutableMap.copyOf((Map)builder.headers);
        this.data = builder.data.isEmpty() ? null : ImmutableMap.copyOf((Map)builder.data);
        this.notification = builder.notification;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<String, String> headers = new HashMap<String, String>();
        private final Map<String, String> data = new HashMap<String, String>();
        private WebpushNotification notification;

        private Builder() {
        }

        public Builder putHeader(@NonNull String key, @NonNull String value) {
            this.headers.put(key, value);
            return this;
        }

        public Builder putAllHeaders(@NonNull Map<String, String> map) {
            this.headers.putAll(map);
            return this;
        }

        public Builder putData(String key, String value) {
            this.data.put(key, value);
            return this;
        }

        public Builder putAllData(Map<String, String> map) {
            this.data.putAll(map);
            return this;
        }

        public Builder setNotification(WebpushNotification notification) {
            this.notification = notification;
            return this;
        }

        public WebpushConfig build() {
            return new WebpushConfig(this);
        }
    }
}

