/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.internal;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.firebase.FirebaseApp;
import com.google.firebase.ThreadManager;
import com.google.firebase.internal.GaeExecutorService;
import com.google.firebase.internal.GaeThreadFactory;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirebaseThreadManagers {
    private static final Logger logger = LoggerFactory.getLogger(FirebaseThreadManagers.class);
    public static final ThreadManager DEFAULT_THREAD_MANAGER = GaeThreadFactory.isAvailable() ? new GaeThreadManager() : new DefaultThreadManager();

    private static class GaeThreadManager
    extends GlobalThreadManager {
        private GaeThreadManager() {
        }

        @Override
        protected ExecutorService doInit() {
            return new GaeExecutorService("gae-firebase-default");
        }

        @Override
        protected void doCleanup(ExecutorService executorService) {
            executorService.shutdownNow();
        }

        @Override
        protected ThreadFactory getThreadFactory() {
            GaeThreadFactory threadFactory = GaeThreadFactory.getInstance();
            Preconditions.checkState((boolean)threadFactory.isUsingBackgroundThreads(), (Object)"Failed to initialize a GAE background thread factory. Background thread support is required to create long-lived threads.");
            return threadFactory;
        }
    }

    private static class DefaultThreadManager
    extends GlobalThreadManager {
        private DefaultThreadManager() {
        }

        @Override
        protected ExecutorService doInit() {
            ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("firebase-default-%d").setDaemon(true).setThreadFactory(this.getThreadFactory()).build();
            return Executors.newCachedThreadPool(threadFactory);
        }

        @Override
        protected void doCleanup(ExecutorService executorService) {
            logger.debug("Shutting down default executor");
            executorService.shutdownNow();
        }

        @Override
        protected ThreadFactory getThreadFactory() {
            return Executors.defaultThreadFactory();
        }
    }

    static abstract class GlobalThreadManager
    extends ThreadManager {
        private final Object lock = new Object();
        private final Set<String> apps = new HashSet<String>();
        private ExecutorService executorService;

        GlobalThreadManager() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected ExecutorService getExecutor(FirebaseApp app) {
            Object object = this.lock;
            synchronized (object) {
                if (this.executorService == null) {
                    this.executorService = this.doInit();
                }
                this.apps.add(app.getName());
                return this.executorService;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void releaseExecutor(FirebaseApp app, ExecutorService executor) {
            Object object = this.lock;
            synchronized (object) {
                if (this.apps.remove(app.getName()) && this.apps.isEmpty()) {
                    this.doCleanup(this.executorService);
                    this.executorService = null;
                }
            }
        }

        protected abstract ExecutorService doInit();

        protected abstract void doCleanup(ExecutorService var1);
    }
}

