/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.logging;

import com.google.firebase.database.logging.Logger;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.slf4j.LoggerFactory;

public class LogWrapper {
    private final org.slf4j.Logger slf4jLogger;
    private final Logger logger;
    private final String component;
    private final String prefix;

    public LogWrapper(Logger logger, Class component) {
        this(logger, component, null);
    }

    public LogWrapper(Logger logger, Class component, String prefix) {
        this.slf4jLogger = LoggerFactory.getLogger((Class)component);
        this.logger = logger;
        this.component = component.getName();
        this.prefix = prefix;
    }

    public LogWrapper(Logger logger, String component, String prefix) {
        this.slf4jLogger = LoggerFactory.getLogger((String)component);
        this.logger = logger;
        this.component = component;
        this.prefix = prefix;
    }

    private static String exceptionStacktrace(Throwable e) {
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        e.printStackTrace(printWriter);
        return writer.toString();
    }

    public void error(String message, Throwable e) {
        if (this.slf4jLogger.isErrorEnabled()) {
            this.slf4jLogger.error(this.toLog(message, new Object[0]), e);
        } else {
            String logMsg = this.toLog(message, new Object[0]) + "\n" + LogWrapper.exceptionStacktrace(e);
            this.logger.onLogMessage(Logger.Level.ERROR, this.component, logMsg, this.now());
        }
    }

    public void warn(String message) {
        this.warn(message, null);
    }

    public void warn(String message, Throwable e) {
        if (this.slf4jLogger.isWarnEnabled()) {
            this.slf4jLogger.warn(this.toLog(message, new Object[0]), e);
        } else {
            String logMsg = this.toLog(message, new Object[0]);
            if (e != null) {
                logMsg = logMsg + "\n" + LogWrapper.exceptionStacktrace(e);
            }
            this.logger.onLogMessage(Logger.Level.WARN, this.component, logMsg, this.now());
        }
    }

    public void info(String message) {
        if (this.slf4jLogger.isInfoEnabled()) {
            this.slf4jLogger.info(this.toLog(message, new Object[0]));
        } else {
            this.logger.onLogMessage(Logger.Level.INFO, this.component, this.toLog(message, new Object[0]), this.now());
        }
    }

    public void debug(String message, Object ... args) {
        this.debug(message, null, args);
    }

    public void debug(String message, Throwable e, Object ... args) {
        if (this.slf4jLogger.isDebugEnabled()) {
            this.slf4jLogger.debug(this.toLog(message, args), e);
        } else {
            String logMsg = this.toLog(message, args);
            if (e != null) {
                logMsg = logMsg + "\n" + LogWrapper.exceptionStacktrace(e);
            }
            this.logger.onLogMessage(Logger.Level.DEBUG, this.component, logMsg, this.now());
        }
    }

    public boolean logsDebug() {
        return this.logger.getLogLevel().ordinal() <= Logger.Level.DEBUG.ordinal() || this.slf4jLogger.isDebugEnabled();
    }

    private long now() {
        return System.currentTimeMillis();
    }

    private String toLog(String message, Object ... args) {
        String formatted = args.length > 0 ? String.format(message, args) : message;
        return this.prefix == null ? formatted : this.prefix + " - " + formatted;
    }
}

