/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink;

import com.google.crypto.tink.KeyManager;
import com.google.crypto.tink.KeyManagerImpl;
import com.google.crypto.tink.PrivateKeyManagerImpl;
import com.google.crypto.tink.config.internal.TinkFipsUtil;
import com.google.crypto.tink.internal.KeyTypeManager;
import com.google.crypto.tink.internal.PrivateKeyTypeManager;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.shaded.protobuf.ByteString;
import com.google.crypto.tink.shaded.protobuf.InvalidProtocolBufferException;
import com.google.crypto.tink.shaded.protobuf.MessageLite;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;

final class KeyManagerRegistry {
    private static final Logger logger = Logger.getLogger(KeyManagerRegistry.class.getName());
    private final ConcurrentMap<String, KeyManagerContainer> keyManagerMap;

    KeyManagerRegistry(KeyManagerRegistry original) {
        this.keyManagerMap = new ConcurrentHashMap<String, KeyManagerContainer>(original.keyManagerMap);
    }

    KeyManagerRegistry() {
        this.keyManagerMap = new ConcurrentHashMap<String, KeyManagerContainer>();
    }

    private static <P> KeyManagerContainer createContainerFor(KeyManager<P> keyManager) {
        final KeyManager<P> localKeyManager = keyManager;
        return new KeyManagerContainer(){

            public <Q> KeyManager<Q> getKeyManager(Class<Q> primitiveClass) throws GeneralSecurityException {
                if (!localKeyManager.getPrimitiveClass().equals(primitiveClass)) {
                    throw new InternalError("This should never be called, as we always first check supportedPrimitives.");
                }
                KeyManager result = localKeyManager;
                return result;
            }

            @Override
            public KeyManager<?> getUntypedKeyManager() {
                return localKeyManager;
            }

            @Override
            public Class<?> getImplementingClass() {
                return localKeyManager.getClass();
            }

            @Override
            public Set<Class<?>> supportedPrimitives() {
                return Collections.singleton(localKeyManager.getPrimitiveClass());
            }

            @Override
            public Class<?> publicKeyManagerClassOrNull() {
                return null;
            }

            @Override
            public MessageLite parseKey(ByteString serializedKey) throws GeneralSecurityException, InvalidProtocolBufferException {
                return null;
            }
        };
    }

    private static <KeyProtoT extends MessageLite> KeyManagerContainer createContainerFor(KeyTypeManager<KeyProtoT> keyManager) {
        final KeyTypeManager<KeyProtoT> localKeyManager = keyManager;
        return new KeyManagerContainer(){

            public <Q> KeyManager<Q> getKeyManager(Class<Q> primitiveClass) throws GeneralSecurityException {
                try {
                    return new KeyManagerImpl(localKeyManager, primitiveClass);
                }
                catch (IllegalArgumentException e) {
                    throw new GeneralSecurityException("Primitive type not supported", e);
                }
            }

            @Override
            public KeyManager<?> getUntypedKeyManager() {
                return new KeyManagerImpl(localKeyManager, localKeyManager.firstSupportedPrimitiveClass());
            }

            @Override
            public Class<?> getImplementingClass() {
                return localKeyManager.getClass();
            }

            @Override
            public Set<Class<?>> supportedPrimitives() {
                return localKeyManager.supportedPrimitives();
            }

            @Override
            public Class<?> publicKeyManagerClassOrNull() {
                return null;
            }

            @Override
            public MessageLite parseKey(ByteString serializedKey) throws GeneralSecurityException, InvalidProtocolBufferException {
                Object result = localKeyManager.parseKey(serializedKey);
                localKeyManager.validateKey(result);
                return result;
            }
        };
    }

    private static <KeyProtoT extends MessageLite, PublicKeyProtoT extends MessageLite> KeyManagerContainer createPrivateKeyContainerFor(PrivateKeyTypeManager<KeyProtoT, PublicKeyProtoT> privateKeyTypeManager, KeyTypeManager<PublicKeyProtoT> publicKeyTypeManager) {
        final PrivateKeyTypeManager<KeyProtoT, PublicKeyProtoT> localPrivateKeyManager = privateKeyTypeManager;
        final KeyTypeManager<PublicKeyProtoT> localPublicKeyManager = publicKeyTypeManager;
        return new KeyManagerContainer(){

            public <Q> KeyManager<Q> getKeyManager(Class<Q> primitiveClass) throws GeneralSecurityException {
                try {
                    return new PrivateKeyManagerImpl(localPrivateKeyManager, localPublicKeyManager, primitiveClass);
                }
                catch (IllegalArgumentException e) {
                    throw new GeneralSecurityException("Primitive type not supported", e);
                }
            }

            @Override
            public KeyManager<?> getUntypedKeyManager() {
                return new PrivateKeyManagerImpl(localPrivateKeyManager, localPublicKeyManager, localPrivateKeyManager.firstSupportedPrimitiveClass());
            }

            @Override
            public Class<?> getImplementingClass() {
                return localPrivateKeyManager.getClass();
            }

            @Override
            public Set<Class<?>> supportedPrimitives() {
                return localPrivateKeyManager.supportedPrimitives();
            }

            @Override
            public Class<?> publicKeyManagerClassOrNull() {
                return localPublicKeyManager.getClass();
            }

            @Override
            public MessageLite parseKey(ByteString serializedKey) throws GeneralSecurityException, InvalidProtocolBufferException {
                Object result = localPrivateKeyManager.parseKey(serializedKey);
                localPrivateKeyManager.validateKey(result);
                return result;
            }
        };
    }

    private synchronized KeyManagerContainer getKeyManagerContainerOrThrow(String typeUrl) throws GeneralSecurityException {
        if (!this.keyManagerMap.containsKey(typeUrl)) {
            throw new GeneralSecurityException("No key manager found for key type " + typeUrl);
        }
        return (KeyManagerContainer)this.keyManagerMap.get(typeUrl);
    }

    private static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    private synchronized <P> void registerKeyManagerContainer(KeyManagerContainer containerToInsert, boolean forceOverwrite) throws GeneralSecurityException {
        String typeUrl = containerToInsert.getUntypedKeyManager().getKeyType();
        KeyManagerContainer container = (KeyManagerContainer)this.keyManagerMap.get(typeUrl);
        if (container != null && !container.getImplementingClass().equals(containerToInsert.getImplementingClass())) {
            logger.warning("Attempted overwrite of a registered key manager for key type " + typeUrl);
            throw new GeneralSecurityException(String.format("typeUrl (%s) is already registered with %s, cannot be re-registered with %s", typeUrl, container.getImplementingClass().getName(), containerToInsert.getImplementingClass().getName()));
        }
        if (!forceOverwrite) {
            this.keyManagerMap.putIfAbsent(typeUrl, containerToInsert);
        } else {
            this.keyManagerMap.put(typeUrl, containerToInsert);
        }
    }

    synchronized <P> void registerKeyManager(KeyManager<P> manager) throws GeneralSecurityException {
        if (!TinkFipsUtil.AlgorithmFipsCompatibility.ALGORITHM_NOT_FIPS.isCompatible()) {
            throw new GeneralSecurityException("Registering key managers is not supported in FIPS mode");
        }
        this.registerKeyManagerContainer(KeyManagerRegistry.createContainerFor(manager), false);
    }

    synchronized <KeyProtoT extends MessageLite> void registerKeyManager(KeyTypeManager<KeyProtoT> manager) throws GeneralSecurityException {
        if (!manager.fipsStatus().isCompatible()) {
            throw new GeneralSecurityException("failed to register key manager " + manager.getClass() + " as it is not FIPS compatible.");
        }
        this.registerKeyManagerContainer(KeyManagerRegistry.createContainerFor(manager), false);
    }

    synchronized <KeyProtoT extends MessageLite, PublicKeyProtoT extends MessageLite> void registerAsymmetricKeyManagers(PrivateKeyTypeManager<KeyProtoT, PublicKeyProtoT> privateKeyTypeManager, KeyTypeManager<PublicKeyProtoT> publicKeyTypeManager) throws GeneralSecurityException {
        Class<?> existingPublicKeyManagerClass;
        TinkFipsUtil.AlgorithmFipsCompatibility fipsStatusPrivateKey = privateKeyTypeManager.fipsStatus();
        TinkFipsUtil.AlgorithmFipsCompatibility fipsStatusPublicKey = publicKeyTypeManager.fipsStatus();
        if (!fipsStatusPrivateKey.isCompatible()) {
            throw new GeneralSecurityException("failed to register key manager " + privateKeyTypeManager.getClass() + " as it is not FIPS compatible.");
        }
        if (!fipsStatusPublicKey.isCompatible()) {
            throw new GeneralSecurityException("failed to register key manager " + publicKeyTypeManager.getClass() + " as it is not FIPS compatible.");
        }
        String privateTypeUrl = privateKeyTypeManager.getKeyType();
        String publicTypeUrl = publicKeyTypeManager.getKeyType();
        if (this.keyManagerMap.containsKey(privateTypeUrl) && ((KeyManagerContainer)this.keyManagerMap.get(privateTypeUrl)).publicKeyManagerClassOrNull() != null && (existingPublicKeyManagerClass = ((KeyManagerContainer)this.keyManagerMap.get(privateTypeUrl)).publicKeyManagerClassOrNull()) != null && !existingPublicKeyManagerClass.getName().equals(publicKeyTypeManager.getClass().getName())) {
            logger.warning("Attempted overwrite of a registered key manager for key type " + privateTypeUrl + " with inconsistent public key type " + publicTypeUrl);
            throw new GeneralSecurityException(String.format("public key manager corresponding to %s is already registered with %s, cannot be re-registered with %s", privateKeyTypeManager.getClass().getName(), existingPublicKeyManagerClass.getName(), publicKeyTypeManager.getClass().getName()));
        }
        this.registerKeyManagerContainer(KeyManagerRegistry.createPrivateKeyContainerFor(privateKeyTypeManager, publicKeyTypeManager), true);
        this.registerKeyManagerContainer(KeyManagerRegistry.createContainerFor(publicKeyTypeManager), false);
    }

    boolean typeUrlExists(String typeUrl) {
        return this.keyManagerMap.containsKey(typeUrl);
    }

    private static String toCommaSeparatedString(Set<Class<?>> setOfClasses) {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (Class<?> clazz : setOfClasses) {
            if (!first) {
                b.append(", ");
            }
            b.append(clazz.getCanonicalName());
            first = false;
        }
        return b.toString();
    }

    @Deprecated
    <P> KeyManager<P> getKeyManager(String typeUrl) throws GeneralSecurityException {
        return this.getKeyManagerInternal(typeUrl, null);
    }

    <P> KeyManager<P> getKeyManager(String typeUrl, Class<P> primitiveClass) throws GeneralSecurityException {
        return this.getKeyManagerInternal(typeUrl, KeyManagerRegistry.checkNotNull(primitiveClass));
    }

    private <P> KeyManager<P> getKeyManagerInternal(String typeUrl, Class<P> primitiveClass) throws GeneralSecurityException {
        KeyManagerContainer container = this.getKeyManagerContainerOrThrow(typeUrl);
        if (primitiveClass == null) {
            KeyManager<?> result = container.getUntypedKeyManager();
            return result;
        }
        if (container.supportedPrimitives().contains(primitiveClass)) {
            return container.getKeyManager(primitiveClass);
        }
        throw new GeneralSecurityException("Primitive type " + primitiveClass.getName() + " not supported by key manager of type " + container.getImplementingClass() + ", supported primitives: " + KeyManagerRegistry.toCommaSeparatedString(container.supportedPrimitives()));
    }

    KeyManager<?> getUntypedKeyManager(String typeUrl) throws GeneralSecurityException {
        KeyManagerContainer container = this.getKeyManagerContainerOrThrow(typeUrl);
        return container.getUntypedKeyManager();
    }

    MessageLite parseKeyData(KeyData keyData) throws GeneralSecurityException, InvalidProtocolBufferException {
        KeyManagerContainer container = this.getKeyManagerContainerOrThrow(keyData.getTypeUrl());
        return container.parseKey(keyData.getValue());
    }

    boolean isEmpty() {
        return this.keyManagerMap.isEmpty();
    }

    private static interface KeyManagerContainer {
        public <P> KeyManager<P> getKeyManager(Class<P> var1) throws GeneralSecurityException;

        public KeyManager<?> getUntypedKeyManager();

        public Class<?> getImplementingClass();

        public Set<Class<?>> supportedPrimitives();

        public Class<?> publicKeyManagerClassOrNull();

        public MessageLite parseKey(ByteString var1) throws GeneralSecurityException, InvalidProtocolBufferException;
    }
}

