/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.ApiFuture;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptions;
import com.google.api.gax.rpc.ApiStreamObserver;
import com.google.cloud.firestore.FieldPath;
import com.google.cloud.firestore.FirestoreException;
import com.google.cloud.firestore.FirestoreRpcContext;
import com.google.cloud.firestore.Order;
import com.google.cloud.firestore.Query;
import com.google.cloud.firestore.QueryPartition;
import com.google.cloud.firestore.TraceUtil;
import com.google.cloud.firestore.UserDataConverter;
import com.google.cloud.firestore.v1.FirestoreClient;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.firestore.v1.Cursor;
import com.google.firestore.v1.PartitionQueryRequest;
import io.opencensus.common.Scope;
import io.opencensus.trace.Span;
import io.opencensus.trace.Status;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class CollectionGroup
extends Query {
    final Query partitionQuery = this.orderBy(FieldPath.DOCUMENT_ID);

    CollectionGroup(FirestoreRpcContext<?> rpcContext, String collectionId) {
        super(rpcContext, Query.QueryOptions.builder().setParentPath(rpcContext.getResourcePath()).setCollectionId(collectionId).setAllDescendants(true).build());
    }

    public void getPartitions(long desiredPartitionCount, final ApiStreamObserver<QueryPartition> observer) {
        if (desiredPartitionCount == 1L) {
            observer.onNext((Object)new QueryPartition(this.partitionQuery, null, null));
        } else {
            PartitionQueryRequest request = this.buildRequest(desiredPartitionCount);
            TraceUtil traceUtil = TraceUtil.getInstance();
            Span span = traceUtil.startSpan("CloudFirestoreOperation.partitionQuery");
            try (Scope scope = traceUtil.getTracer().withSpan(span);){
                FirestoreClient.PartitionQueryPagedResponse response = (FirestoreClient.PartitionQueryPagedResponse)((Object)ApiExceptions.callAndTranslateApiException(this.rpcContext.sendRequest(request, this.rpcContext.getClient().partitionQueryPagedCallable())));
                this.consumePartitions(response, new Function<QueryPartition, Void>(){

                    public Void apply(QueryPartition queryPartition) {
                        observer.onNext((Object)queryPartition);
                        return null;
                    }
                });
                observer.onCompleted();
            }
            catch (ApiException exception) {
                span.setStatus(Status.UNKNOWN.withDescription(exception.getMessage()));
                throw FirestoreException.forApiException(exception);
            }
            finally {
                span.end(TraceUtil.END_SPAN_OPTIONS);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public ApiFuture<List<QueryPartition>> getPartitions(long desiredPartitionCount) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private PartitionQueryRequest buildRequest(long desiredPartitionCount) {
        Preconditions.checkArgument((desiredPartitionCount > 0L ? 1 : 0) != 0, (Object)"Desired partition count must be one or greater");
        PartitionQueryRequest.Builder request = PartitionQueryRequest.newBuilder();
        request.setStructuredQuery(this.partitionQuery.buildQuery());
        request.setParent(this.options.getParentPath().toString());
        request.setPartitionCount(desiredPartitionCount - 1L);
        return request.build();
    }

    private void consumePartitions(FirestoreClient.PartitionQueryPagedResponse response, Function<QueryPartition, Void> consumer) {
        ArrayList<Cursor> cursors = new ArrayList<Cursor>();
        for (Cursor cursor : response.iterateAll()) {
            cursors.add(cursor);
        }
        Collections.sort(cursors, new Comparator<Cursor>(){

            @Override
            public int compare(Cursor left, Cursor right) {
                return Order.INSTANCE.compareArrays(left.getValuesList(), right.getValuesList());
            }
        });
        Object[] lastCursor = null;
        for (Cursor cursor : cursors) {
            Object[] decodedCursorValue = new Object[cursor.getValuesCount()];
            for (int i = 0; i < cursor.getValuesCount(); ++i) {
                decodedCursorValue[i] = UserDataConverter.decodeValue(this.rpcContext, cursor.getValues(i));
            }
            consumer.apply((Object)new QueryPartition(this.partitionQuery, lastCursor, decodedCursorValue));
            lastCursor = decodedCursorValue;
        }
        consumer.apply((Object)new QueryPartition(this.partitionQuery, lastCursor, null));
    }
}

