/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.common;

import com.google.auto.common.MoreElements;
import com.google.common.base.Equivalence;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.lang.model.util.Types;

public final class MoreTypes {
    private static final Equivalence<TypeMirror> TYPE_EQUIVALENCE;
    private static final TypeVisitor<Boolean, EqualVisitorParam> EQUAL_VISITOR;
    private static final Class<?> INTERSECTION_TYPE;
    private static final Method GET_BOUNDS;
    private static final int HASH_SEED = 17;
    private static final int HASH_MULTIPLIER = 31;
    private static final TypeVisitor<Integer, Set<Element>> HASH_VISITOR;
    private static final TypeVisitor<Element, Void> AS_ELEMENT_VISITOR;

    public static Equivalence<TypeMirror> equivalence() {
        return TYPE_EQUIVALENCE;
    }

    private static boolean equal(TypeMirror a, TypeMirror b, Set<ComparedElements> visiting) {
        if (Objects.equal((Object)a, (Object)b) && !(a instanceof ExecutableType)) {
            return true;
        }
        EqualVisitorParam p = new EqualVisitorParam();
        p.type = b;
        p.visiting = visiting;
        if (INTERSECTION_TYPE != null) {
            if (MoreTypes.isIntersectionType(a)) {
                return MoreTypes.equalIntersectionTypes(a, b, visiting);
            }
            if (MoreTypes.isIntersectionType(b)) {
                return false;
            }
        }
        return a == b || a != null && b != null && a.accept(EQUAL_VISITOR, p) != false;
    }

    private static boolean isIntersectionType(TypeMirror t) {
        return t != null && t.getKind().name().equals("INTERSECTION");
    }

    private static boolean equalIntersectionTypes(TypeMirror a, TypeMirror b, Set<ComparedElements> visiting) {
        List bBounds;
        List aBounds;
        if (!MoreTypes.isIntersectionType(b)) {
            return false;
        }
        try {
            aBounds = (List)GET_BOUNDS.invoke((Object)a, new Object[0]);
            bBounds = (List)GET_BOUNDS.invoke((Object)b, new Object[0]);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        return MoreTypes.equalLists(aBounds, bBounds, visiting);
    }

    private static boolean equalLists(List<? extends TypeMirror> a, List<? extends TypeMirror> b, Set<ComparedElements> visiting) {
        int size = a.size();
        if (size != b.size()) {
            return false;
        }
        Iterator<? extends TypeMirror> aIterator = a.iterator();
        Iterator<? extends TypeMirror> bIterator = b.iterator();
        while (aIterator.hasNext()) {
            TypeMirror nextMirrorB;
            if (!bIterator.hasNext()) {
                return false;
            }
            TypeMirror nextMirrorA = aIterator.next();
            if (MoreTypes.equal(nextMirrorA, nextMirrorB = bIterator.next(), visiting)) continue;
            return false;
        }
        return !aIterator.hasNext();
    }

    private static int hashList(List<? extends TypeMirror> mirrors, Set<Element> visiting) {
        int result = 17;
        for (TypeMirror typeMirror : mirrors) {
            result *= 31;
            result += MoreTypes.hash(typeMirror, visiting);
        }
        return result;
    }

    private static int hash(TypeMirror mirror, Set<Element> visiting) {
        return mirror == null ? 0 : mirror.accept(HASH_VISITOR, visiting);
    }

    public static ImmutableSet<TypeElement> referencedTypes(TypeMirror type) {
        Preconditions.checkNotNull((Object)type);
        ImmutableSet.Builder elements = ImmutableSet.builder();
        type.accept(new SimpleTypeVisitor6<Void, ImmutableSet.Builder<TypeElement>>(){

            @Override
            public Void visitArray(ArrayType t, ImmutableSet.Builder<TypeElement> p) {
                t.getComponentType().accept(this, p);
                return null;
            }

            @Override
            public Void visitDeclared(DeclaredType t, ImmutableSet.Builder<TypeElement> p) {
                p.add((Object)MoreElements.asType(t.asElement()));
                for (TypeMirror typeMirror : t.getTypeArguments()) {
                    typeMirror.accept(this, p);
                }
                return null;
            }

            @Override
            public Void visitTypeVariable(TypeVariable t, ImmutableSet.Builder<TypeElement> p) {
                t.getLowerBound().accept(this, p);
                t.getUpperBound().accept(this, p);
                return null;
            }

            @Override
            public Void visitWildcard(WildcardType t, ImmutableSet.Builder<TypeElement> p) {
                TypeMirror superBound;
                TypeMirror extendsBound = t.getExtendsBound();
                if (extendsBound != null) {
                    extendsBound.accept(this, p);
                }
                if ((superBound = t.getSuperBound()) != null) {
                    superBound.accept(this, p);
                }
                return null;
            }
        }, elements);
        return elements.build();
    }

    public static Element asElement(TypeMirror typeMirror) {
        return typeMirror.accept(AS_ELEMENT_VISITOR, null);
    }

    public static TypeElement asTypeElement(TypeMirror mirror) {
        return MoreElements.asType(MoreTypes.asElement(mirror));
    }

    public static ImmutableSet<TypeElement> asTypeElements(Iterable<? extends TypeMirror> mirrors) {
        Preconditions.checkNotNull(mirrors);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (TypeMirror typeMirror : mirrors) {
            builder.add((Object)MoreTypes.asTypeElement(typeMirror));
        }
        return builder.build();
    }

    public static ArrayType asArray(TypeMirror maybeArrayType) {
        return maybeArrayType.accept(new CastingTypeVisitor<ArrayType>(){

            @Override
            public ArrayType visitArray(ArrayType type, String ignore) {
                return type;
            }
        }, "primitive array");
    }

    public static DeclaredType asDeclared(TypeMirror maybeDeclaredType) {
        return maybeDeclaredType.accept(new CastingTypeVisitor<DeclaredType>(){

            @Override
            public DeclaredType visitDeclared(DeclaredType type, String ignored) {
                return type;
            }
        }, "declared type");
    }

    public static ErrorType asError(TypeMirror maybeErrorType) {
        return maybeErrorType.accept(new CastingTypeVisitor<ErrorType>(){

            @Override
            public ErrorType visitError(ErrorType type, String p) {
                return type;
            }
        }, "error type");
    }

    public static ExecutableType asExecutable(TypeMirror maybeExecutableType) {
        return maybeExecutableType.accept(new CastingTypeVisitor<ExecutableType>(){

            @Override
            public ExecutableType visitExecutable(ExecutableType type, String p) {
                return type;
            }
        }, "executable type");
    }

    public static NoType asNoType(TypeMirror maybeNoType) {
        return maybeNoType.accept(new CastingTypeVisitor<NoType>(){

            @Override
            public NoType visitNoType(NoType noType, String p) {
                return noType;
            }
        }, "non-type");
    }

    public static NullType asNullType(TypeMirror maybeNullType) {
        return maybeNullType.accept(new CastingTypeVisitor<NullType>(){

            @Override
            public NullType visitNull(NullType nullType, String p) {
                return nullType;
            }
        }, "null");
    }

    public static PrimitiveType asPrimitiveType(TypeMirror maybePrimitiveType) {
        return maybePrimitiveType.accept(new CastingTypeVisitor<PrimitiveType>(){

            @Override
            public PrimitiveType visitPrimitive(PrimitiveType type, String p) {
                return type;
            }
        }, "primitive type");
    }

    public static TypeVariable asTypeVariable(TypeMirror maybeTypeVariable) {
        return maybeTypeVariable.accept(new CastingTypeVisitor<TypeVariable>(){

            @Override
            public TypeVariable visitTypeVariable(TypeVariable type, String p) {
                return type;
            }
        }, "type variable");
    }

    public static WildcardType asWildcard(WildcardType maybeWildcardType) {
        return maybeWildcardType.accept(new CastingTypeVisitor<WildcardType>(){

            @Override
            public WildcardType visitWildcard(WildcardType type, String p) {
                return type;
            }
        }, "wildcard type");
    }

    public static boolean isType(TypeMirror type) {
        return type.accept(new SimpleTypeVisitor6<Boolean, Void>(){

            @Override
            protected Boolean defaultAction(TypeMirror type, Void ignored) {
                return false;
            }

            @Override
            public Boolean visitNoType(NoType noType, Void p) {
                return noType.getKind().equals((Object)TypeKind.VOID);
            }

            @Override
            public Boolean visitPrimitive(PrimitiveType type, Void p) {
                return true;
            }

            @Override
            public Boolean visitArray(ArrayType array, Void p) {
                return true;
            }

            @Override
            public Boolean visitDeclared(DeclaredType type, Void ignored) {
                return MoreElements.isType(type.asElement());
            }
        }, null);
    }

    public static boolean isTypeOf(final Class<?> clazz, TypeMirror type) {
        Preconditions.checkNotNull(clazz);
        return type.accept(new SimpleTypeVisitor6<Boolean, Void>(){

            @Override
            protected Boolean defaultAction(TypeMirror type, Void ignored) {
                String string = String.valueOf(String.valueOf(type));
                throw new IllegalArgumentException(new StringBuilder(37 + string.length()).append(string).append(" cannot be represented as a Class<?>.").toString());
            }

            @Override
            public Boolean visitNoType(NoType noType, Void p) {
                if (noType.getKind().equals((Object)TypeKind.VOID)) {
                    return clazz.equals(Void.TYPE);
                }
                String string = String.valueOf(String.valueOf(noType));
                throw new IllegalArgumentException(new StringBuilder(37 + string.length()).append(string).append(" cannot be represented as a Class<?>.").toString());
            }

            @Override
            public Boolean visitPrimitive(PrimitiveType type, Void p) {
                switch (type.getKind()) {
                    case BOOLEAN: {
                        return clazz.equals(Boolean.TYPE);
                    }
                    case BYTE: {
                        return clazz.equals(Byte.TYPE);
                    }
                    case CHAR: {
                        return clazz.equals(Character.TYPE);
                    }
                    case DOUBLE: {
                        return clazz.equals(Double.TYPE);
                    }
                    case FLOAT: {
                        return clazz.equals(Float.TYPE);
                    }
                    case INT: {
                        return clazz.equals(Integer.TYPE);
                    }
                    case LONG: {
                        return clazz.equals(Long.TYPE);
                    }
                    case SHORT: {
                        return clazz.equals(Short.TYPE);
                    }
                }
                String string = String.valueOf(String.valueOf(type));
                throw new IllegalArgumentException(new StringBuilder(37 + string.length()).append(string).append(" cannot be represented as a Class<?>.").toString());
            }

            @Override
            public Boolean visitArray(ArrayType array, Void p) {
                return clazz.isArray() && MoreTypes.isTypeOf(clazz.getComponentType(), array.getComponentType());
            }

            @Override
            public Boolean visitDeclared(DeclaredType type, Void ignored) {
                TypeElement typeElement;
                try {
                    typeElement = MoreElements.asType(type.asElement());
                }
                catch (IllegalArgumentException iae) {
                    String string = String.valueOf(String.valueOf(type));
                    throw new IllegalArgumentException(new StringBuilder(41 + string.length()).append(string).append(" does not represent a class or interface.").toString());
                }
                return typeElement.getQualifiedName().contentEquals(clazz.getCanonicalName());
            }
        }, null);
    }

    public static Optional<DeclaredType> nonObjectSuperclass(final Types types, Elements elements, DeclaredType type) {
        Preconditions.checkNotNull((Object)types);
        Preconditions.checkNotNull((Object)elements);
        Preconditions.checkNotNull((Object)type);
        final TypeMirror objectType = elements.getTypeElement(Object.class.getCanonicalName()).asType();
        TypeMirror superclass = (TypeMirror)Iterables.getOnlyElement((Iterable)FluentIterable.from(types.directSupertypes(type)).filter((Predicate)new Predicate<TypeMirror>(){

            public boolean apply(TypeMirror input) {
                return input.getKind().equals((Object)TypeKind.DECLARED) && MoreElements.asType(MoreTypes.asDeclared(input).asElement()).getKind().equals((Object)ElementKind.CLASS) && !types.isSameType(objectType, input);
            }
        }), null);
        return superclass != null ? Optional.of((Object)MoreTypes.asDeclared(superclass)) : Optional.absent();
    }

    public static TypeMirror asMemberOf(Types types, DeclaredType container, VariableElement variable) {
        if (variable.getKind().equals((Object)ElementKind.PARAMETER)) {
            ExecutableElement methodOrConstructor = MoreElements.asExecutable(variable.getEnclosingElement());
            ExecutableType resolvedMethodOrConstructor = MoreTypes.asExecutable(types.asMemberOf(container, methodOrConstructor));
            List<? extends VariableElement> parameters = methodOrConstructor.getParameters();
            List<? extends TypeMirror> parameterTypes = resolvedMethodOrConstructor.getParameterTypes();
            Preconditions.checkState((parameters.size() == parameterTypes.size() ? 1 : 0) != 0);
            for (int i = 0; i < parameters.size(); ++i) {
                if (!parameters.get(i).equals(variable)) continue;
                return parameterTypes.get(i);
            }
            String string = String.valueOf(String.valueOf(variable));
            throw new IllegalStateException(new StringBuilder(25 + string.length()).append("Could not find variable: ").append(string).toString());
        }
        return types.asMemberOf(container, variable);
    }

    private MoreTypes() {
    }

    static {
        Method m;
        Class<?> c;
        TYPE_EQUIVALENCE = new Equivalence<TypeMirror>(){

            protected boolean doEquivalent(TypeMirror a, TypeMirror b) {
                return MoreTypes.equal(a, b, (Set)ImmutableSet.of());
            }

            protected int doHash(TypeMirror t) {
                return MoreTypes.hash(t, (Set)ImmutableSet.of());
            }
        };
        EQUAL_VISITOR = new SimpleTypeVisitor6<Boolean, EqualVisitorParam>(){

            @Override
            protected Boolean defaultAction(TypeMirror a, EqualVisitorParam p) {
                return a.getKind().equals((Object)p.type.getKind());
            }

            @Override
            public Boolean visitArray(ArrayType a, EqualVisitorParam p) {
                if (p.type.getKind().equals((Object)TypeKind.ARRAY)) {
                    ArrayType b = (ArrayType)p.type;
                    return MoreTypes.equal(a.getComponentType(), b.getComponentType(), p.visiting);
                }
                return false;
            }

            @Override
            public Boolean visitDeclared(DeclaredType a, EqualVisitorParam p) {
                if (p.type.getKind().equals((Object)TypeKind.DECLARED)) {
                    DeclaredType b = (DeclaredType)p.type;
                    Element aElement = a.asElement();
                    Element bElement = b.asElement();
                    Set<ComparedElements> newVisiting = this.visitingSetPlus(p.visiting, aElement, a.getTypeArguments(), bElement, b.getTypeArguments());
                    if (newVisiting.equals(p.visiting)) {
                        return true;
                    }
                    return aElement.equals(bElement) && MoreTypes.equal(a.getEnclosingType(), a.getEnclosingType(), newVisiting) && MoreTypes.equalLists(a.getTypeArguments(), b.getTypeArguments(), newVisiting);
                }
                return false;
            }

            @Override
            public Boolean visitError(ErrorType a, EqualVisitorParam p) {
                return a.equals(p.type);
            }

            @Override
            public Boolean visitExecutable(ExecutableType a, EqualVisitorParam p) {
                if (p.type.getKind().equals((Object)TypeKind.EXECUTABLE)) {
                    ExecutableType b = (ExecutableType)p.type;
                    return MoreTypes.equalLists(a.getParameterTypes(), b.getParameterTypes(), p.visiting) && MoreTypes.equal(a.getReturnType(), b.getReturnType(), p.visiting) && MoreTypes.equalLists(a.getThrownTypes(), b.getThrownTypes(), p.visiting) && MoreTypes.equalLists(a.getTypeVariables(), b.getTypeVariables(), p.visiting);
                }
                return false;
            }

            @Override
            public Boolean visitTypeVariable(TypeVariable a, EqualVisitorParam p) {
                if (p.type.getKind().equals((Object)TypeKind.TYPEVAR)) {
                    TypeParameterElement bElement;
                    TypeVariable b = (TypeVariable)p.type;
                    TypeParameterElement aElement = (TypeParameterElement)a.asElement();
                    Set<ComparedElements> newVisiting = this.visitingSetPlus(p.visiting, aElement, bElement = (TypeParameterElement)b.asElement());
                    if (newVisiting.equals(p.visiting)) {
                        return true;
                    }
                    return MoreTypes.equalLists(aElement.getBounds(), bElement.getBounds(), newVisiting) && MoreTypes.equal(a.getLowerBound(), b.getLowerBound(), newVisiting) && a.asElement().getSimpleName().equals(b.asElement().getSimpleName());
                }
                return false;
            }

            @Override
            public Boolean visitWildcard(WildcardType a, EqualVisitorParam p) {
                if (p.type.getKind().equals((Object)TypeKind.WILDCARD)) {
                    WildcardType b = (WildcardType)p.type;
                    return MoreTypes.equal(a.getExtendsBound(), b.getExtendsBound(), p.visiting) && MoreTypes.equal(a.getSuperBound(), b.getSuperBound(), p.visiting);
                }
                return false;
            }

            @Override
            public Boolean visitUnknown(TypeMirror a, EqualVisitorParam p) {
                throw new UnsupportedOperationException();
            }

            private Set<ComparedElements> visitingSetPlus(Set<ComparedElements> visiting, Element a, Element b) {
                ImmutableList noArguments = ImmutableList.of();
                return this.visitingSetPlus(visiting, a, (List<? extends TypeMirror>)noArguments, b, (List<? extends TypeMirror>)noArguments);
            }

            private Set<ComparedElements> visitingSetPlus(Set<ComparedElements> visiting, Element a, List<? extends TypeMirror> aArguments, Element b, List<? extends TypeMirror> bArguments) {
                ComparedElements comparedElements = new ComparedElements(a, (ImmutableList<TypeMirror>)ImmutableList.copyOf(aArguments), b, (ImmutableList<TypeMirror>)ImmutableList.copyOf(bArguments));
                HashSet<ComparedElements> newVisiting = new HashSet<ComparedElements>(visiting);
                newVisiting.add(comparedElements);
                return newVisiting;
            }
        };
        try {
            c = Class.forName("javax.lang.model.type.IntersectionType");
            m = c.getMethod("getBounds", new Class[0]);
        }
        catch (Exception e) {
            c = null;
            m = null;
        }
        INTERSECTION_TYPE = c;
        GET_BOUNDS = m;
        HASH_VISITOR = new SimpleTypeVisitor6<Integer, Set<Element>>(){

            int hashKind(int seed, TypeMirror t) {
                int result = seed * 31;
                return result += t.getKind().hashCode();
            }

            @Override
            protected Integer defaultAction(TypeMirror e, Set<Element> visiting) {
                return this.hashKind(17, e);
            }

            @Override
            public Integer visitArray(ArrayType t, Set<Element> visiting) {
                int result = this.hashKind(17, t);
                result *= 31;
                return result += t.getComponentType().accept(this, visiting).intValue();
            }

            @Override
            public Integer visitDeclared(DeclaredType t, Set<Element> visiting) {
                Element element = t.asElement();
                if (visiting.contains(element)) {
                    return 0;
                }
                HashSet<Element> newVisiting = new HashSet<Element>(visiting);
                newVisiting.add(element);
                int result = this.hashKind(17, t);
                result *= 31;
                result += t.asElement().hashCode();
                result *= 31;
                result += t.getEnclosingType().accept(this, newVisiting).intValue();
                result *= 31;
                return result += MoreTypes.hashList(t.getTypeArguments(), newVisiting);
            }

            @Override
            public Integer visitExecutable(ExecutableType t, Set<Element> visiting) {
                int result = this.hashKind(17, t);
                result *= 31;
                result += MoreTypes.hashList(t.getParameterTypes(), visiting);
                result *= 31;
                result += t.getReturnType().accept(this, visiting).intValue();
                result *= 31;
                result += MoreTypes.hashList(t.getThrownTypes(), visiting);
                result *= 31;
                return result += MoreTypes.hashList(t.getTypeVariables(), visiting);
            }

            @Override
            public Integer visitTypeVariable(TypeVariable t, Set<Element> visiting) {
                int result = this.hashKind(17, t);
                result *= 31;
                result += t.getLowerBound().accept(this, visiting).intValue();
                TypeParameterElement element = (TypeParameterElement)t.asElement();
                for (TypeMirror typeMirror : element.getBounds()) {
                    result *= 31;
                    result += typeMirror.accept(this, visiting).intValue();
                }
                return result;
            }

            @Override
            public Integer visitWildcard(WildcardType t, Set<Element> visiting) {
                int result = this.hashKind(17, t);
                result *= 31;
                result += t.getExtendsBound() == null ? 0 : t.getExtendsBound().accept(this, visiting);
                result *= 31;
                return result += t.getSuperBound() == null ? 0 : t.getSuperBound().accept(this, visiting);
            }

            @Override
            public Integer visitUnknown(TypeMirror t, Set<Element> visiting) {
                throw new UnsupportedOperationException();
            }
        };
        AS_ELEMENT_VISITOR = new SimpleTypeVisitor6<Element, Void>(){

            @Override
            protected Element defaultAction(TypeMirror e, Void p) {
                String string = String.valueOf(String.valueOf(e));
                throw new IllegalArgumentException(new StringBuilder(33 + string.length()).append(string).append("cannot be converted to an Element").toString());
            }

            @Override
            public Element visitDeclared(DeclaredType t, Void p) {
                return t.asElement();
            }

            @Override
            public Element visitError(ErrorType t, Void p) {
                return t.asElement();
            }

            @Override
            public Element visitTypeVariable(TypeVariable t, Void p) {
                return t.asElement();
            }
        };
    }

    private static class CastingTypeVisitor<T>
    extends SimpleTypeVisitor6<T, String> {
        private CastingTypeVisitor() {
        }

        @Override
        protected T defaultAction(TypeMirror e, String label) {
            String string = String.valueOf(String.valueOf(e));
            String string2 = String.valueOf(String.valueOf(label));
            throw new IllegalArgumentException(new StringBuilder(22 + string.length() + string2.length()).append(string).append(" does not represent a ").append(string2).toString());
        }
    }

    private static class ComparedElements {
        final Element a;
        final ImmutableList<TypeMirror> aArguments;
        final Element b;
        final ImmutableList<TypeMirror> bArguments;

        ComparedElements(Element a, ImmutableList<TypeMirror> aArguments, Element b, ImmutableList<TypeMirror> bArguments) {
            this.a = a;
            this.aArguments = aArguments;
            this.b = b;
            this.bArguments = bArguments;
        }

        public boolean equals(Object o) {
            if (o instanceof ComparedElements) {
                ComparedElements that = (ComparedElements)o;
                int nArguments = this.aArguments.size();
                if (!this.a.equals(that.a) || !this.b.equals(that.b) || nArguments != this.bArguments.size()) {
                    return false;
                }
                for (int i = 0; i < nArguments; ++i) {
                    if (this.aArguments.get(i) == this.bArguments.get(i)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            return this.a.hashCode() * 31 + this.b.hashCode();
        }
    }

    private static final class EqualVisitorParam {
        TypeMirror type;
        Set<ComparedElements> visiting;

        private EqualVisitorParam() {
        }
    }
}

