/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot.environment;

import com.ulisesbocchio.jasyptspringboot.EncryptablePropertyDetector;
import com.ulisesbocchio.jasyptspringboot.EncryptablePropertyFilter;
import com.ulisesbocchio.jasyptspringboot.EncryptablePropertyResolver;
import com.ulisesbocchio.jasyptspringboot.EncryptablePropertySourceConverter;
import com.ulisesbocchio.jasyptspringboot.InterceptionMode;
import com.ulisesbocchio.jasyptspringboot.configuration.EnvCopy;
import com.ulisesbocchio.jasyptspringboot.detector.DefaultLazyPropertyDetector;
import com.ulisesbocchio.jasyptspringboot.encryptor.DefaultLazyEncryptor;
import com.ulisesbocchio.jasyptspringboot.environment.EncryptableEnvironment;
import com.ulisesbocchio.jasyptspringboot.environment.MutableConfigurablePropertyResolver;
import com.ulisesbocchio.jasyptspringboot.filter.DefaultLazyPropertyFilter;
import com.ulisesbocchio.jasyptspringboot.resolver.DefaultLazyPropertyResolver;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jasypt.encryption.StringEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.source.ConfigurationPropertySources;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public class EnvironmentInitializer {
    private static final Logger log = LoggerFactory.getLogger(EnvironmentInitializer.class);
    private final InterceptionMode interceptionMode;
    private final List<Class<PropertySource<?>>> skipPropertySourceClasses;
    private final EncryptablePropertyResolver resolver;
    private final EncryptablePropertyFilter filter;
    private final StringEncryptor encryptor;
    private final EncryptablePropertyDetector detector;
    private final InterceptionMode propertySourceInterceptionMode;

    public EnvironmentInitializer(InterceptionMode interceptionMode, InterceptionMode propertySourceInterceptionMode, List<Class<PropertySource<?>>> skipPropertySourceClasses, EncryptablePropertyResolver resolver, EncryptablePropertyFilter filter, StringEncryptor encryptor, EncryptablePropertyDetector detector) {
        this.interceptionMode = interceptionMode;
        this.propertySourceInterceptionMode = propertySourceInterceptionMode;
        this.skipPropertySourceClasses = skipPropertySourceClasses;
        this.resolver = resolver;
        this.filter = filter;
        this.encryptor = encryptor;
        this.detector = detector;
    }

    void initialize(EncryptableEnvironment environment) {
        log.info("Initializing Environment: {}", (Object)environment.getClass().getSimpleName());
        InterceptionMode actualInterceptionMode = Optional.ofNullable(this.interceptionMode).orElse(InterceptionMode.WRAPPER);
        List actualSkipPropertySourceClasses = Optional.ofNullable(this.skipPropertySourceClasses).orElseGet(Collections::emptyList);
        EnvCopy envCopy = new EnvCopy(environment);
        EncryptablePropertyFilter actualFilter = Optional.ofNullable(this.filter).orElseGet(() -> new DefaultLazyPropertyFilter(envCopy.get()));
        StringEncryptor actualEncryptor = Optional.ofNullable(this.encryptor).orElseGet(() -> new DefaultLazyEncryptor(envCopy.get()));
        EncryptablePropertyDetector actualDetector = Optional.ofNullable(this.detector).orElseGet(() -> new DefaultLazyPropertyDetector(envCopy.get()));
        EncryptablePropertyResolver actualResolver = Optional.ofNullable(this.resolver).orElseGet(() -> new DefaultLazyPropertyResolver(actualDetector, actualEncryptor, (Environment)environment));
        EncryptablePropertySourceConverter converter = new EncryptablePropertySourceConverter(actualInterceptionMode, actualSkipPropertySourceClasses, actualResolver, actualFilter);
        converter.convertPropertySources(environment.getOriginalPropertySources());
        MutablePropertySources encryptableSources = converter.convertMutablePropertySources(this.propertySourceInterceptionMode, environment.getOriginalPropertySources(), envCopy);
        environment.setEncryptablePropertySources(encryptableSources);
    }

    static MutableConfigurablePropertyResolver createPropertyResolver(MutablePropertySources propertySources) {
        return new MutableConfigurablePropertyResolver(propertySources, ConfigurationPropertySources::createPropertyResolver);
    }
}

