/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot.filter;

import com.ulisesbocchio.jasyptspringboot.EncryptablePropertyFilter;
import java.util.List;
import org.springframework.core.env.PropertySource;

public class DefaultPropertyFilter
implements EncryptablePropertyFilter {
    private final List<String> includeSourceNames;
    private final List<String> excludeSourceNames;
    private final List<String> includePropertyNames;
    private final List<String> excludePropertyNames;

    public DefaultPropertyFilter() {
        this.includeSourceNames = null;
        this.includePropertyNames = null;
        this.excludeSourceNames = null;
        this.excludePropertyNames = null;
    }

    public DefaultPropertyFilter(List<String> includeSourceNames, List<String> excludeSourceNames, List<String> includePropertyNames, List<String> excludePropertyNames) {
        this.includeSourceNames = includeSourceNames;
        this.excludeSourceNames = excludeSourceNames;
        this.includePropertyNames = includePropertyNames;
        this.excludePropertyNames = excludePropertyNames;
    }

    @Override
    public boolean shouldInclude(PropertySource<?> source, String name) {
        if (this.isIncludeAll()) {
            return true;
        }
        if (this.isMatch(source.getName(), this.excludeSourceNames) || this.isMatch(name, this.excludePropertyNames)) {
            return false;
        }
        return this.isIncludeUnset() || this.isMatch(source.getName(), this.includeSourceNames) || this.isMatch(name, this.includePropertyNames);
    }

    private boolean isIncludeAll() {
        return this.isIncludeUnset() && this.isExcludeUnset();
    }

    private boolean isIncludeUnset() {
        return this.isEmpty(this.includeSourceNames) && this.isEmpty(this.includePropertyNames);
    }

    private boolean isExcludeUnset() {
        return this.isEmpty(this.excludeSourceNames) && this.isEmpty(this.excludePropertyNames);
    }

    private boolean isEmpty(List<String> patterns) {
        return patterns == null || patterns.isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isMatch(String name, List<String> patterns) {
        if (name == null) return false;
        if (this.isEmpty(patterns)) return false;
        if (!patterns.stream().anyMatch(name::matches)) return false;
        return true;
    }
}

