/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.regexp;

import com.google.code.regexp.MatchResult;
import com.google.code.regexp.Pattern;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Matcher
implements MatchResult {
    private java.util.regex.Matcher matcher;
    private Pattern parentPattern;

    Matcher(Pattern pattern, java.util.regex.MatchResult matchResult) {
        this.parentPattern = pattern;
        this.matcher = (java.util.regex.Matcher)matchResult;
    }

    Matcher(Pattern pattern, CharSequence charSequence) {
        this.parentPattern = pattern;
        this.matcher = pattern.pattern().matcher(charSequence);
    }

    public java.util.regex.Pattern standardPattern() {
        return this.matcher.pattern();
    }

    public Pattern namedPattern() {
        return this.parentPattern;
    }

    public Matcher usePattern(Pattern pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("newPattern cannot be null");
        }
        this.parentPattern = pattern;
        this.matcher.usePattern(pattern.pattern());
        return this;
    }

    public Matcher reset() {
        this.matcher.reset();
        return this;
    }

    public Matcher reset(CharSequence charSequence) {
        this.matcher.reset(charSequence);
        return this;
    }

    public boolean matches() {
        return this.matcher.matches();
    }

    public MatchResult toMatchResult() {
        return new Matcher(this.parentPattern, this.matcher.toMatchResult());
    }

    public boolean find() {
        return this.matcher.find();
    }

    public boolean find(int n) {
        return this.matcher.find(n);
    }

    public boolean lookingAt() {
        return this.matcher.lookingAt();
    }

    public Matcher appendReplacement(StringBuffer stringBuffer, String string) {
        this.matcher.appendReplacement(stringBuffer, this.parentPattern.replaceProperties(string));
        return this;
    }

    public StringBuffer appendTail(StringBuffer stringBuffer) {
        return this.matcher.appendTail(stringBuffer);
    }

    @Override
    public String group() {
        return this.matcher.group();
    }

    @Override
    public String group(int n) {
        return this.matcher.group(n);
    }

    @Override
    public int groupCount() {
        return this.matcher.groupCount();
    }

    @Override
    public List<String> orderedGroups() {
        int n = this.groupCount();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (int i = 1; i <= n; ++i) {
            arrayList.add(this.group(i));
        }
        return arrayList;
    }

    @Override
    public String group(String string) {
        int n = this.groupIndex(string);
        if (n < 0) {
            throw new IndexOutOfBoundsException("No group \"" + string + "\"");
        }
        return this.group(n);
    }

    @Override
    public Map<String, String> namedGroups() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        if (this.matcher.find(0)) {
            for (String string : this.parentPattern.groupNames()) {
                String string2 = this.matcher.group(this.groupIndex(string));
                linkedHashMap.put(string, string2);
            }
        }
        return linkedHashMap;
    }

    private int groupIndex(String string) {
        int n = this.parentPattern.indexOf(string);
        return n > -1 ? n + 1 : -1;
    }

    @Override
    public int start() {
        return this.matcher.start();
    }

    @Override
    public int start(int n) {
        return this.matcher.start(n);
    }

    @Override
    public int start(String string) {
        return this.start(this.groupIndex(string));
    }

    @Override
    public int end() {
        return this.matcher.end();
    }

    @Override
    public int end(int n) {
        return this.matcher.end(n);
    }

    @Override
    public int end(String string) {
        return this.end(this.groupIndex(string));
    }

    public Matcher region(int n, int n2) {
        this.matcher.region(n, n2);
        return this;
    }

    public int regionEnd() {
        return this.matcher.regionEnd();
    }

    public int regionStart() {
        return this.matcher.regionStart();
    }

    public boolean hitEnd() {
        return this.matcher.hitEnd();
    }

    public boolean requireEnd() {
        return this.matcher.requireEnd();
    }

    public boolean hasAnchoringBounds() {
        return this.matcher.hasAnchoringBounds();
    }

    public boolean hasTransparentBounds() {
        return this.matcher.hasTransparentBounds();
    }

    public String replaceAll(String string) {
        String string2 = this.parentPattern.replaceProperties(string);
        return this.matcher.replaceAll(string2);
    }

    public String replaceFirst(String string) {
        return this.matcher.replaceFirst(this.parentPattern.replaceProperties(string));
    }

    public Matcher useAnchoringBounds(boolean bl) {
        this.matcher.useAnchoringBounds(bl);
        return this;
    }

    public Matcher useTransparentBounds(boolean bl) {
        this.matcher.useTransparentBounds(bl);
        return this;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Matcher)) {
            return false;
        }
        Matcher matcher = (Matcher)object;
        if (!this.parentPattern.equals(matcher.parentPattern)) {
            return false;
        }
        return this.matcher.equals(matcher.matcher);
    }

    public int hashCode() {
        return this.parentPattern.hashCode() ^ this.matcher.hashCode();
    }

    public String toString() {
        return this.matcher.toString();
    }
}

