/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.recording;

import com.github.tomakehurst.wiremock.common.Urls;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class ScenarioProcessor {
    public void putRepeatedRequestsInScenarios(List<StubMapping> stubMappings) {
        ImmutableListMultimap stubsGroupedByRequest = Multimaps.index(stubMappings, StubMapping::getRequest);
        Map groupsWithMoreThanOneStub = Maps.filterEntries((Map)stubsGroupedByRequest.asMap(), input -> ((Collection)input.getValue()).size() > 1);
        int scenarioIndex = 0;
        for (Map.Entry entry : groupsWithMoreThanOneStub.entrySet()) {
            this.putStubsInScenario(++scenarioIndex, (List<StubMapping>)ImmutableList.copyOf((Collection)((Collection)entry.getValue())));
        }
    }

    private void putStubsInScenario(int scenarioIndex, List<StubMapping> stubMappings) {
        StubMapping firstScenario = stubMappings.get(0);
        String scenarioName = "scenario-" + scenarioIndex + "-" + Urls.urlToPathParts(URI.create(firstScenario.getRequest().getUrl()));
        int count = 1;
        for (StubMapping stub : stubMappings) {
            stub.setScenarioName(scenarioName);
            if (count == 1) {
                stub.setRequiredScenarioState("Started");
            } else {
                stub.setRequiredScenarioState(scenarioName + "-" + count);
            }
            if (count < stubMappings.size()) {
                stub.setNewScenarioState(scenarioName + "-" + (count + 1));
            }
            ++count;
        }
    }
}

