/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.http.QueryParameter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Maps;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Urls {
    private Urls() {
    }

    public static Map<String, QueryParameter> splitQueryFromUrl(String url) {
        String queryPart = url.contains("?") && !url.endsWith("?") ? url.substring(url.indexOf(63) + 1) : null;
        return Urls.splitQuery(queryPart);
    }

    public static Map<String, QueryParameter> splitQuery(URI uri) {
        if (uri == null) {
            return Collections.emptyMap();
        }
        return Urls.splitQuery(uri.getRawQuery());
    }

    public static Map<String, QueryParameter> splitQuery(String query) {
        if (query == null) {
            return Collections.emptyMap();
        }
        List pairs = Arrays.stream(query.split("&")).collect(Collectors.toList());
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        for (String queryElement : pairs) {
            int firstEqualsIndex = queryElement.indexOf(61);
            if (firstEqualsIndex == -1) {
                builder.putAll((Object)Urls.decode(queryElement), (Object[])new String[]{""});
                continue;
            }
            String key2 = Urls.decode(queryElement.substring(0, firstEqualsIndex));
            String value = Urls.decode(queryElement.substring(firstEqualsIndex + 1));
            builder.putAll((Object)key2, (Object[])new String[]{value});
        }
        return Maps.transformEntries((Map)builder.build().asMap(), (key, values) -> new QueryParameter((String)key, (List<String>)ImmutableList.copyOf((Collection)values)));
    }

    public static String getPath(String url) {
        return url.contains("?") ? url.substring(0, url.indexOf("?")) : url;
    }

    public static List<String> getPathSegments(String path) {
        return ImmutableList.copyOf((Object[])path.split("/"));
    }

    public static String urlToPathParts(URI uri) {
        List uriPathNodes = Arrays.stream(uri.getPath().split("/")).filter(s -> !s.isEmpty()).collect(Collectors.toUnmodifiableList());
        int nodeCount = uriPathNodes.size();
        return nodeCount > 0 ? String.join((CharSequence)"-", uriPathNodes) : "";
    }

    public static String decode(String encoded) {
        return URLDecoder.decode(encoded, StandardCharsets.UTF_8);
    }

    public static URL safelyCreateURL(String url) {
        try {
            return new URL(Urls.clean(url));
        }
        catch (MalformedURLException e) {
            return Exceptions.throwUnchecked(e, URL.class);
        }
    }

    private static String clean(String url) {
        return url.matches(".*:[0-9]+null$") ? url.substring(0, url.length() - 4) : url;
    }
}

