/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.jayway.jsonpath.internal.filter;

import java.util.List;
import java.util.Map;
import wiremock.com.jayway.jsonpath.internal.filter.PathTokenFilter;
import wiremock.com.jayway.jsonpath.spi.JsonProvider;

public class HasFieldFilter
extends PathTokenFilter {
    public HasFieldFilter(String condition) {
        super(condition);
    }

    @Override
    public Object filter(Object obj, JsonProvider jsonProvider) {
        List<Object> src = jsonProvider.toList(obj);
        List<Object> result = jsonProvider.createList();
        String trimmedCondition = this.condition;
        if (this.condition.contains("['")) {
            trimmedCondition = trimmedCondition.replace("['", ".");
            trimmedCondition = trimmedCondition.replace("']", "");
        }
        trimmedCondition = this.trim(trimmedCondition, 5, 2);
        for (Object item : src) {
            Map<String, Object> map;
            if (!jsonProvider.isMap(item) || !(map = jsonProvider.toMap(item)).containsKey(trimmedCondition)) continue;
            result.add(map);
        }
        return result;
    }

    @Override
    public Object getRef(Object obj, JsonProvider jsonProvider) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isArrayFilter() {
        return true;
    }
}

