/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.apache.http.impl.cookie;

import java.util.Date;
import wiremock.org.apache.http.annotation.Immutable;
import wiremock.org.apache.http.client.utils.DateUtils;
import wiremock.org.apache.http.cookie.CommonCookieAttributeHandler;
import wiremock.org.apache.http.cookie.MalformedCookieException;
import wiremock.org.apache.http.cookie.SetCookie;
import wiremock.org.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import wiremock.org.apache.http.util.Args;

@Immutable
public class BasicExpiresHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    private final String[] datepatterns;

    public BasicExpiresHandler(String[] datepatterns) {
        Args.notNull(datepatterns, "Array of date patterns");
        this.datepatterns = datepatterns;
    }

    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for 'expires' attribute");
        }
        Date expiry = DateUtils.parseDate(value, this.datepatterns);
        if (expiry == null) {
            throw new MalformedCookieException("Invalid 'expires' attribute: " + value);
        }
        cookie.setExpiryDate(expiry);
    }

    @Override
    public String getAttributeName() {
        return "expires";
    }
}

