/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.stubbing;

import com.github.tomakehurst.wiremock.stubbing.Scenario;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class Scenarios {
    private final ConcurrentHashMap<String, Scenario> scenarioMap = new ConcurrentHashMap();

    public Scenario getByName(String name) {
        return this.scenarioMap.get(name);
    }

    public List<Scenario> getAll() {
        return ImmutableList.copyOf(this.scenarioMap.values());
    }

    public void onStubMappingAdded(StubMapping mapping) {
        if (mapping.isInScenario()) {
            String scenarioName = mapping.getScenarioName();
            Scenario scenario = ((Scenario)MoreObjects.firstNonNull((Object)this.scenarioMap.get(scenarioName), (Object)Scenario.inStartedState(scenarioName))).withStubMapping(mapping);
            this.scenarioMap.put(scenarioName, scenario);
        }
    }

    public void onStubMappingUpdated(StubMapping oldMapping, StubMapping newMapping) {
        if (oldMapping.isInScenario() && !newMapping.getScenarioName().equals(oldMapping.getScenarioName())) {
            Scenario scenarioForOldMapping = this.scenarioMap.get(oldMapping.getScenarioName()).withoutStubMapping(oldMapping);
            if (scenarioForOldMapping.getMappings().isEmpty()) {
                this.scenarioMap.remove(scenarioForOldMapping.getName());
            } else {
                this.scenarioMap.put(oldMapping.getScenarioName(), scenarioForOldMapping);
            }
        }
        if (newMapping.isInScenario()) {
            String scenarioName = newMapping.getScenarioName();
            Scenario scenario = ((Scenario)MoreObjects.firstNonNull((Object)this.scenarioMap.get(scenarioName), (Object)Scenario.inStartedState(scenarioName))).withStubMapping(newMapping);
            this.scenarioMap.put(scenarioName, scenario);
        }
    }

    public void onStubMappingRemoved(StubMapping mapping) {
        if (mapping.isInScenario()) {
            String scenarioName = mapping.getScenarioName();
            Scenario scenario = this.scenarioMap.get(scenarioName).withoutStubMapping(mapping);
            if (scenario.getMappings().isEmpty()) {
                this.scenarioMap.remove(scenarioName);
            } else {
                this.scenarioMap.put(scenarioName, scenario);
            }
        }
    }

    public void onStubServed(StubMapping mapping) {
        if (mapping.isInScenario()) {
            String scenarioName = mapping.getScenarioName();
            Scenario scenario = this.scenarioMap.get(scenarioName);
            if (mapping.modifiesScenarioState() && (mapping.getRequiredScenarioState() == null || scenario.getState().equals(mapping.getRequiredScenarioState()))) {
                Scenario newScenario = scenario.setState(mapping.getNewScenarioState());
                this.scenarioMap.put(scenarioName, newScenario);
            }
        }
    }

    public void reset() {
        this.scenarioMap.putAll(Maps.transformValues(this.scenarioMap, (Function)new Function<Scenario, Scenario>(){

            public Scenario apply(Scenario input) {
                return input.reset();
            }
        }));
    }

    public void clear() {
        this.scenarioMap.clear();
    }

    public boolean mappingMatchesScenarioState(StubMapping mapping) {
        String currentScenarioState = this.getByName(mapping.getScenarioName()).getState();
        return mapping.getRequiredScenarioState().equals(currentScenarioState);
    }
}

