/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.xmlunit.placeholder;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import wiremock.org.xmlunit.diff.ComparisonResult;
import wiremock.org.xmlunit.placeholder.PlaceholderHandler;

public class IsDateTimePlaceholderHandler
implements PlaceholderHandler {
    private static final String PLACEHOLDER_NAME = "isDateTime";
    private static final List<String> ISO_PATTERNS = Collections.unmodifiableList(Arrays.asList("yyyy-MM-dd", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mm:ss.SSS", "yyyy-MM-dd'T'HH:mm:ssZ", "yyyy-MM-dd'T'HH:mm:ss.SSSZ", "yyyy-MM-dd'T'HH:mm:ssXXX", "yyyy-MM-dd'T'HH:mm:ss.SSSXXX", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mm:ssZ", "yyyy-MM-dd HH:mm:ss.SSSZ", "yyyy-MM-dd HH:mm:ssXXX", "yyyy-MM-dd HH:mm:ss.SSSXXX"));

    @Override
    public String getKeyword() {
        return PLACEHOLDER_NAME;
    }

    @Override
    public ComparisonResult evaluate(String testText, String ... args) {
        if (args != null && args.length == 1) {
            return this.canParse(new SimpleDateFormat(args[0]), testText) ? ComparisonResult.EQUAL : ComparisonResult.DIFFERENT;
        }
        return this.canParse(testText) ? ComparisonResult.EQUAL : ComparisonResult.DIFFERENT;
    }

    private boolean canParse(String testText) {
        if (testText == null || "".equals(testText)) {
            return false;
        }
        if (this.canParse(DateFormat.getDateInstance(3), testText) || this.canParse(DateFormat.getDateTimeInstance(3, 3), testText)) {
            return true;
        }
        for (String pattern : ISO_PATTERNS) {
            if (!this.canParse(new SimpleDateFormat(pattern), testText)) continue;
            return true;
        }
        return false;
    }

    private boolean canParse(DateFormat fmt, String testText) {
        try {
            return null != fmt.parse(testText);
        }
        catch (ParseException ex) {
            return false;
        }
    }
}

