/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.utils;

import com.github.sommeri.less4j.LessSource;
import com.github.sommeri.less4j.platform.Constants;
import com.github.sommeri.less4j.utils.RelativeFilenameUtils;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;

public class URIUtils {
    public static final String URI_FILE_SEPARATOR = "/";

    public static URL toParentURL(URL url) {
        String path = url.getPath();
        int i = path.lastIndexOf(URI_FILE_SEPARATOR);
        if (i != -1) {
            path = path.substring(0, i + 1);
        }
        try {
            return new URL(url, path + url.getQuery());
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String relativize(File from, File to) {
        URI fromURI = from.toURI();
        URI toURI = to.toURI();
        String relative = URIUtils.getRelativePath(fromURI.toString(), toURI.toString(), URI_FILE_SEPARATOR);
        relative = URIUtils.convertUriToPlatformSeparator(relative);
        return relative;
    }

    public static String relativizeSourceURIs(LessSource from, LessSource to) {
        if (to == null) {
            return "";
        }
        if (to.getURI() == null) {
            return to.getName() == null ? "" : to.getName();
        }
        if (from == null || from.getURI() == null) {
            return to.getURI().toString();
        }
        String fromURI = from.getURI().toString();
        String toURI = to.getURI().toString();
        return URIUtils.getRelativePath(fromURI, toURI, URI_FILE_SEPARATOR);
    }

    public static String convertUriToPlatformSeparator(String relative) {
        return relative.replace(URI_FILE_SEPARATOR, Constants.FILE_SEPARATOR);
    }

    public static String convertPlatformSeparatorToUri(String relative) {
        return relative.replace(Constants.FILE_SEPARATOR, URI_FILE_SEPARATOR);
    }

    public static String getRelativePath(String basePath, String targetPath, String pathSeparator) {
        int commonIndex;
        String normalizedTargetPath = URIUtils.normalizeNoEndSeparator(targetPath, pathSeparator);
        String normalizedBasePath = URIUtils.normalizeNoEndSeparator(basePath, pathSeparator);
        if (normalizedTargetPath == null) {
            return "";
        }
        if (normalizedBasePath == null) {
            return targetPath;
        }
        String[] base = normalizedBasePath.split(Pattern.quote(pathSeparator));
        String[] target = normalizedTargetPath.split(Pattern.quote(pathSeparator));
        StringBuffer common = new StringBuffer();
        for (commonIndex = 0; commonIndex < target.length && commonIndex < base.length && target[commonIndex].equals(base[commonIndex]); ++commonIndex) {
            common.append(target[commonIndex] + pathSeparator);
        }
        if (commonIndex == 0) {
            return normalizedTargetPath;
        }
        boolean baseIsFile = true;
        File baseResource = new File(normalizedBasePath);
        if (baseResource.exists()) {
            baseIsFile = baseResource.isFile();
        } else if (basePath.endsWith(pathSeparator)) {
            baseIsFile = false;
        }
        StringBuffer relative = new StringBuffer();
        if (base.length != commonIndex) {
            int numDirsUp = baseIsFile ? base.length - commonIndex - 1 : base.length - commonIndex;
            for (int i = 0; i < numDirsUp; ++i) {
                relative.append(".." + pathSeparator);
            }
        }
        relative.append(URIUtils.safeSubstring(normalizedTargetPath, common.length()));
        return relative.toString();
    }

    public static String normalizeNoEndSeparator(String path, String separator) {
        String result = RelativeFilenameUtils.normalizeNoEndSeparator(path);
        if (separator.equals(URI_FILE_SEPARATOR)) {
            result = FilenameUtils.separatorsToUnix((String)result);
        } else if (separator.equals("\\")) {
            result = FilenameUtils.separatorsToWindows((String)result);
        } else {
            throw new IllegalArgumentException("Unrecognised dir separator '" + separator + "'");
        }
        return result;
    }

    private static String safeSubstring(String string, int beginIndex) {
        if (beginIndex > string.length()) {
            return "";
        }
        return string.substring(beginIndex);
    }

    public static String addPLatformSlashIfNeeded(String directory) {
        if (directory.endsWith(Constants.FILE_SEPARATOR)) {
            return directory;
        }
        return directory + Constants.FILE_SEPARATOR;
    }

    public static URI changeSuffix(URI uri, String dottedSuffix) {
        if (uri == null) {
            return null;
        }
        String newPath = URIUtils.changeSuffix(uri.getPath(), dottedSuffix);
        try {
            URI result = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), newPath, null, null);
            return result;
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static String changeSuffix(String filename, String dottedSuffix) {
        if (filename == null) {
            return null;
        }
        int lastIndexOf = filename.lastIndexOf(46);
        if (lastIndexOf == -1) {
            return filename + dottedSuffix;
        }
        return filename.substring(0, lastIndexOf) + dottedSuffix;
    }

    public static String addSuffix(String filename, String dottedSuffix) {
        if (filename == null) {
            return null;
        }
        return filename + dottedSuffix;
    }

    public static File changeSuffix(File file, String dottedSuffix) {
        if (file == null) {
            return null;
        }
        String filename = URIUtils.changeSuffix(file.toString(), dottedSuffix);
        return new File(filename);
    }

    public static LessSource.FileSource changeSuffix(LessSource.FileSource source, String dottedSuffix) {
        if (source == null) {
            return null;
        }
        return new LessSource.FileSource(URIUtils.changeSuffix(source.getInputFile(), dottedSuffix));
    }
}

