/*
 * Decompiled with CFR 0.152.
 */
package com.github.seregamorph.maven.turbo;

import com.github.seregamorph.maven.turbo.CurrentProjectExecution;
import com.github.seregamorph.maven.turbo.MojoUtils;
import com.github.seregamorph.maven.turbo.PhaseOrderPatcher;
import com.github.seregamorph.maven.turbo.TurboBuilderConfig;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.execution.ProjectExecutionEvent;
import org.apache.maven.execution.ProjectExecutionListener;

@Named
@Singleton
public class TurboProjectExecutionListener
implements ProjectExecutionListener {
    public void beforeProjectExecution(ProjectExecutionEvent event) {
    }

    public void beforeProjectLifecycleExecution(ProjectExecutionEvent event) {
        CurrentProjectExecution.ifPresent(execution -> {
            execution.packageMojos = event.getExecutionPlan().stream().filter(mojo -> {
                String lifecyclePhase = mojo.getLifecyclePhase();
                return lifecyclePhase != null && PhaseOrderPatcher.isPackage(lifecyclePhase);
            }).collect(Collectors.toList());
            if (this.isReorderPhases()) {
                TurboBuilderConfig config = TurboBuilderConfig.fromSession(event.getSession());
                PhaseOrderPatcher.reorderPhases(config, event.getExecutionPlan(), MojoUtils::getMojoPhase);
            }
        });
    }

    boolean isReorderPhases() {
        return !PhaseOrderPatcher.isReorderOnBootstrap();
    }

    public void afterProjectExecutionSuccess(ProjectExecutionEvent event) {
    }

    public void afterProjectExecutionFailure(ProjectExecutionEvent event) {
    }
}

