/*
 * Decompiled with CFR 0.152.
 */
package com.github.seregamorph.maven.turbo;

import com.github.seregamorph.maven.turbo.CurrentProjectExecution;
import com.github.seregamorph.maven.turbo.MojoUtils;
import com.github.seregamorph.maven.turbo.PhaseOrderPatcher;
import com.github.seregamorph.maven.turbo.SignalingExecutorCompletionService;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.execution.MojoExecutionEvent;
import org.apache.maven.execution.MojoExecutionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class TurboMojoExecutionListener
implements MojoExecutionListener {
    private static final Logger logger = LoggerFactory.getLogger(TurboMojoExecutionListener.class);

    public void beforeMojoExecution(MojoExecutionEvent event) {
        CurrentProjectExecution.ifPresent(execution -> {
            String phase;
            if (execution.packageMojos == null) {
                logger.warn("packageMojos not initialized in TurboProjectExecutionListener");
                return;
            }
            if (!execution.signaled && execution.packageMojos.isEmpty() && (phase = MojoUtils.getMojoPhase(event.getExecution())) != null && PhaseOrderPatcher.isAnyTest(phase)) {
                execution.signaled = true;
                SignalingExecutorCompletionService.signal(event.getProject());
            }
        });
    }

    public void afterMojoExecutionSuccess(MojoExecutionEvent event) {
        CurrentProjectExecution.ifPresent(execution -> {
            if (execution.packageMojos == null) {
                logger.warn("packageMojos not initialized in TurboProjectExecutionListener");
                return;
            }
            if (!execution.signaled && execution.packageMojos.contains(event.getExecution())) {
                execution.executedPackageMojos.add(event.getExecution());
                if (execution.packageMojos.equals(execution.executedPackageMojos)) {
                    execution.signaled = true;
                    SignalingExecutorCompletionService.signal(event.getProject());
                }
            }
        });
    }

    public void afterExecutionFailure(MojoExecutionEvent event) {
    }
}

