/*
 * Decompiled with CFR 0.152.
 */
package com.github.seregamorph.maven.turbo;

import com.github.seregamorph.maven.turbo.MavenPropertyUtils;
import com.github.seregamorph.maven.turbo.TurboBuilderConfig;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Named;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.SessionScoped;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SessionScoped
@Named
public class TurboMavenLifecycleParticipant
extends AbstractMavenLifecycleParticipant {
    public static final String ANSI_RESET = "\u001b[0m";
    public static final String ANSI_RED = "\u001b[31m";
    private static final Logger logger = LoggerFactory.getLogger(TurboMavenLifecycleParticipant.class);

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        if (TurboMavenLifecycleParticipant.isTurboBuilder(session)) {
            this.checkTestJarArtifacts(session);
            this.checkBuilderAndPhase(session);
        }
    }

    public void afterSessionEnd(MavenSession session) {
        if (TurboMavenLifecycleParticipant.isTurboBuilder(session)) {
            this.checkBuilderAndPhase(session);
        }
    }

    private void checkTestJarArtifacts(MavenSession session) throws MavenExecutionException {
        TurboBuilderConfig config = TurboBuilderConfig.fromSession(session);
        if (!config.isTurboTestCompile()) {
            for (MavenProject project : session.getProjects()) {
                List jarPlugins = project.getBuildPlugins().stream().filter(plugin -> "org.apache.maven.plugins".equals(plugin.getGroupId()) && "maven-jar-plugin".equals(plugin.getArtifactId())).collect(Collectors.toList());
                for (Plugin jarPlugin : jarPlugins) {
                    for (PluginExecution pluginExecution : jarPlugin.getExecutions()) {
                        if (!pluginExecution.getGoals().contains("test-jar")) continue;
                        throw new MavenExecutionException("Maven started with turbo builder (`-b turbo` CLI parameter or `-bturbo` in .mvn/maven.config) and it's not compatible with " + project + " test-jar project artifacts and dependencies because of build phase reordering (package phase is now executed before compiling tests). The maven-jar-plugin configuration of the project has configured `test-jar` goal.\nThis can be solved in several ways:\n1. Get rid of test-jar packaging if possible\n2. Opt-in support of test-jar packaging via `-DturboTestCompile` CLI parameter or specified in .mvn/maven.config on a separate line", project.getFile());
                    }
                }
            }
        }
    }

    private void checkBuilderAndPhase(MavenSession session) {
        String skippedReorderedPhases;
        TurboBuilderConfig config = TurboBuilderConfig.fromSession(session);
        boolean mavenTestSkip = MavenPropertyUtils.isTrue(MavenPropertyUtils.getProperty(session, "maven.test.skip"));
        boolean skipTests = MavenPropertyUtils.isTrue(MavenPropertyUtils.getProperty(session, "skipTests"));
        if (mavenTestSkip) {
            skippedReorderedPhases = null;
        } else if (config.isTurboTestCompile()) {
            skippedReorderedPhases = skipTests ? null : "running";
        } else {
            String string = skippedReorderedPhases = skipTests ? "compiling" : "compiling and running";
        }
        if (skippedReorderedPhases != null && session.getRequest().getGoals().contains("package")) {
            logger.warn("package phase is requested in combination with turbo builder (`-bturbo` parameter in the command line or .mvn/maven.config). Please note, that\n\u001b[31m{} tests is not included in the execution\u001b[0m because of phase reordering.\n{}To run tests, use `test`, `verify` or `install` phase instead of `package`.", (Object)skippedReorderedPhases, (Object)(config.isTurboTestCompile() ? "" : "To compile tests, run with parameter `-DturboTestCompile`.\n"));
        }
    }

    private static boolean isTurboBuilder(MavenSession session) {
        String builderId = session.getRequest().getBuilderId();
        return "turbo".equals(builderId);
    }
}

