/*
 * Decompiled with CFR 0.152.
 */
package com.github.seregamorph.maven.turbo;

import com.github.seregamorph.maven.turbo.MavenPropertyUtils;
import org.apache.maven.execution.MavenSession;

public class TurboBuilderConfig {
    private final boolean turboTestCompile;

    static TurboBuilderConfig fromSession(MavenSession session) {
        String turboTestCompile = MavenPropertyUtils.getProperty(session, "turboTestCompile");
        return new TurboBuilderConfig(MavenPropertyUtils.isTrue(turboTestCompile));
    }

    TurboBuilderConfig(boolean turboTestCompile) {
        this.turboTestCompile = turboTestCompile;
    }

    public boolean isTurboTestCompile() {
        return this.turboTestCompile;
    }

    public String toString() {
        return "TurboBuilderConfig{turboTestCompile=" + this.turboTestCompile + '}';
    }
}

