/*
 * Decompiled with CFR 0.152.
 */
package com.github.seregamorph.maven.turbo;

import com.github.seregamorph.maven.turbo.CurrentProjectExecution;
import com.github.seregamorph.maven.turbo.OrderedCallable;
import com.github.seregamorph.maven.turbo.OrderedFutureTask;
import com.github.seregamorph.maven.turbo.PhaseOrderPatcher;
import com.github.seregamorph.maven.turbo.SignalingExecutorCompletionService;
import com.github.seregamorph.maven.turbo.TurboBuilderConfig;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.DefaultLifecycles;
import org.apache.maven.lifecycle.internal.BuildThreadFactory;
import org.apache.maven.lifecycle.internal.LifecycleModuleBuilder;
import org.apache.maven.lifecycle.internal.ProjectBuildList;
import org.apache.maven.lifecycle.internal.ProjectSegment;
import org.apache.maven.lifecycle.internal.ReactorBuildStatus;
import org.apache.maven.lifecycle.internal.ReactorContext;
import org.apache.maven.lifecycle.internal.TaskSegment;
import org.apache.maven.lifecycle.internal.builder.Builder;
import org.apache.maven.lifecycle.internal.builder.multithreaded.ConcurrencyDependencyGraph;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named(value="turbo")
public class TurboBuilder
implements Builder {
    private static final Logger logger = LoggerFactory.getLogger(TurboBuilder.class);
    public static final String BUILDER_TURBO = "turbo";
    private final DefaultLifecycles defaultLifeCycles;
    private final LifecycleModuleBuilder lifecycleModuleBuilder;

    @Inject
    public TurboBuilder(DefaultLifecycles defaultLifeCycles, LifecycleModuleBuilder lifecycleModuleBuilder) {
        this.defaultLifeCycles = defaultLifeCycles;
        this.lifecycleModuleBuilder = lifecycleModuleBuilder;
    }

    private void patchLifecycles(MavenSession session) {
        if (PhaseOrderPatcher.isReorderOnBootstrap()) {
            this.defaultLifeCycles.getLifeCycles().forEach(lifecycle -> {
                if ("default".equals(lifecycle.getId())) {
                    logger.warn("Turbo builder: patching default lifecycle \ud83c\udfce\ufe0f (reorder package and test phases)");
                    TurboBuilderConfig config = TurboBuilderConfig.fromSession(session);
                    PhaseOrderPatcher.reorderPhases(config, lifecycle.getPhases(), Function.identity());
                }
            });
        } else {
            logger.warn("Turbo builder: package and test phases are reordered \ud83c\udfce");
        }
    }

    private void restoreLifecycles() {
        if (PhaseOrderPatcher.isReorderOnBootstrap()) {
            this.defaultLifeCycles.getLifeCycles().forEach(lifecycle -> {
                if ("default".equals(lifecycle.getId())) {
                    logger.debug("Restoring original order of phases");
                    PhaseOrderPatcher.restorePhases(lifecycle.getPhases());
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build(MavenSession session, ReactorContext reactorContext, ProjectBuildList projectBuilds, List<TaskSegment> taskSegments, ReactorBuildStatus reactorBuildStatus) throws InterruptedException {
        this.patchLifecycles(session);
        try {
            this.buildImpl(session, reactorContext, projectBuilds, taskSegments);
        }
        finally {
            this.restoreLifecycles();
        }
    }

    private void buildImpl(MavenSession session, ReactorContext reactorContext, ProjectBuildList projectBuilds, List<TaskSegment> taskSegments) throws InterruptedException {
        int nThreads = Math.min(session.getRequest().getDegreeOfConcurrency(), session.getProjects().size());
        logger.info("TurboBuilder will use {} threads to build {} modules", (Object)nThreads, (Object)session.getProjects().size());
        boolean parallel = nThreads > 1;
        session.setParallel(parallel);
        for (ProjectSegment segment : projectBuilds) {
            segment.getSession().setParallel(parallel);
        }
        ThreadPoolExecutor executor = new ThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new PriorityBlockingQueue(), (ThreadFactory)new BuildThreadFactory()){

            @Override
            protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
                return new OrderedFutureTask((OrderedCallable)callable);
            }
        };
        SignalingExecutorCompletionService service = new SignalingExecutorCompletionService(executor);
        for (TaskSegment taskSegment : taskSegments) {
            ProjectBuildList segmentProjectBuilds = projectBuilds.getByTaskSegment(taskSegment);
            Map projectBuildMap = projectBuilds.selectSegment(taskSegment);
            try {
                ConcurrencyDependencyGraph analyzer = new ConcurrencyDependencyGraph(segmentProjectBuilds, session.getProjectDependencyGraph());
                this.multiThreadedProjectTaskSegmentBuild(analyzer, reactorContext, session, service, taskSegment, projectBuildMap);
                if (!reactorContext.getReactorBuildStatus().isHalted()) continue;
            }
            catch (Exception e) {
                session.getResult().addException((Throwable)e);
            }
            break;
        }
        executor.shutdown();
        executor.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    private void multiThreadedProjectTaskSegmentBuild(ConcurrencyDependencyGraph analyzer, ReactorContext reactorContext, MavenSession rootSession, SignalingExecutorCompletionService service, TaskSegment taskSegment, Map<MavenProject, ProjectSegment> projectBuildList) {
        Set<String> duplicateArtifactIds = TurboBuilder.gatherDuplicateArtifactIds(projectBuildList.keySet());
        ArrayList<Future<MavenProject>> tasks = new ArrayList<Future<MavenProject>>();
        for (MavenProject mavenProject : analyzer.getRootSchedulableBuilds()) {
            ProjectSegment projectSegment = projectBuildList.get(mavenProject);
            logger.debug("Scheduling: {}", (Object)projectSegment.getProject());
            Callable<MavenProject> cb = this.createBuildCallable(rootSession, projectSegment, reactorContext, taskSegment, duplicateArtifactIds);
            List downstreamDependencies = rootSession.getProjectDependencyGraph().getDownstreamProjects(mavenProject, false);
            tasks.add(service.submit(-downstreamDependencies.size(), cb));
        }
        for (int i = 0; i < analyzer.getNumberOfBuilds(); ++i) {
            try {
                MavenProject mavenProject = service.takeSignaled();
                if (reactorContext.getReactorBuildStatus().isHalted()) {
                    return;
                }
                if (analyzer.getNumberOfBuilds() <= 1) continue;
                List newItemsThatCanBeBuilt = analyzer.markAsFinished(mavenProject);
                for (MavenProject mavenProject2 : newItemsThatCanBeBuilt) {
                    ProjectSegment scheduledDependent = projectBuildList.get(mavenProject2);
                    logger.debug("Scheduling: {}", (Object)scheduledDependent);
                    Callable<MavenProject> cb = this.createBuildCallable(rootSession, scheduledDependent, reactorContext, taskSegment, duplicateArtifactIds);
                    List downstreamDependencies = rootSession.getProjectDependencyGraph().getDownstreamProjects(mavenProject2, false);
                    tasks.add(service.submit(-downstreamDependencies.size(), cb));
                }
                continue;
            }
            catch (InterruptedException | ExecutionException exception) {
                rootSession.getResult().addException((Throwable)exception);
                return;
            }
        }
        for (Future future : tasks) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                rootSession.getResult().addException((Throwable)e);
                return;
            }
        }
    }

    private Callable<MavenProject> createBuildCallable(MavenSession rootSession, ProjectSegment projectBuild, ReactorContext reactorContext, TaskSegment taskSegment, Set<String> duplicateArtifactIds) {
        return () -> {
            Thread currentThread = Thread.currentThread();
            String originalThreadName = currentThread.getName();
            MavenProject project = projectBuild.getProject();
            String threadNameSuffix = duplicateArtifactIds.contains(project.getArtifactId()) ? project.getGroupId() + ":" + project.getArtifactId() : project.getArtifactId();
            currentThread.setName("mvn-turbo-builder-" + threadNameSuffix);
            try {
                CurrentProjectExecution.doWithCurrentProject(projectBuild.getSession(), project, () -> this.lifecycleModuleBuilder.buildProject(projectBuild.getSession(), rootSession, reactorContext, project, taskSegment));
                MavenProject mavenProject = projectBuild.getProject();
                return mavenProject;
            }
            finally {
                currentThread.setName(originalThreadName);
            }
        };
    }

    private static Set<String> gatherDuplicateArtifactIds(Set<MavenProject> projects) {
        HashSet<String> artifactIds = new HashSet<String>(projects.size());
        HashSet<String> duplicateArtifactIds = new HashSet<String>();
        for (MavenProject project : projects) {
            if (artifactIds.add(project.getArtifactId())) continue;
            duplicateArtifactIds.add(project.getArtifactId());
        }
        return duplicateArtifactIds;
    }
}

