/*
 * Decompiled with CFR 0.152.
 */
package com.github.seregamorph.maven.turbo;

import com.github.seregamorph.maven.turbo.OrderedCallable;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SignalingExecutorCompletionService {
    private static final Logger logger = LoggerFactory.getLogger(SignalingExecutorCompletionService.class);
    static final ThreadLocal<Consumer<MavenProject>> currentSignaler = new ThreadLocal();
    private final ExecutorService executor;
    private final BlockingQueue<Try<MavenProject>> signaledQueue;

    SignalingExecutorCompletionService(ExecutorService executor) {
        this.executor = Objects.requireNonNull(executor);
        this.signaledQueue = new LinkedBlockingQueue<Try<MavenProject>>();
    }

    static void signal(MavenProject project) {
        Consumer<MavenProject> signaler = currentSignaler.get();
        if (signaler == null) {
            throw new IllegalStateException("Current thread does not have a signaler");
        }
        signaler.accept(project);
    }

    Future<MavenProject> submit(int order, Callable<MavenProject> buildCallable) {
        Objects.requireNonNull(buildCallable);
        return this.executor.submit(new OrderedCallable<MavenProject>(order, () -> {
            AtomicBoolean signaled = new AtomicBoolean(false);
            currentSignaler.set(mavenProject -> {
                if (!signaled.compareAndSet(false, true)) {
                    throw new IllegalStateException("Current thread has already been signaled");
                }
                logger.debug("Project {} signaled to be ready for building its downstream dependencies", mavenProject);
                this.signaledQueue.add(Try.success(mavenProject));
            });
            try {
                MavenProject result = (MavenProject)buildCallable.call();
                if (!signaled.get()) {
                    this.signaledQueue.add(Try.success(result));
                }
                MavenProject mavenProject2 = result;
                return mavenProject2;
            }
            catch (Throwable e) {
                this.signaledQueue.add(Try.failure(e));
                if (e instanceof Exception) {
                    throw e;
                }
                throw new RuntimeException(e);
            }
            finally {
                currentSignaler.remove();
            }
        }));
    }

    MavenProject takeSignaled() throws InterruptedException, ExecutionException {
        Try<MavenProject> t = this.signaledQueue.take();
        return t.get();
    }

    private static abstract class Try<T> {
        private Try() {
        }

        abstract T get() throws ExecutionException;

        static <T> Try<T> success(final T value) {
            return new Try<T>(){

                @Override
                T get() {
                    return value;
                }
            };
        }

        static <T> Try<T> failure(final Throwable e) {
            return new Try<T>(){

                @Override
                T get() throws ExecutionException {
                    throw new ExecutionException(e);
                }
            };
        }
    }
}

