/*
 * Decompiled with CFR 0.152.
 */
package com.github.seregamorph.maven.turbo;

import com.github.seregamorph.maven.turbo.TurboBuilderConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.apache.maven.Maven;

class PhaseOrderPatcher {
    static boolean isReorderOnBootstrap() {
        String mavenVersion = Maven.class.getPackage().getImplementationVersion();
        return mavenVersion != null && mavenVersion.startsWith("3.");
    }

    static <T> void reorderPhases(TurboBuilderConfig config, List<T> phaseItems, Function<T, String> phaseExtractor) {
        int lastPackageItem = -1;
        ArrayList<T> packageItems = new ArrayList<T>();
        int firstTestItemIndex = -1;
        for (int i = 0; i < phaseItems.size(); ++i) {
            T lifecycleItem = phaseItems.get(i);
            String lifecyclePhase = phaseExtractor.apply(lifecycleItem);
            if (firstTestItemIndex < 0 && (config.isTurboTestCompile() ? PhaseOrderPatcher.isTest(lifecyclePhase) : PhaseOrderPatcher.isAnyTest(lifecyclePhase))) {
                firstTestItemIndex = i;
            }
            if (!PhaseOrderPatcher.isPackage(lifecyclePhase)) continue;
            packageItems.add(lifecycleItem);
            lastPackageItem = i;
        }
        if (firstTestItemIndex > -1 && firstTestItemIndex < lastPackageItem) {
            phaseItems.removeAll(packageItems);
            phaseItems.addAll(firstTestItemIndex, packageItems);
        }
    }

    static void restorePhases(List<String> phases) {
        ArrayList<String> packagePhases = new ArrayList<String>();
        int testPhaseIndex = -1;
        for (int i = 0; i < phases.size(); ++i) {
            String lifecyclePhase = phases.get(i);
            if (testPhaseIndex < 0 && PhaseOrderPatcher.isTest(lifecyclePhase)) {
                testPhaseIndex = i;
            }
            if (!PhaseOrderPatcher.isPackage(lifecyclePhase)) continue;
            packagePhases.add(lifecyclePhase);
        }
        assert (testPhaseIndex > -1);
        phases.removeAll(packagePhases);
        phases.addAll(testPhaseIndex - packagePhases.size() + 1, packagePhases);
    }

    static boolean isPackage(String phase) {
        return Arrays.asList("prepare-package", "package").contains(phase);
    }

    private static boolean isTest(String phase) {
        return "test".equals(phase);
    }

    static boolean isAnyTest(String phase) {
        return "test".equals(phase) || phase.contains(":test") || phase.contains("-test-") || phase.startsWith("test-") || phase.endsWith("-test");
    }

    private PhaseOrderPatcher() {
    }
}

