/*
 * Decompiled with CFR 0.152.
 */
package com.github.seregamorph.maven.turbo;

import com.github.seregamorph.maven.turbo.MavenPropertyUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;

final class CurrentProjectExecution {
    private static final ThreadLocal<CurrentProjectExecution> currentProjectExecution = new ThreadLocal();
    final List<MojoExecution> executedPackageMojos = new ArrayList<MojoExecution>();
    boolean signaled;
    List<MojoExecution> packageMojos;

    private CurrentProjectExecution(MavenSession session, MavenProject project) {
        this.signaled = MavenPropertyUtils.isTrue(MavenPropertyUtils.getProperty(session, project, "skipTurboSignal"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void doWithCurrentProject(MavenSession session, MavenProject project, Runnable task) {
        CurrentProjectExecution execution = new CurrentProjectExecution(session, project);
        currentProjectExecution.set(execution);
        try {
            task.run();
        }
        finally {
            currentProjectExecution.remove();
        }
    }

    static void ifPresent(Consumer<CurrentProjectExecution> action) {
        CurrentProjectExecution execution = currentProjectExecution.get();
        if (execution != null) {
            action.accept(execution);
        }
    }
}

