/*
 * Decompiled with CFR 0.152.
 */
package com.github.penfeizhou.animation.glide;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.ResourceDecoder;
import com.bumptech.glide.load.engine.Resource;
import com.github.penfeizhou.animation.apng.decode.APNGDecoder;
import com.github.penfeizhou.animation.apng.decode.APNGParser;
import com.github.penfeizhou.animation.decode.FrameSeqDecoder;
import com.github.penfeizhou.animation.gif.decode.GifDecoder;
import com.github.penfeizhou.animation.gif.decode.GifParser;
import com.github.penfeizhou.animation.glide.AnimationDecoderOption;
import com.github.penfeizhou.animation.io.ByteBufferReader;
import com.github.penfeizhou.animation.io.Reader;
import com.github.penfeizhou.animation.loader.ByteBufferLoader;
import com.github.penfeizhou.animation.loader.Loader;
import com.github.penfeizhou.animation.webp.decode.WebPDecoder;
import com.github.penfeizhou.animation.webp.decode.WebPParser;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ByteBufferAnimationDecoder
implements ResourceDecoder<ByteBuffer, FrameSeqDecoder> {
    public boolean handles(@NonNull ByteBuffer source, @NonNull Options options) {
        return (Boolean)options.get(AnimationDecoderOption.DISABLE_ANIMATION_WEBP_DECODER) == false && WebPParser.isAWebP((Reader)new ByteBufferReader(source)) || (Boolean)options.get(AnimationDecoderOption.DISABLE_ANIMATION_APNG_DECODER) == false && APNGParser.isAPNG((Reader)new ByteBufferReader(source)) || (Boolean)options.get(AnimationDecoderOption.DISABLE_ANIMATION_GIF_DECODER) == false && GifParser.isGif((Reader)new ByteBufferReader(source));
    }

    @Nullable
    public Resource<FrameSeqDecoder> decode(final @NonNull ByteBuffer source, int width, int height, @NonNull Options options) throws IOException {
        WebPDecoder decoder;
        ByteBufferLoader loader = new ByteBufferLoader(){

            public ByteBuffer getByteBuffer() {
                source.position(0);
                return source;
            }
        };
        if (WebPParser.isAWebP((Reader)new ByteBufferReader(source))) {
            decoder = new WebPDecoder((Loader)loader, null);
        } else if (APNGParser.isAPNG((Reader)new ByteBufferReader(source))) {
            decoder = new APNGDecoder((Loader)loader, null);
        } else if (GifParser.isGif((Reader)new ByteBufferReader(source))) {
            decoder = new GifDecoder((Loader)loader, null);
        } else {
            return null;
        }
        return new FrameSeqDecoderResource((FrameSeqDecoder)decoder, source.limit());
    }

    private static class FrameSeqDecoderResource
    implements Resource<FrameSeqDecoder> {
        private final FrameSeqDecoder decoder;
        private final int size;

        FrameSeqDecoderResource(FrameSeqDecoder decoder, int size) {
            this.decoder = decoder;
            this.size = size;
        }

        @NonNull
        public Class<FrameSeqDecoder> getResourceClass() {
            return FrameSeqDecoder.class;
        }

        @NonNull
        public FrameSeqDecoder get() {
            return this.decoder;
        }

        public int getSize() {
            return this.size;
        }

        public void recycle() {
            this.decoder.stop();
        }
    }
}

