/*
 * Decompiled with CFR 0.152.
 */
package com.github.penfeizhou.animation.gif.decode;

import com.github.penfeizhou.animation.gif.decode.Block;
import com.github.penfeizhou.animation.gif.io.GifReader;
import java.io.IOException;

public class ColorTable
implements Block {
    private int[] colorTable;

    public ColorTable(int tableSize) {
        this.colorTable = new int[tableSize];
    }

    @Override
    public void receive(GifReader reader) throws IOException {
        for (int i = 0; i < this.colorTable.length; ++i) {
            byte red = reader.peek();
            byte green = reader.peek();
            byte blue = reader.peek();
            this.colorTable[i] = 0xFF000000 | (blue & 0xFF) << 16 | (green & 0xFF) << 8 | red & 0xFF;
        }
    }

    public int[] getColorTable() {
        return this.colorTable;
    }

    @Override
    public int size() {
        return this.colorTable.length * 3;
    }
}

