/*
 * Decompiled with CFR 0.152.
 */
package com.github.lwaddicor.springstartupanalysis;

import com.github.lwaddicor.springstartupanalysis.dto.StartTimeStatisticDto;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.time.StopWatch;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.stereotype.Component;

@Component
public class StartProgressBeanPostProcessor
implements BeanPostProcessor {
    private List<StartTimeStatisticDto> times = new LinkedList<StartTimeStatisticDto>();
    private Map<String, StopWatch> beanStopWatchMap = new HashMap<String, StopWatch>();
    private boolean inFactoryBean;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        this.beanStopWatchMap.put(beanName, stopWatch);
        this.inFactoryBean = false;
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        StopWatch stopWatch = this.beanStopWatchMap.get(beanName);
        if (stopWatch != null && stopWatch.isStarted()) {
            stopWatch.stop();
            if (!this.inFactoryBean) {
                long deltaT = stopWatch.getTime();
                StartTimeStatisticDto bss = new StartTimeStatisticDto(bean.getClass().toString(), deltaT);
                this.times.add(bss);
            }
        }
        this.inFactoryBean = true;
        return bean;
    }

    public List<StartTimeStatisticDto> getTimesAsArray() {
        return this.times;
    }

    public long getTotalTime() {
        return this.times.stream().mapToLong(t -> t.getTime()).sum();
    }
}

