/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumberTree;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfStructureElement;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class PdfStructureTreeRoot
extends PdfDictionary {
    private final Map<Integer, PdfObject> parentTree = new HashMap<Integer, PdfObject>();
    private final PdfIndirectReference reference;
    private int parentTreeNextKey = 0;
    private final Map<Integer, Integer> pageKeysMap = new HashMap<Integer, Integer>();
    private final PdfWriter writer;

    PdfStructureTreeRoot(PdfWriter writer) {
        super(PdfName.STRUCTTREEROOT);
        this.writer = writer;
        this.reference = writer.getPdfIndirectReference();
    }

    public void mapRole(PdfName used, PdfName standard) {
        PdfDictionary rm = (PdfDictionary)this.get(PdfName.ROLEMAP);
        if (rm == null) {
            rm = new PdfDictionary();
            this.put(PdfName.ROLEMAP, rm);
        }
        rm.put(used, standard);
    }

    public PdfWriter getWriter() {
        return this.writer;
    }

    public PdfIndirectReference getReference() {
        return this.reference;
    }

    public int addExistingObject(PdfIndirectReference reference) {
        int key = this.parentTreeNextKey++;
        this.parentTree.put(key, reference);
        return key;
    }

    void setPageMark(int page, PdfIndirectReference reference) {
        Integer entryForPageArray = this.pageKeysMap.get(page);
        if (entryForPageArray == null) {
            PdfArray ar = new PdfArray();
            entryForPageArray = this.parentTreeNextKey;
            this.parentTree.put(entryForPageArray, ar);
            ++this.parentTreeNextKey;
            this.pageKeysMap.put(page, entryForPageArray);
        }
        PdfArray pageArray = (PdfArray)this.parentTree.get(entryForPageArray);
        pageArray.add(reference);
    }

    private void nodeProcess(PdfDictionary dictionary, PdfIndirectReference reference) throws IOException {
        PdfObject obj = dictionary.get(PdfName.K);
        if (obj != null && obj.isArray() && !((PdfArray)obj).getElements().isEmpty() && !((PdfArray)obj).getElements().get(0).isNumber()) {
            PdfArray ar = (PdfArray)obj;
            for (int k = 0; k < ar.size(); ++k) {
                PdfObject pdfObj = ar.getDirectObject(k);
                if (pdfObj instanceof PdfStructureElement) {
                    PdfStructureElement e = (PdfStructureElement)pdfObj;
                    ar.set(k, e.getReference());
                    this.nodeProcess(e, e.getReference());
                    continue;
                }
                if (!(pdfObj instanceof PdfIndirectReference)) continue;
                ar.set(k, pdfObj);
            }
        }
        if (reference != null) {
            this.writer.addToBody((PdfObject)dictionary, reference);
        }
    }

    void buildTree() throws IOException {
        HashMap<Integer, PdfIndirectReference> numTree = new HashMap<Integer, PdfIndirectReference>();
        for (Integer i : this.parentTree.keySet()) {
            PdfObject ar = this.parentTree.get(i);
            if (ar instanceof PdfIndirectReference) {
                numTree.put(i, (PdfIndirectReference)ar);
                continue;
            }
            numTree.put(i, this.writer.addToBody(ar).getIndirectReference());
        }
        PdfDictionary dicTree = PdfNumberTree.writeTree(numTree, this.writer);
        if (dicTree != null) {
            this.put(PdfName.PARENTTREE, this.writer.addToBody(dicTree).getIndirectReference());
        }
        this.nodeProcess(this, this.reference);
    }
}

