/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PdfException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class MappedRandomAccessFile
implements AutoCloseable {
    private MappedByteBuffer mappedByteBuffer = null;
    private FileChannel channel = null;

    public MappedRandomAccessFile(String filename, String mode) throws IOException {
        if (mode.equals("rw")) {
            this.init(new RandomAccessFile(filename, mode).getChannel(), FileChannel.MapMode.READ_WRITE);
        } else {
            this.init(new FileInputStream(filename).getChannel(), FileChannel.MapMode.READ_ONLY);
        }
    }

    private void init(FileChannel channel, FileChannel.MapMode mapMode) throws IOException {
        if (channel.size() > Integer.MAX_VALUE) {
            throw new PdfException("The PDF file is too large. Max 2GB. Size: " + channel.size());
        }
        this.channel = channel;
        this.mappedByteBuffer = channel.map(mapMode, 0L, channel.size());
        this.mappedByteBuffer.load();
    }

    public FileChannel getChannel() {
        return this.channel;
    }

    public int read() {
        try {
            byte b = this.mappedByteBuffer.get();
            int n = b & 0xFF;
            return n;
        }
        catch (BufferUnderflowException e) {
            return -1;
        }
    }

    public int read(byte[] bytes, int off, int len) {
        int limit;
        int pos = this.mappedByteBuffer.position();
        if (pos == (limit = this.mappedByteBuffer.limit())) {
            return -1;
        }
        int newlimit = pos + len - off;
        if (newlimit > limit) {
            len = limit - pos;
        }
        this.mappedByteBuffer.get(bytes, off, len);
        return len;
    }

    public long getFilePointer() {
        return this.mappedByteBuffer.position();
    }

    public void seek(long pos) {
        this.mappedByteBuffer.position((int)pos);
    }

    public long length() {
        return this.mappedByteBuffer.limit();
    }

    @Override
    public void close() throws IOException {
        MappedRandomAccessFile.clean(this.mappedByteBuffer);
        this.mappedByteBuffer = null;
        if (this.channel != null) {
            this.channel.close();
        }
        this.channel = null;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public static boolean clean(ByteBuffer buffer) {
        if (buffer == null || !buffer.isDirect()) {
            return false;
        }
        return MappedRandomAccessFile.cleanJava11(buffer);
    }

    private static boolean cleanJava11(ByteBuffer buffer) {
        Boolean success = Boolean.FALSE;
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            MethodHandle methodHandle = lookup.findStatic(unsafeClass, "getUnsafe", MethodType.methodType(unsafeClass));
            Object theUnsafe = methodHandle.invoke();
            MethodHandle invokeCleanerMethod = lookup.findVirtual(unsafeClass, "invokeCleaner", MethodType.methodType(Void.TYPE, ByteBuffer.class));
            invokeCleanerMethod.invoke(theUnsafe, buffer);
            success = Boolean.TRUE;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return success;
    }
}

