/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.TTFCache;
import com.lowagie.text.pdf.TrueTypeFontUnicode;
import java.io.UnsupportedEncodingException;
import java.nio.IntBuffer;
import java.util.Map;
import org.apache.fop.complexscripts.fonts.GlyphSubstitutionTable;
import org.apache.fop.complexscripts.util.CharScript;
import org.apache.fop.complexscripts.util.GlyphSequence;
import org.apache.fop.fonts.truetype.TTFFile;

public class FopGlyphProcessor {
    private static final char CHAR_TO_USE_IF_GLYPH_NOT_FOUND = '#';
    private static boolean isFopSupported = false;

    public static boolean isFopSupported() {
        return isFopSupported;
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] convertToBytesWithGlyphs(BaseFont font, String text, String fileName, Map<Integer, int[]> longTag) throws UnsupportedEncodingException {
        TrueTypeFontUnicode ttu = (TrueTypeFontUnicode)font;
        IntBuffer charBuffer = IntBuffer.allocate(text.length());
        IntBuffer ghyphBuffer = IntBuffer.allocate(text.length());
        for (int n : text.toCharArray()) {
            int[] metrics = ttu.getMetricsTT(n);
            if (metrics == null) {
                n = 35;
                metrics = ttu.getMetricsTT(n);
            }
            charBuffer.put(n);
            ghyphBuffer.put(metrics[0]);
        }
        GlyphSequence glyphSequence = new GlyphSequence(charBuffer, ghyphBuffer, null);
        TTFFile ttf = TTFCache.getTTFFile(fileName);
        GlyphSubstitutionTable gsubTable = ttf.getGSUB();
        if (gsubTable != null) {
            void var10_15;
            String string = CharScript.scriptTagFromCode((int)CharScript.dominantScript((CharSequence)text));
            String language = "dflt";
            if ("zyyy".equals(string) || "auto".equals(string)) {
                String string2 = "*";
            }
            glyphSequence = gsubTable.substitute(glyphSequence, (String)var10_15, language);
        }
        int n = glyphSequence.getGlyphs().limit();
        int[] processedChars = glyphSequence.getGlyphs().array();
        char[] charEncodedGlyphCodes = new char[n];
        for (int i = 0; i < n; ++i) {
            charEncodedGlyphCodes[i] = (char)processedChars[i];
            Integer glyphCode = processedChars[i];
            if (longTag.containsKey(glyphCode)) continue;
            longTag.put(glyphCode, new int[]{processedChars[i], ttu.getGlyphWidth(processedChars[i]), processedChars[i]});
        }
        return new String(charEncodedGlyphCodes).getBytes("UnicodeBigUnmarked");
    }

    static {
        try {
            Class.forName("org.apache.fop.complexscripts.util.GlyphSequence");
            isFopSupported = true;
        }
        catch (ClassNotFoundException e) {
            isFopSupported = false;
        }
    }
}

