/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Function;
import com.kenai.jffi.Internals;
import com.kenai.jffi.PageManager;
import com.kenai.jffi.Platform;
import jnr.ffi.provider.jffi.X86_32StubCompiler;
import jnr.ffi.provider.jffi.X86_64StubCompiler;
import jnr.x86asm.Assembler;
import jnr.x86asm.CPU;

abstract class StubCompiler {
    static final long errnoFunctionAddress = StubCompiler.getErrnoSaveFunction();
    static final boolean hasPageManager = StubCompiler.hasPageManager();
    static final boolean hasAssembler = StubCompiler.hasAssembler();

    StubCompiler() {
    }

    public static final StubCompiler newCompiler() {
        if (errnoFunctionAddress != 0L && hasPageManager && hasAssembler) {
            switch (Platform.getPlatform().getCPU()) {
                case I386: {
                    if (Platform.getPlatform().getOS() == Platform.OS.WINDOWS) break;
                    return new X86_32StubCompiler();
                }
                case X86_64: {
                    if (Platform.getPlatform().getOS() == Platform.OS.WINDOWS) break;
                    return new X86_64StubCompiler();
                }
            }
        }
        return new DummyStubCompiler();
    }

    abstract boolean canCompile(Class var1, Class[] var2, CallingConvention var3);

    abstract void compile(Function var1, String var2, Class var3, Class[] var4, CallingConvention var5, boolean var6);

    abstract void attach(Class var1);

    private static final long getErrnoSaveFunction() {
        try {
            return Internals.getErrnoSaveFunction();
        }
        catch (Throwable t) {
            return 0L;
        }
    }

    private static final boolean hasPageManager() {
        try {
            long page = PageManager.getInstance().allocatePages(1, 3);
            PageManager.getInstance().freePages(page, 1);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static final boolean hasAssembler() {
        try {
            switch (Platform.getPlatform().getCPU()) {
                case I386: {
                    new Assembler(CPU.X86_32);
                    return true;
                }
                case X86_64: {
                    new Assembler(CPU.X86_64);
                    return true;
                }
            }
            return false;
        }
        catch (Throwable t) {
            return false;
        }
    }

    static final class DummyStubCompiler
    extends StubCompiler {
        DummyStubCompiler() {
        }

        boolean canCompile(Class returnType, Class[] parameterTypes, CallingConvention convention) {
            return false;
        }

        void compile(Function function, String name, Class returnType, Class[] parameterTypes, CallingConvention convention, boolean saveErrno) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        void attach(Class clazz) {
        }
    }
}

