/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import java.nio.ByteBuffer;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.ffi.provider.BoundedMemoryIO;
import jnr.ffi.provider.IntPointer;
import jnr.ffi.provider.MemoryManager;
import jnr.ffi.provider.jffi.AllocatedDirectMemoryIO;
import jnr.ffi.provider.jffi.ArrayMemoryIO;
import jnr.ffi.provider.jffi.ByteBufferMemoryIO;
import jnr.ffi.provider.jffi.DirectMemoryIO;
import jnr.ffi.provider.jffi.NativeRuntime;

public class NativeMemoryManager
implements MemoryManager {
    private final NativeRuntime runtime;

    public NativeMemoryManager(NativeRuntime runtime) {
        this.runtime = runtime;
    }

    public Pointer allocate(int size) {
        return new ArrayMemoryIO((Runtime)this.runtime, size);
    }

    public Pointer allocateDirect(int size) {
        return new BoundedMemoryIO(new AllocatedDirectMemoryIO(this.runtime, size, false), 0L, size);
    }

    public Pointer allocateDirect(int size, boolean clear) {
        return new BoundedMemoryIO(new AllocatedDirectMemoryIO(this.runtime, size, clear), 0L, size);
    }

    public Pointer allocateTemporary(int size) {
        return new ArrayMemoryIO((Runtime)this.runtime, size);
    }

    public Pointer allocateTemporary(int size, boolean clear) {
        return new ArrayMemoryIO((Runtime)this.runtime, size);
    }

    public Pointer newPointer(ByteBuffer buffer) {
        return new ByteBufferMemoryIO(this.runtime, buffer);
    }

    public Pointer newPointer(long address) {
        return new DirectMemoryIO((Runtime)this.runtime, address);
    }

    public Pointer newPointer(long address, long size) {
        return new BoundedMemoryIO(new DirectMemoryIO((Runtime)this.runtime, address), 0L, size);
    }

    public Pointer newOpaquePointer(long address) {
        return new IntPointer((Runtime)this.runtime, address);
    }
}

