/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import com.kenai.jffi.Platform;
import com.kenai.jffi.Type;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.util.Map;
import jnr.ffi.Address;
import jnr.ffi.CallingConvention;
import jnr.ffi.LibraryOption;
import jnr.ffi.NativeLong;
import jnr.ffi.Pointer;
import jnr.ffi.Struct;
import jnr.ffi.annotations.IgnoreError;
import jnr.ffi.annotations.LongLong;
import jnr.ffi.annotations.SaveError;
import jnr.ffi.byref.ByReference;
import jnr.ffi.provider.jffi.AsmUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class InvokerUtil {
    InvokerUtil() {
    }

    static final Type getNativeReturnType(Method method) {
        return InvokerUtil.getNativeReturnType(method.getReturnType(), method.getAnnotations());
    }

    static final Type getNativeReturnType(Class type, Annotation[] annotations) {
        if (Void.class.isAssignableFrom(type) || Void.TYPE == type) {
            return Type.VOID;
        }
        if (Boolean.class.isAssignableFrom(type) || Boolean.TYPE == type) {
            return Type.SINT32;
        }
        if (Byte.class.isAssignableFrom(type) || Byte.TYPE == type) {
            return Type.SINT8;
        }
        if (Short.class.isAssignableFrom(type) || Short.TYPE == type) {
            return Type.SINT16;
        }
        if (Integer.class.isAssignableFrom(type) || Integer.TYPE == type) {
            return Type.SINT32;
        }
        if (Long.class.isAssignableFrom(type) || Long.TYPE == type) {
            return InvokerUtil.isLongLong(type, annotations) ? Type.SLONG_LONG : Type.SLONG;
        }
        if (NativeLong.class.isAssignableFrom(type)) {
            return Type.SLONG;
        }
        if (Float.class.isAssignableFrom(type) || Float.TYPE == type) {
            return Type.FLOAT;
        }
        if (Double.class.isAssignableFrom(type) || Double.TYPE == type) {
            return Type.DOUBLE;
        }
        if (Enum.class.isAssignableFrom(type)) {
            return Type.SINT32;
        }
        if (Pointer.class.isAssignableFrom(type)) {
            return Type.POINTER;
        }
        if (Address.class.isAssignableFrom(type)) {
            return Type.POINTER;
        }
        if (Struct.class.isAssignableFrom(type)) {
            return Type.POINTER;
        }
        if (String.class.isAssignableFrom(type)) {
            return Type.POINTER;
        }
        throw new IllegalArgumentException("Unsupported return type: " + type);
    }

    static final Type getNativeParameterType(Class type, Annotation[] annotations) {
        if (Byte.class.isAssignableFrom(type) || Byte.TYPE == type) {
            return Type.SINT8;
        }
        if (Short.class.isAssignableFrom(type) || Short.TYPE == type) {
            return Type.SINT16;
        }
        if (Integer.class.isAssignableFrom(type) || Integer.TYPE == type) {
            return Type.SINT32;
        }
        if (Long.class.isAssignableFrom(type) || Long.TYPE == type) {
            return InvokerUtil.isLongLong(type, annotations) ? Type.SLONG_LONG : Type.SLONG;
        }
        if (NativeLong.class.isAssignableFrom(type)) {
            return Type.SLONG;
        }
        if (Float.class.isAssignableFrom(type) || Float.TYPE == type) {
            return Type.FLOAT;
        }
        if (Double.class.isAssignableFrom(type) || Double.TYPE == type) {
            return Type.DOUBLE;
        }
        if (Boolean.class.isAssignableFrom(type) || Boolean.TYPE == type) {
            return Type.SINT32;
        }
        if (Enum.class.isAssignableFrom(type)) {
            return Type.SINT32;
        }
        if (Pointer.class.isAssignableFrom(type)) {
            return Type.POINTER;
        }
        if (Address.class.isAssignableFrom(type)) {
            return Type.POINTER;
        }
        if (Struct.class.isAssignableFrom(type)) {
            return Type.POINTER;
        }
        if (Buffer.class.isAssignableFrom(type)) {
            return Type.POINTER;
        }
        if (CharSequence.class.isAssignableFrom(type)) {
            return Type.POINTER;
        }
        if (ByReference.class.isAssignableFrom(type)) {
            return Type.POINTER;
        }
        if (type.isArray()) {
            return Type.POINTER;
        }
        if (AsmUtil.isDelegate(type)) {
            return Type.POINTER;
        }
        throw new IllegalArgumentException("Unsupported parameter type: " + type);
    }

    public static final boolean requiresErrno(Method method) {
        boolean saveError = true;
        for (Annotation a : method.getAnnotations()) {
            if (a instanceof IgnoreError) {
                saveError = false;
                continue;
            }
            if (!(a instanceof SaveError)) continue;
            saveError = true;
        }
        return saveError;
    }

    public static final com.kenai.jffi.CallingConvention getCallingConvention(Map<LibraryOption, ?> libraryOptions) {
        Object convention = libraryOptions.get((Object)LibraryOption.CallingConvention);
        if (convention instanceof com.kenai.jffi.CallingConvention) {
            return (com.kenai.jffi.CallingConvention)convention;
        }
        if (convention instanceof CallingConvention) {
            switch ((CallingConvention)((Object)convention)) {
                case DEFAULT: {
                    return com.kenai.jffi.CallingConvention.DEFAULT;
                }
                case STDCALL: {
                    return com.kenai.jffi.CallingConvention.STDCALL;
                }
            }
        } else if (convention != null) {
            throw new IllegalArgumentException("unknown calling convention: " + convention);
        }
        return com.kenai.jffi.CallingConvention.DEFAULT;
    }

    public static boolean hasAnnotation(Annotation[] annotations, Class<? extends Annotation> annotationClass) {
        for (Annotation a : annotations) {
            if (!annotationClass.isInstance(a)) continue;
            return true;
        }
        return false;
    }

    static boolean isLong32(Class type, Annotation[] annotations) {
        return (Long.TYPE == type || Long.class.isAssignableFrom(type)) && Platform.getPlatform().longSize() == 32 && !InvokerUtil.hasAnnotation(annotations, LongLong.class);
    }

    static boolean isLongLong(Class type, Annotation[] annotations) {
        return !(Long.TYPE != type && !Long.class.isAssignableFrom(type) || !InvokerUtil.hasAnnotation(annotations, LongLong.class) && Platform.getPlatform().longSize() != 64);
    }
}

