/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import com.kenai.jffi.Platform;
import com.kenai.jffi.Type;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.Buffer;
import jnr.ffi.Address;
import jnr.ffi.NativeLong;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.ffi.Struct;
import jnr.ffi.annotations.Delegate;
import jnr.ffi.mapper.ToNativeConverter;
import jnr.ffi.mapper.TypeMapper;
import jnr.ffi.provider.ParameterFlags;
import jnr.ffi.provider.jffi.AsmRuntime;
import jnr.ffi.provider.jffi.CodegenUtils;
import jnr.ffi.provider.jffi.InvokerUtil;
import jnr.ffi.provider.jffi.NativeRuntime;
import jnr.ffi.provider.jffi.NumberUtil;
import jnr.ffi.provider.jffi.SkinnyMethodAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.EmptyVisitor;

final class AsmUtil {
    private AsmUtil() {
    }

    public static final MethodVisitor newTraceMethodVisitor(MethodVisitor mv) {
        try {
            Class<MethodVisitor> tmvClass = Class.forName("org.objectweb.asm.util.TraceMethodVisitor").asSubclass(MethodVisitor.class);
            Constructor<MethodVisitor> c = tmvClass.getDeclaredConstructor(MethodVisitor.class);
            return c.newInstance(mv);
        }
        catch (Throwable t) {
            return mv;
        }
    }

    public static final ClassVisitor newTraceClassVisitor(ClassVisitor cv, OutputStream out) {
        return AsmUtil.newTraceClassVisitor(cv, new PrintWriter(out, true));
    }

    public static final ClassVisitor newTraceClassVisitor(ClassVisitor cv, PrintWriter out) {
        try {
            Class<ClassVisitor> tmvClass = Class.forName("org.objectweb.asm.util.TraceClassVisitor").asSubclass(ClassVisitor.class);
            Constructor<ClassVisitor> c = tmvClass.getDeclaredConstructor(ClassVisitor.class, PrintWriter.class);
            return c.newInstance(cv, out);
        }
        catch (Throwable t) {
            return cv;
        }
    }

    public static final ClassVisitor newTraceClassVisitor(PrintWriter out) {
        try {
            Class<ClassVisitor> tmvClass = Class.forName("org.objectweb.asm.util.TraceClassVisitor").asSubclass(ClassVisitor.class);
            Constructor<ClassVisitor> c = tmvClass.getDeclaredConstructor(PrintWriter.class);
            return c.newInstance(out);
        }
        catch (Throwable t) {
            return new EmptyVisitor();
        }
    }

    public static final ClassVisitor newCheckClassAdapter(ClassVisitor cv) {
        try {
            Class<ClassVisitor> tmvClass = Class.forName("org.objectweb.asm.util.CheckClassAdapter").asSubclass(ClassVisitor.class);
            Constructor<ClassVisitor> c = tmvClass.getDeclaredConstructor(ClassVisitor.class);
            return c.newInstance(cv);
        }
        catch (Throwable t) {
            return cv;
        }
    }

    public static final Class unboxedReturnType(Class type) {
        if (Pointer.class.isAssignableFrom(type) || Struct.class.isAssignableFrom(type) || String.class.isAssignableFrom(type)) {
            return Platform.getPlatform().longSize() == 32 ? Integer.TYPE : Long.TYPE;
        }
        return AsmUtil.unboxedType(type);
    }

    public static final Class unboxedParameterType(Class type) {
        if (Buffer.class.isAssignableFrom(type)) {
            return Platform.getPlatform().longSize() == 32 ? Integer.TYPE : Long.TYPE;
        }
        return AsmUtil.unboxedType(type);
    }

    public static final Class unboxedType(Class boxedType) {
        if (boxedType == Byte.class) {
            return Byte.TYPE;
        }
        if (boxedType == Short.class) {
            return Short.TYPE;
        }
        if (boxedType == Integer.class) {
            return Integer.TYPE;
        }
        if (boxedType == Long.class) {
            return Long.TYPE;
        }
        if (boxedType == Float.class) {
            return Float.TYPE;
        }
        if (boxedType == Double.class) {
            return Double.TYPE;
        }
        if (boxedType == Boolean.class) {
            return Boolean.TYPE;
        }
        if (boxedType == NativeLong.class) {
            return Platform.getPlatform().longSize() == 32 ? Integer.TYPE : Long.TYPE;
        }
        if (Pointer.class.isAssignableFrom(boxedType) || Struct.class.isAssignableFrom(boxedType)) {
            return Platform.getPlatform().addressSize() == 32 ? Integer.TYPE : Long.TYPE;
        }
        if (String.class == boxedType) {
            return Platform.getPlatform().addressSize() == 32 ? Integer.TYPE : Long.TYPE;
        }
        if (Enum.class.isAssignableFrom(boxedType)) {
            return Integer.TYPE;
        }
        return boxedType;
    }

    public static final Class boxedType(Class type) {
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        return type;
    }

    static final void emitReturnOp(SkinnyMethodAdapter mv, Class returnType) {
        if (!returnType.isPrimitive()) {
            mv.areturn();
        } else if (Long.TYPE == returnType) {
            mv.lreturn();
        } else if (Float.TYPE == returnType) {
            mv.freturn();
        } else if (Double.TYPE == returnType) {
            mv.dreturn();
        } else if (Void.TYPE == returnType) {
            mv.voidreturn();
        } else {
            mv.ireturn();
        }
    }

    static final int calculateLocalVariableSpace(Class type) {
        return Long.TYPE == type || Double.TYPE == type ? 2 : 1;
    }

    static final int calculateLocalVariableSpace(Class ... types) {
        int size = 0;
        for (int i = 0; i < types.length; ++i) {
            size += AsmUtil.calculateLocalVariableSpace(types[i]);
        }
        return size;
    }

    private static final void unboxPointerOrStruct(SkinnyMethodAdapter mv, Class type, Class nativeType) {
        mv.invokestatic(CodegenUtils.p(AsmRuntime.class), Long.TYPE == nativeType ? "longValue" : "intValue", CodegenUtils.sig(nativeType, type));
    }

    static final void unboxPointer(SkinnyMethodAdapter mv, Class nativeType) {
        AsmUtil.unboxPointerOrStruct(mv, Pointer.class, nativeType);
    }

    static final void unboxStruct(SkinnyMethodAdapter mv, Class nativeType) {
        AsmUtil.unboxPointerOrStruct(mv, Struct.class, nativeType);
    }

    static final void unboxBuffer(SkinnyMethodAdapter mv, Class type, Class nativeType) {
        mv.invokestatic(CodegenUtils.p(AsmRuntime.class), "longValue", CodegenUtils.sig(Long.TYPE, type));
        NumberUtil.narrow(mv, Long.TYPE, nativeType);
    }

    static final void unboxEnum(SkinnyMethodAdapter mv, Class nativeType) {
        mv.invokestatic(CodegenUtils.p(AsmRuntime.class), Long.TYPE == nativeType ? "longValue" : "intValue", CodegenUtils.sig(nativeType, Enum.class));
    }

    static final void unboxBoolean(SkinnyMethodAdapter mv, Class boxedType, Class nativeType) {
        mv.invokevirtual(CodegenUtils.p(boxedType), "booleanValue", "()Z");
        NumberUtil.widen(mv, Boolean.TYPE, nativeType);
    }

    static final void unboxBoolean(SkinnyMethodAdapter mv, Class nativeType) {
        AsmUtil.unboxBoolean(mv, Boolean.class, nativeType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static final void unboxNumber(SkinnyMethodAdapter mv, Class boxedType, Class nativeType) {
        if (Number.class.isAssignableFrom(boxedType)) {
            if (Byte.TYPE == nativeType) {
                mv.invokevirtual(CodegenUtils.p(boxedType), "byteValue", "()B");
                return;
            } else if (Short.TYPE == nativeType) {
                mv.invokevirtual(CodegenUtils.p(boxedType), "shortValue", "()S");
                return;
            } else if (Integer.TYPE == nativeType) {
                mv.invokevirtual(CodegenUtils.p(boxedType), "intValue", "()I");
                return;
            } else if (Long.TYPE == nativeType) {
                mv.invokevirtual(CodegenUtils.p(boxedType), "longValue", "()J");
                return;
            } else if (Float.TYPE == nativeType) {
                mv.invokevirtual(CodegenUtils.p(boxedType), "floatValue", "()F");
                return;
            } else {
                if (Double.TYPE != nativeType) throw new IllegalArgumentException("unsupported Number subclass: " + boxedType);
                mv.invokevirtual(CodegenUtils.p(boxedType), "doubleValue", "()D");
            }
            return;
        } else if (Boolean.class.isAssignableFrom(boxedType)) {
            AsmUtil.unboxBoolean(mv, nativeType);
            return;
        } else {
            if (!Enum.class.isAssignableFrom(boxedType)) throw new IllegalArgumentException("unsupported boxed type: " + boxedType);
            AsmUtil.unboxEnum(mv, nativeType);
        }
    }

    static final void boxValue(SkinnyMethodAdapter mv, Class returnType, Class nativeReturnType) {
        if (returnType == nativeReturnType) {
            return;
        }
        if (Boolean.class.isAssignableFrom(returnType)) {
            NumberUtil.narrow(mv, nativeReturnType, Boolean.TYPE);
            mv.invokestatic(Boolean.class, "valueOf", Boolean.class, Boolean.TYPE);
        } else if (Pointer.class.isAssignableFrom(returnType)) {
            mv.invokestatic(AsmRuntime.class, "pointerValue", Pointer.class, nativeReturnType);
        } else if (Address.class == returnType) {
            mv.invokestatic(returnType, "valueOf", returnType, nativeReturnType);
        } else if (Struct.class.isAssignableFrom(returnType)) {
            AsmUtil.boxStruct(mv, returnType, nativeReturnType);
        } else if (Number.class.isAssignableFrom(returnType)) {
            AsmUtil.boxNumber(mv, returnType, nativeReturnType);
        } else if (String.class == returnType) {
            mv.invokestatic(AsmRuntime.class, "stringValue", String.class, nativeReturnType);
        } else {
            throw new IllegalArgumentException("cannot box value of type " + nativeReturnType + " to " + returnType);
        }
    }

    static final void boxStruct(SkinnyMethodAdapter mv, Class structClass, Class nativeType) {
        Label nonnull = new Label();
        Label end = new Label();
        if (Long.TYPE == nativeType) {
            mv.dup2();
            mv.lconst_0();
            mv.lcmp();
            mv.ifne(nonnull);
            mv.pop2();
        } else {
            mv.dup();
            mv.ifne(nonnull);
            mv.pop();
        }
        mv.aconst_null();
        mv.go_to(end);
        mv.label(nonnull);
        mv.newobj(CodegenUtils.p(structClass));
        mv.dup();
        try {
            Constructor<Struct> constructor = structClass.asSubclass(Struct.class).getConstructor(Runtime.class);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException("struct subclass " + structClass.getName() + " has no constructor that takes a " + Runtime.class.getName(), ex);
        }
        mv.invokestatic(CodegenUtils.p(NativeRuntime.class), "getInstance", CodegenUtils.sig(NativeRuntime.class, new Class[0]));
        mv.invokespecial(structClass, "<init>", Void.TYPE, Runtime.class);
        if (Long.TYPE == nativeType) {
            mv.dup_x2();
        } else {
            mv.dup_x1();
        }
        mv.invokestatic(AsmRuntime.class, "useMemory", Void.TYPE, nativeType, Struct.class);
        mv.label(end);
    }

    static final void boxNumber(SkinnyMethodAdapter mv, Class type, Class nativeType) {
        Class primitiveClass = NumberUtil.getPrimitiveClass(type);
        NumberUtil.widen(mv, nativeType, primitiveClass);
        NumberUtil.narrow(mv, nativeType, primitiveClass);
        mv.invokestatic(type, "valueOf", type, primitiveClass);
    }

    static boolean isDelegate(Class klass) {
        for (Method m : klass.getMethods()) {
            if (!m.isAnnotationPresent(Delegate.class)) continue;
            return true;
        }
        return false;
    }

    static final Type getNativeParameterType(Method method, int paramIndex, TypeMapper mapper) {
        Class<?> type = method.getParameterTypes()[paramIndex];
        ToNativeConverter converter = mapper.getToNativeConverter(type);
        return InvokerUtil.getNativeParameterType(converter != null ? converter.nativeType() : type, method.getParameterAnnotations()[paramIndex]);
    }

    static final int getParameterFlags(Method method, int paramIndex) {
        return AsmUtil.getParameterFlags(method.getParameterAnnotations()[paramIndex]);
    }

    static final int getParameterFlags(Annotation[] annotations) {
        return ParameterFlags.parse(annotations);
    }

    static final int getNativeArrayFlags(int flags) {
        int nflags = 0;
        nflags |= ParameterFlags.isIn(flags) ? 1 : 0;
        nflags |= ParameterFlags.isOut(flags) ? 2 : 0;
        return nflags |= ParameterFlags.isNulTerminate(flags) ? 4 : 0;
    }

    static final int getNativeArrayFlags(Annotation[] annotations) {
        return AsmUtil.getNativeArrayFlags(AsmUtil.getParameterFlags(annotations));
    }
}

