/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.heaven.util.lang;

import com.github.houbb.heaven.util.guava.Guavas;
import com.github.houbb.heaven.util.util.ArrayUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import com.github.houbb.heaven.util.util.DateUtil;
import java.util.List;

public final class ConsoleUtil {
    public static final String LINE = "--------------------------------------------------------";

    private ConsoleUtil() {
    }

    public static void info(String className, String methodName, String format, Object ... args) {
        String formatStr = ConsoleUtil.buildString(format, args);
        ConsoleUtil.log("INFO", className, methodName, formatStr, null);
    }

    public static void info(String format, Object ... args) {
        StackTraceElement callMethodElem = Thread.currentThread().getStackTrace()[3];
        String className = callMethodElem.getClassName();
        String methodNameName = callMethodElem.getMethodName();
        ConsoleUtil.info(className, methodNameName, format, args);
    }

    private static String buildString(String format, Object[] params) {
        String stringFormat = format;
        for (int i = 0; i < params.length; ++i) {
            stringFormat = stringFormat.replaceFirst("\\{}", "%s");
        }
        return String.format(stringFormat, params);
    }

    private static void log(String level, String className, String methodName, String content, Throwable throwable) {
        String prettyMethod = ConsoleUtil.buildPrettyMethodName(className, methodName);
        String dateStr = DateUtil.getCurrentDateTimeStr();
        String log = String.format("[%s] [%s] [%s] - %s", level, dateStr, prettyMethod, content);
        if ("ERROR".equalsIgnoreCase(level)) {
            System.err.println(log);
        } else {
            System.out.println(log);
        }
        if (throwable != null) {
            throwable.printStackTrace(System.err);
        }
    }

    private static String buildPrettyMethodName(String className, String methodName) {
        Object[] classNames = className.split("\\.");
        if (ArrayUtil.isEmpty(classNames)) {
            return methodName;
        }
        int length = classNames.length;
        if (length == 1) {
            return className + "." + methodName;
        }
        List<String> classFirstChars = Guavas.newArrayList(length);
        for (int i = 0; i < length - 1; ++i) {
            Object name = classNames[i];
            classFirstChars.add(String.valueOf(((String)name).charAt(0)));
        }
        classFirstChars.add((String)classNames[length - 1]);
        String prettyClass = CollectionUtil.join(classFirstChars, ".");
        return prettyClass + "." + methodName;
    }
}

