/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.streams;

import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.datastructures.streams.RMStream;
import com.github.fppt.jedismock.datastructures.streams.SequencedMap;
import com.github.fppt.jedismock.datastructures.streams.SequencedMapIterator;
import com.github.fppt.jedismock.datastructures.streams.StreamId;
import com.github.fppt.jedismock.exception.WrongStreamKeyException;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Ranges
extends AbstractRedisOperation {
    protected int multiplier = 1;

    Ranges(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    protected StreamId preprocessExclusiveBorder(StreamId key, boolean isStart) throws WrongStreamKeyException {
        if (isStart) {
            return key.increment();
        }
        return key.decrement();
    }

    protected StreamId preprocessKey(Slice key, RMStream stream, boolean isStart) throws WrongStreamKeyException {
        StreamId id;
        String rawKey = key.toString();
        if (rawKey.equals("-")) {
            return stream.getStoredData().getHead();
        }
        if (rawKey.equals("+")) {
            return stream.getStoredData().getTail();
        }
        boolean exclusive = false;
        if (rawKey.charAt(0) == '(') {
            exclusive = true;
            id = new StreamId(rawKey.substring(1));
        } else {
            id = new StreamId(key);
        }
        if (exclusive) {
            id = this.preprocessExclusiveBorder(id, isStart);
        }
        return id;
    }

    protected Slice range() {
        StreamId end;
        StreamId start;
        RMStream stream = this.getStreamFromBaseOrCreateEmpty(this.params().get(0));
        SequencedMap<StreamId, SequencedMap<Slice, Slice>> map = stream.getStoredData();
        int count = map.size();
        try {
            start = this.preprocessKey(this.params().get(1), stream, true);
            end = this.preprocessKey(this.params().get(2), stream, false);
        }
        catch (WrongStreamKeyException e) {
            return Response.error(e.getMessage());
        }
        if (this.params().size() > 3) {
            if (this.params().size() != 5) {
                return Response.error("ERR syntax error");
            }
            if (!"count".equalsIgnoreCase(this.params().get(3).toString())) {
                return Response.error("ERR syntax error");
            }
            try {
                count = Integer.parseInt(this.params().get(4).toString());
            }
            catch (NumberFormatException e) {
                return Response.error("ERR value is not an integer or out of range");
            }
        }
        if (map.size() == 0) {
            return Response.array(Collections.emptyList());
        }
        if (this.multiplier == 1 ? start.compareTo(map.getTail()) > 0 : start.compareTo(map.getHead()) < 0) {
            return Response.array(Collections.emptyList());
        }
        SequencedMapIterator<StreamId, SequencedMap<Slice, Slice>> it = this.multiplier == 1 ? map.iterator(start) : map.reverseIterator(start);
        ArrayList<Slice> output = new ArrayList<Slice>();
        int entriesAdded = 1;
        while (it.hasNext() && entriesAdded++ <= count) {
            ArrayList<Slice> entrySlice = new ArrayList<Slice>();
            Object entry = it.next();
            if (this.multiplier * ((StreamId)entry.getKey()).compareTo(end) > 0) break;
            ((SequencedMap)entry.getValue()).forEach((key, value) -> {
                entrySlice.add(Response.bulkString(key));
                entrySlice.add(Response.bulkString(value));
            });
            output.add(Response.array(Arrays.asList(Response.bulkString(((StreamId)entry.getKey()).toSlice()), Response.array(entrySlice))));
        }
        return Response.array(output);
    }

    @Override
    protected Slice response() {
        return null;
    }
}

