/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.sortedsets;

import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.operations.sortedsets.AbstractZRangeByLex;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.List;

@RedisCommand(value="zlexcount")
class ZLexCount
extends AbstractZRangeByLex {
    ZLexCount(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    @Override
    protected Slice response() {
        this.expectNoOptions();
        this.key = this.params().get(0);
        this.mapDBObj = this.getZSetFromBaseOrCreateEmpty(this.key);
        Slice start = this.params().get(1);
        if (this.notValidate(start.toString())) {
            return this.buildErrorResponse("start");
        }
        Slice end = this.params().get(2);
        if (this.notValidate(end.toString())) {
            return this.buildErrorResponse("end");
        }
        return Response.integer(this.getRange(this.getStartBound(start), this.getEndBound(end)).size());
    }

    private boolean notValidate(String forValidate) {
        return !"-".equals(forValidate) && !"+".equals(forValidate) && !this.startsWithAnyPrefix(forValidate);
    }
}

