/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.examples;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.report.ProcessingMessage;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.util.JsonLoader;
import java.io.IOException;

public abstract class ExampleBase {
    private static final String PKGBASE;

    protected static void printReport(ProcessingReport report) {
        boolean success = report.isSuccess();
        System.out.println("Validation " + (success ? "succeeded" : "failed"));
        if (!success) {
            System.out.println("---- BEGIN REPORT ----");
            for (ProcessingMessage message : report) {
                System.out.println(message);
            }
            System.out.println("---- END REPORT ----");
        }
    }

    protected static JsonNode loadResource(String name) throws IOException {
        return JsonLoader.fromResource((String)(PKGBASE + name));
    }

    static {
        String pkgName = ExampleBase.class.getPackage().getName();
        PKGBASE = '/' + pkgName.replace(".", "/");
    }
}

