/*
 * Decompiled with CFR 0.152.
 */
package javapns.notification;

import javapns.notification.PushNotificationManager;
import javapns.notification.PushedNotification;

public class ResponsePacket {
    private int command;
    private int status;
    private int identifier;

    protected ResponsePacket() {
    }

    protected ResponsePacket(int command, int status, int identifier) {
        this.command = command;
        this.status = status;
        this.identifier = identifier;
    }

    protected void linkToPushedNotification(PushNotificationManager notificationManager) {
        PushedNotification notification = null;
        try {
            notification = notificationManager.getPushedNotifications().get(this.identifier);
            if (notification != null) {
                notification.setResponse(this);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getCommand() {
        return this.command;
    }

    protected void setCommand(int command) {
        this.command = command;
    }

    public boolean isErrorResponsePacket() {
        return this.command == 8;
    }

    public int getStatus() {
        return this.status;
    }

    protected void setStatus(int status) {
        this.status = status;
    }

    public boolean isValidErrorMessage() {
        if (!this.isErrorResponsePacket()) {
            return false;
        }
        return this.status != 0;
    }

    public int getIdentifier() {
        return this.identifier;
    }

    protected void setIdentifier(int identifier) {
        this.identifier = identifier;
    }

    public String getMessage() {
        if (this.command == 8) {
            String prefix = "APNS: [" + this.identifier + "] ";
            if (this.status == 0) {
                return prefix + "No errors encountered";
            }
            if (this.status == 1) {
                return prefix + "Processing error";
            }
            if (this.status == 2) {
                return prefix + "Missing device token";
            }
            if (this.status == 3) {
                return prefix + "Missing topic";
            }
            if (this.status == 4) {
                return prefix + "Missing payload";
            }
            if (this.status == 5) {
                return prefix + "Invalid token size";
            }
            if (this.status == 6) {
                return prefix + "Invalid topic size";
            }
            if (this.status == 7) {
                return prefix + "Invalid payload size";
            }
            if (this.status == 8) {
                return prefix + "Invalid token";
            }
            if (this.status == 255) {
                return prefix + "None (unknown)";
            }
            return prefix + "Undocumented status code: " + this.status;
        }
        return "APNS: Undocumented response command: " + this.command;
    }
}

