/*
 * Decompiled with CFR 0.152.
 */
package javapns.notification;

import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javapns.notification.PushedNotification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PushedNotifications
extends Vector<PushedNotification>
implements List<PushedNotification> {
    private static final long serialVersionUID = 1L;
    private int maxRetained = 1000;

    public PushedNotifications() {
    }

    public PushedNotifications(int capacity) {
        super(capacity);
    }

    public PushedNotifications(PushedNotifications parent) {
        this.maxRetained = parent.getMaxRetained();
    }

    public PushedNotifications getSuccessfulNotifications() {
        PushedNotifications filteredList = new PushedNotifications(this);
        for (PushedNotification notification : this) {
            if (!notification.isSuccessful()) continue;
            filteredList.add(notification);
        }
        return filteredList;
    }

    public PushedNotifications getFailedNotifications() {
        PushedNotifications filteredList = new PushedNotifications(this);
        for (PushedNotification notification : this) {
            if (notification.isSuccessful()) continue;
            filteredList.add(notification);
        }
        return filteredList;
    }

    @Override
    public synchronized boolean add(PushedNotification notification) {
        this.prepareAdd(1);
        return super.add(notification);
    }

    @Override
    public synchronized void addElement(PushedNotification notification) {
        this.prepareAdd(1);
        super.addElement(notification);
    }

    @Override
    public synchronized boolean addAll(Collection<? extends PushedNotification> notifications) {
        this.prepareAdd(notifications.size());
        return super.addAll(notifications);
    }

    private void prepareAdd(int n) {
        int size = this.size();
        if (size + n > this.maxRetained) {
            for (int i = 0; i < n; ++i) {
                this.remove(0);
            }
        }
    }

    public void setMaxRetained(int maxRetained) {
        this.maxRetained = maxRetained;
    }

    public int getMaxRetained() {
        return this.maxRetained;
    }
}

