/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Binds;
import com.github.dockerjava.api.model.BlkioRateDevice;
import com.github.dockerjava.api.model.BlkioWeightDevice;
import com.github.dockerjava.api.model.Capability;
import com.github.dockerjava.api.model.Device;
import com.github.dockerjava.api.model.DeviceRequest;
import com.github.dockerjava.api.model.DockerObject;
import com.github.dockerjava.api.model.Isolation;
import com.github.dockerjava.api.model.Link;
import com.github.dockerjava.api.model.Links;
import com.github.dockerjava.api.model.LogConfig;
import com.github.dockerjava.api.model.LxcConf;
import com.github.dockerjava.api.model.Mount;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.api.model.RestartPolicy;
import com.github.dockerjava.api.model.Ulimit;
import com.github.dockerjava.api.model.VolumesFrom;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckForNull;
import lombok.Generated;

public class HostConfig
extends DockerObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final List<String> PREDEFINED_NETWORKS = Arrays.asList("bridge", "host", "none");
    @JsonProperty(value="Binds")
    private Binds binds;
    @JsonProperty(value="BlkioWeight")
    private Integer blkioWeight;
    @JsonProperty(value="BlkioWeightDevice")
    private List<BlkioWeightDevice> blkioWeightDevice;
    @JsonProperty(value="BlkioDeviceReadBps")
    private List<BlkioRateDevice> blkioDeviceReadBps;
    @JsonProperty(value="BlkioDeviceWriteBps")
    private List<BlkioRateDevice> blkioDeviceWriteBps;
    @JsonProperty(value="BlkioDeviceReadIOps")
    private List<BlkioRateDevice> blkioDeviceReadIOps;
    @JsonProperty(value="BlkioDeviceWriteIOps")
    private List<BlkioRateDevice> blkioDeviceWriteIOps;
    @JsonProperty(value="MemorySwappiness")
    private Long memorySwappiness;
    @JsonProperty(value="NanoCpus")
    private Long nanoCPUs;
    @JsonProperty(value="Annotations")
    private Map<String, String> annotations;
    @JsonProperty(value="CapAdd")
    private Capability[] capAdd;
    @JsonProperty(value="CapDrop")
    private Capability[] capDrop;
    @JsonProperty(value="ContainerIDFile")
    private String containerIDFile;
    @JsonProperty(value="CpuPeriod")
    private Long cpuPeriod;
    @JsonProperty(value="CpuRealtimePeriod")
    private Long cpuRealtimePeriod;
    @JsonProperty(value="CpuRealtimeRuntime")
    private Long cpuRealtimeRuntime;
    @JsonProperty(value="CpuShares")
    private Integer cpuShares;
    @JsonProperty(value="CpuQuota")
    private Long cpuQuota;
    @JsonProperty(value="CpusetCpus")
    private String cpusetCpus;
    @JsonProperty(value="CpusetMems")
    private String cpusetMems;
    @JsonProperty(value="Devices")
    private Device[] devices;
    @JsonProperty(value="DeviceCgroupRules")
    private List<String> deviceCgroupRules;
    @JsonProperty(value="DeviceRequests")
    private List<DeviceRequest> deviceRequests;
    @JsonProperty(value="DiskQuota")
    private Long diskQuota;
    @JsonProperty(value="Dns")
    private String[] dns;
    @JsonProperty(value="DnsOptions")
    private List<String> dnsOptions;
    @JsonProperty(value="DnsSearch")
    private String[] dnsSearch;
    @JsonProperty(value="ExtraHosts")
    private String[] extraHosts;
    @JsonProperty(value="GroupAdd")
    private List<String> groupAdd;
    @JsonProperty(value="IpcMode")
    private String ipcMode;
    @JsonProperty(value="Cgroup")
    private String cgroup;
    @JsonProperty(value="Links")
    private Links links;
    @JsonProperty(value="LogConfig")
    private LogConfig logConfig;
    @JsonProperty(value="LxcConf")
    private LxcConf[] lxcConf;
    @JsonProperty(value="Memory")
    private Long memory;
    @JsonProperty(value="MemorySwap")
    private Long memorySwap;
    @JsonProperty(value="MemoryReservation")
    private Long memoryReservation;
    @JsonProperty(value="KernelMemory")
    private Long kernelMemory;
    @JsonProperty(value="NetworkMode")
    private String networkMode;
    @JsonProperty(value="OomKillDisable")
    private Boolean oomKillDisable;
    @JsonProperty(value="Init")
    private Boolean init;
    @JsonProperty(value="AutoRemove")
    private Boolean autoRemove;
    @JsonProperty(value="OomScoreAdj")
    private Integer oomScoreAdj;
    @JsonProperty(value="PortBindings")
    private Ports portBindings;
    @JsonProperty(value="Privileged")
    private Boolean privileged;
    @JsonProperty(value="PublishAllPorts")
    private Boolean publishAllPorts;
    @JsonProperty(value="ReadonlyRootfs")
    private Boolean readonlyRootfs;
    @JsonProperty(value="RestartPolicy")
    private RestartPolicy restartPolicy;
    @JsonProperty(value="Ulimits")
    private Ulimit[] ulimits;
    @JsonProperty(value="CpuCount")
    private Long cpuCount;
    @JsonProperty(value="CpuPercent")
    private Long cpuPercent;
    @JsonProperty(value="IOMaximumIOps")
    private Long ioMaximumIOps;
    @JsonProperty(value="IOMaximumBandwidth")
    private Long ioMaximumBandwidth;
    @JsonProperty(value="VolumesFrom")
    private VolumesFrom[] volumesFrom;
    @JsonProperty(value="Mounts")
    private List<Mount> mounts;
    @JsonProperty(value="PidMode")
    private String pidMode;
    @JsonProperty(value="Isolation")
    private Isolation isolation;
    @JsonProperty(value="SecurityOpt")
    private List<String> securityOpts;
    @JsonProperty(value="StorageOpt")
    private Map<String, String> storageOpt;
    @JsonProperty(value="CgroupParent")
    private String cgroupParent;
    @JsonProperty(value="VolumeDriver")
    private String volumeDriver;
    @JsonProperty(value="ShmSize")
    private Long shmSize;
    @JsonProperty(value="PidsLimit")
    private Long pidsLimit;
    @JsonProperty(value="Runtime")
    private String runtime;
    @JsonProperty(value="Tmpfs")
    private Map<String, String> tmpFs;
    @JsonProperty(value="UTSMode")
    private String utSMode;
    @JsonProperty(value="UsernsMode")
    private String usernsMode;
    @JsonProperty(value="Sysctls")
    private Map<String, String> sysctls;
    @JsonProperty(value="ConsoleSize")
    private List<Integer> consoleSize;
    @JsonProperty(value="CgroupnsMode")
    private String cgroupnsMode;

    public static HostConfig newHostConfig() {
        return new HostConfig();
    }

    @JsonIgnore
    public Bind[] getBinds() {
        return this.binds == null ? new Bind[]{} : this.binds.getBinds();
    }

    public Integer getBlkioWeight() {
        return this.blkioWeight;
    }

    @CheckForNull
    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public Capability[] getCapAdd() {
        return this.capAdd;
    }

    public Capability[] getCapDrop() {
        return this.capDrop;
    }

    public String getContainerIDFile() {
        return this.containerIDFile;
    }

    public Long getCpuPeriod() {
        return this.cpuPeriod;
    }

    public Integer getCpuShares() {
        return this.cpuShares;
    }

    public String getCpusetCpus() {
        return this.cpusetCpus;
    }

    public String getCpusetMems() {
        return this.cpusetMems;
    }

    public Device[] getDevices() {
        return this.devices;
    }

    public Long getDiskQuota() {
        return this.diskQuota;
    }

    public String[] getDns() {
        return this.dns;
    }

    public String[] getDnsSearch() {
        return this.dnsSearch;
    }

    public String[] getExtraHosts() {
        return this.extraHosts;
    }

    @JsonIgnore
    public Link[] getLinks() {
        return this.links == null ? new Link[]{} : this.links.getLinks();
    }

    @JsonIgnore
    public LogConfig getLogConfig() {
        return this.logConfig == null ? new LogConfig() : this.logConfig;
    }

    public LxcConf[] getLxcConf() {
        return this.lxcConf;
    }

    public Long getMemory() {
        return this.memory;
    }

    public Long getMemorySwap() {
        return this.memorySwap;
    }

    public String getNetworkMode() {
        return this.networkMode;
    }

    public Ports getPortBindings() {
        return this.portBindings;
    }

    public RestartPolicy getRestartPolicy() {
        return this.restartPolicy;
    }

    public Ulimit[] getUlimits() {
        return this.ulimits;
    }

    public VolumesFrom[] getVolumesFrom() {
        return this.volumesFrom;
    }

    @CheckForNull
    public String getPidMode() {
        return this.pidMode;
    }

    @CheckForNull
    public List<BlkioRateDevice> getBlkioDeviceReadBps() {
        return this.blkioDeviceReadBps;
    }

    @CheckForNull
    public List<BlkioRateDevice> getBlkioDeviceReadIOps() {
        return this.blkioDeviceReadIOps;
    }

    @CheckForNull
    public List<BlkioRateDevice> getBlkioDeviceWriteBps() {
        return this.blkioDeviceWriteBps;
    }

    @CheckForNull
    public List<BlkioRateDevice> getBlkioDeviceWriteIOps() {
        return this.blkioDeviceWriteIOps;
    }

    @CheckForNull
    public List<BlkioWeightDevice> getBlkioWeightDevice() {
        return this.blkioWeightDevice;
    }

    @CheckForNull
    public Integer getOomScoreAdj() {
        return this.oomScoreAdj;
    }

    @CheckForNull
    public Long getCpuQuota() {
        return this.cpuQuota;
    }

    @CheckForNull
    public Long getKernelMemory() {
        return this.kernelMemory;
    }

    @CheckForNull
    public Long getMemoryReservation() {
        return this.memoryReservation;
    }

    @CheckForNull
    public Long getMemorySwappiness() {
        return this.memorySwappiness;
    }

    @CheckForNull
    public Boolean getOomKillDisable() {
        return this.oomKillDisable;
    }

    @CheckForNull
    public Boolean getAutoRemove() {
        return this.autoRemove;
    }

    @CheckForNull
    public List<String> getSecurityOpts() {
        return this.securityOpts;
    }

    @CheckForNull
    public String getCgroupParent() {
        return this.cgroupParent;
    }

    @CheckForNull
    public Long getShmSize() {
        return this.shmSize;
    }

    @CheckForNull
    public String getVolumeDriver() {
        return this.volumeDriver;
    }

    @CheckForNull
    public Long getPidsLimit() {
        return this.pidsLimit;
    }

    @CheckForNull
    public Map<String, String> getTmpFs() {
        return this.tmpFs;
    }

    @JsonIgnore
    public boolean isUserDefinedNetwork() {
        return this.networkMode != null && !PREDEFINED_NETWORKS.contains(this.networkMode) && !this.networkMode.startsWith("container:");
    }

    public String getRuntime() {
        return this.runtime;
    }

    @JsonIgnore
    public void setBinds(Bind ... binds) {
        this.binds = new Binds(binds);
    }

    @JsonIgnore
    public void setLinks(Link ... links) {
        this.links = new Links(links);
    }

    public HostConfig withBinds(Binds binds) {
        this.binds = binds;
        return this;
    }

    public HostConfig withBinds(Bind ... binds) {
        Objects.requireNonNull(binds, "binds was not specified");
        this.setBinds(binds);
        return this;
    }

    public HostConfig withBinds(List<Bind> binds) {
        Objects.requireNonNull(binds, "binds was not specified");
        return this.withBinds(binds.toArray(new Bind[binds.size()]));
    }

    public HostConfig withBlkioDeviceReadBps(List<BlkioRateDevice> blkioDeviceReadBps) {
        this.blkioDeviceReadBps = blkioDeviceReadBps;
        return this;
    }

    public HostConfig withBlkioDeviceReadIOps(List<BlkioRateDevice> blkioDeviceReadIOps) {
        this.blkioDeviceReadIOps = blkioDeviceReadIOps;
        return this;
    }

    public HostConfig withBlkioDeviceWriteBps(List<BlkioRateDevice> blkioDeviceWriteBps) {
        this.blkioDeviceWriteBps = blkioDeviceWriteBps;
        return this;
    }

    public HostConfig withBlkioDeviceWriteIOps(List<BlkioRateDevice> blkioDeviceWriteIOps) {
        this.blkioDeviceWriteIOps = blkioDeviceWriteIOps;
        return this;
    }

    public HostConfig withBlkioWeight(Integer blkioWeight) {
        this.blkioWeight = blkioWeight;
        return this;
    }

    public HostConfig withBlkioWeightDevice(List<BlkioWeightDevice> blkioWeightDevice) {
        this.blkioWeightDevice = blkioWeightDevice;
        return this;
    }

    public HostConfig withAnnotations(Map<String, String> annotations) {
        this.annotations = annotations;
        return this;
    }

    public HostConfig withCapAdd(Capability ... capAdd) {
        this.capAdd = capAdd;
        return this;
    }

    public HostConfig withCapDrop(Capability ... capDrop) {
        this.capDrop = capDrop;
        return this;
    }

    public HostConfig withCgroupParent(String cgroupParent) {
        this.cgroupParent = cgroupParent;
        return this;
    }

    public HostConfig withContainerIDFile(String containerIDFile) {
        this.containerIDFile = containerIDFile;
        return this;
    }

    public HostConfig withCpuPeriod(Long cpuPeriod) {
        this.cpuPeriod = cpuPeriod;
        return this;
    }

    public HostConfig withCpuQuota(Long cpuQuota) {
        this.cpuQuota = cpuQuota;
        return this;
    }

    public HostConfig withCpusetCpus(String cpusetCpus) {
        this.cpusetCpus = cpusetCpus;
        return this;
    }

    public HostConfig withCpusetMems(String cpusetMems) {
        this.cpusetMems = cpusetMems;
        return this;
    }

    public HostConfig withCpuShares(Integer cpuShares) {
        this.cpuShares = cpuShares;
        return this;
    }

    public HostConfig withDevices(Device ... devices) {
        this.devices = devices;
        return this;
    }

    public HostConfig withDevices(List<Device> devices) {
        Objects.requireNonNull(devices, "devices was not specified");
        return this.withDevices(devices.toArray(new Device[0]));
    }

    public HostConfig withDiskQuota(Long diskQuota) {
        this.diskQuota = diskQuota;
        return this;
    }

    public HostConfig withDns(String ... dns) {
        this.dns = dns;
        return this;
    }

    public HostConfig withDns(List<String> dns) {
        Objects.requireNonNull(dns, "dns was not specified");
        return this.withDns(dns.toArray(new String[0]));
    }

    public HostConfig withDnsSearch(String ... dnsSearch) {
        this.dnsSearch = dnsSearch;
        return this;
    }

    public HostConfig withDnsSearch(List<String> dnsSearch) {
        Objects.requireNonNull(dnsSearch, "dnsSearch was not specified");
        return this.withDnsSearch(dnsSearch.toArray(new String[0]));
    }

    public HostConfig withExtraHosts(String ... extraHosts) {
        this.extraHosts = extraHosts;
        return this;
    }

    public HostConfig withKernelMemory(Long kernelMemory) {
        this.kernelMemory = kernelMemory;
        return this;
    }

    public HostConfig withLinks(Links links) {
        this.links = links;
        return this;
    }

    public HostConfig withLinks(Link ... links) {
        Objects.requireNonNull(links, "links was not specified");
        this.setLinks(links);
        return this;
    }

    public HostConfig withLinks(List<Link> links) {
        Objects.requireNonNull(links, "links was not specified");
        return this.withLinks(links.toArray(new Link[0]));
    }

    public HostConfig withLogConfig(LogConfig logConfig) {
        this.logConfig = logConfig;
        return this;
    }

    public HostConfig withLxcConf(LxcConf[] lxcConf) {
        this.lxcConf = lxcConf;
        return this;
    }

    public HostConfig withMemory(Long memory) {
        this.memory = memory;
        return this;
    }

    public HostConfig withMemoryReservation(Long memoryReservation) {
        this.memoryReservation = memoryReservation;
        return this;
    }

    public HostConfig withMemorySwap(Long memorySwap) {
        this.memorySwap = memorySwap;
        return this;
    }

    public HostConfig withMemorySwappiness(Long memorySwappiness) {
        this.memorySwappiness = memorySwappiness;
        return this;
    }

    public HostConfig withNetworkMode(String networkMode) {
        this.networkMode = networkMode;
        return this;
    }

    public HostConfig withOomKillDisable(Boolean oomKillDisable) {
        this.oomKillDisable = oomKillDisable;
        return this;
    }

    public HostConfig withAutoRemove(Boolean autoRemove) {
        this.autoRemove = autoRemove;
        return this;
    }

    public HostConfig withOomScoreAdj(Integer oomScoreAdj) {
        this.oomScoreAdj = oomScoreAdj;
        return this;
    }

    public HostConfig withPidMode(String pidMode) {
        this.pidMode = pidMode;
        return this;
    }

    public HostConfig withPortBindings(Ports portBindings) {
        this.portBindings = portBindings;
        return this;
    }

    public HostConfig withPortBindings(PortBinding ... portBindings) {
        Objects.requireNonNull(portBindings, "portBindings was not specified");
        this.withPortBindings(new Ports(portBindings));
        return this;
    }

    public HostConfig withPortBindings(List<PortBinding> portBindings) {
        Objects.requireNonNull(portBindings, "portBindings was not specified");
        return this.withPortBindings(portBindings.toArray(new PortBinding[0]));
    }

    @CheckForNull
    public Boolean getPrivileged() {
        return this.privileged;
    }

    public HostConfig withPrivileged(Boolean privileged) {
        this.privileged = privileged;
        return this;
    }

    @CheckForNull
    public Boolean getPublishAllPorts() {
        return this.publishAllPorts;
    }

    public HostConfig withPublishAllPorts(Boolean publishAllPorts) {
        this.publishAllPorts = publishAllPorts;
        return this;
    }

    @CheckForNull
    public Boolean getReadonlyRootfs() {
        return this.readonlyRootfs;
    }

    public HostConfig withReadonlyRootfs(Boolean readonlyRootfs) {
        this.readonlyRootfs = readonlyRootfs;
        return this;
    }

    public HostConfig withRestartPolicy(RestartPolicy restartPolicy) {
        this.restartPolicy = restartPolicy;
        return this;
    }

    public HostConfig withSecurityOpts(List<String> securityOpts) {
        this.securityOpts = securityOpts;
        return this;
    }

    public HostConfig withShmSize(Long shmSize) {
        this.shmSize = shmSize;
        return this;
    }

    public HostConfig withUlimits(Ulimit[] ulimits) {
        this.ulimits = ulimits;
        return this;
    }

    public HostConfig withUlimits(List<Ulimit> ulimits) {
        Objects.requireNonNull(ulimits, "no ulimits was specified");
        return this.withUlimits(ulimits.toArray(new Ulimit[0]));
    }

    public HostConfig withVolumeDriver(String volumeDriver) {
        this.volumeDriver = volumeDriver;
        return this;
    }

    public HostConfig withVolumesFrom(VolumesFrom ... volumesFrom) {
        this.volumesFrom = volumesFrom;
        return this;
    }

    public HostConfig withVolumesFrom(List<VolumesFrom> volumesFrom) {
        Objects.requireNonNull(volumesFrom, "volumesFrom was not specified");
        return this.withVolumesFrom(volumesFrom.toArray(new VolumesFrom[0]));
    }

    public HostConfig withPidsLimit(Long pidsLimit) {
        this.pidsLimit = pidsLimit;
        return this;
    }

    public HostConfig withRuntime(String runtime) {
        this.runtime = runtime;
        return this;
    }

    public HostConfig withTmpFs(Map<String, String> tmpFs) {
        this.tmpFs = tmpFs;
        return this;
    }

    @CheckForNull
    public List<String> getDeviceCgroupRules() {
        return this.deviceCgroupRules;
    }

    public HostConfig withDeviceCgroupRules(List<String> deviceCgroupRules) {
        this.deviceCgroupRules = deviceCgroupRules;
        return this;
    }

    @CheckForNull
    public List<DeviceRequest> getDeviceRequests() {
        return this.deviceRequests;
    }

    public HostConfig withDeviceRequests(List<DeviceRequest> deviceRequests) {
        this.deviceRequests = deviceRequests;
        return this;
    }

    @CheckForNull
    public Long getNanoCPUs() {
        return this.nanoCPUs;
    }

    public HostConfig withNanoCPUs(Long nanoCPUs) {
        this.nanoCPUs = nanoCPUs;
        return this;
    }

    @CheckForNull
    public Boolean getInit() {
        return this.init;
    }

    public HostConfig withInit(Boolean init) {
        this.init = init;
        return this;
    }

    @CheckForNull
    public Long getCpuCount() {
        return this.cpuCount;
    }

    public HostConfig withCpuCount(Long cpuCount) {
        this.cpuCount = cpuCount;
        return this;
    }

    @CheckForNull
    public Long getCpuPercent() {
        return this.cpuPercent;
    }

    public HostConfig withCpuPercent(Long cpuPercent) {
        this.cpuPercent = cpuPercent;
        return this;
    }

    @CheckForNull
    public Long getIoMaximumIOps() {
        return this.ioMaximumIOps;
    }

    public HostConfig withIoMaximumIOps(Long ioMaximumIOps) {
        this.ioMaximumIOps = ioMaximumIOps;
        return this;
    }

    @CheckForNull
    public Long getIoMaximumBandwidth() {
        return this.ioMaximumBandwidth;
    }

    public HostConfig withIoMaximumBandwidth(Long ioMaximumBandwidth) {
        this.ioMaximumBandwidth = ioMaximumBandwidth;
        return this;
    }

    @CheckForNull
    public List<Mount> getMounts() {
        return this.mounts;
    }

    public HostConfig withMounts(List<Mount> mounts) {
        this.mounts = mounts;
        return this;
    }

    @CheckForNull
    public List<String> getDnsOptions() {
        return this.dnsOptions;
    }

    public HostConfig withDnsOptions(List<String> dnsOptions) {
        this.dnsOptions = dnsOptions;
        return this;
    }

    @CheckForNull
    public List<String> getGroupAdd() {
        return this.groupAdd;
    }

    public HostConfig withGroupAdd(List<String> groupAdd) {
        this.groupAdd = groupAdd;
        return this;
    }

    @CheckForNull
    public String getIpcMode() {
        return this.ipcMode;
    }

    public HostConfig withIpcMode(String ipcMode) {
        this.ipcMode = ipcMode;
        return this;
    }

    @CheckForNull
    public String getCgroup() {
        return this.cgroup;
    }

    public HostConfig withCgroup(String cgroup) {
        this.cgroup = cgroup;
        return this;
    }

    @CheckForNull
    public Map<String, String> getStorageOpt() {
        return this.storageOpt;
    }

    public HostConfig withStorageOpt(Map<String, String> storageOpt) {
        this.storageOpt = storageOpt;
        return this;
    }

    @CheckForNull
    public String getUtSMode() {
        return this.utSMode;
    }

    public HostConfig withUtSMode(String utSMode) {
        this.utSMode = utSMode;
        return this;
    }

    @CheckForNull
    public String getUsernsMode() {
        return this.usernsMode;
    }

    public HostConfig withUsernsMode(String usernsMode) {
        this.usernsMode = usernsMode;
        return this;
    }

    @CheckForNull
    public String getCgroupnsMode() {
        return this.cgroupnsMode;
    }

    public HostConfig withCgroupnsMode(String cgroupnsMode) {
        this.cgroupnsMode = cgroupnsMode;
        return this;
    }

    @CheckForNull
    public Map<String, String> getSysctls() {
        return this.sysctls;
    }

    public HostConfig withSysctls(Map<String, String> sysctls) {
        this.sysctls = sysctls;
        return this;
    }

    @CheckForNull
    public List<Integer> getConsoleSize() {
        return this.consoleSize;
    }

    public HostConfig withConsoleSize(List<Integer> consoleSize) {
        this.consoleSize = consoleSize;
        return this;
    }

    @CheckForNull
    public Isolation getIsolation() {
        return this.isolation;
    }

    public HostConfig withIsolation(Isolation isolation) {
        this.isolation = isolation;
        return this;
    }

    @CheckForNull
    public Long getCpuRealtimePeriod() {
        return this.cpuRealtimePeriod;
    }

    public HostConfig withCpuRealtimePeriod(Long cpuRealtimePeriod) {
        this.cpuRealtimePeriod = cpuRealtimePeriod;
        return this;
    }

    @CheckForNull
    public Long getCpuRealtimeRuntime() {
        return this.cpuRealtimeRuntime;
    }

    public HostConfig withCpuRealtimeRuntime(Long cpuRealtimeRuntime) {
        this.cpuRealtimeRuntime = cpuRealtimeRuntime;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HostConfig)) {
            return false;
        }
        HostConfig other = (HostConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$blkioWeight = this.getBlkioWeight();
        Integer other$blkioWeight = other.getBlkioWeight();
        if (this$blkioWeight == null ? other$blkioWeight != null : !((Object)this$blkioWeight).equals(other$blkioWeight)) {
            return false;
        }
        Long this$memorySwappiness = this.getMemorySwappiness();
        Long other$memorySwappiness = other.getMemorySwappiness();
        if (this$memorySwappiness == null ? other$memorySwappiness != null : !((Object)this$memorySwappiness).equals(other$memorySwappiness)) {
            return false;
        }
        Long this$nanoCPUs = this.getNanoCPUs();
        Long other$nanoCPUs = other.getNanoCPUs();
        if (this$nanoCPUs == null ? other$nanoCPUs != null : !((Object)this$nanoCPUs).equals(other$nanoCPUs)) {
            return false;
        }
        Long this$cpuPeriod = this.getCpuPeriod();
        Long other$cpuPeriod = other.getCpuPeriod();
        if (this$cpuPeriod == null ? other$cpuPeriod != null : !((Object)this$cpuPeriod).equals(other$cpuPeriod)) {
            return false;
        }
        Long this$cpuRealtimePeriod = this.getCpuRealtimePeriod();
        Long other$cpuRealtimePeriod = other.getCpuRealtimePeriod();
        if (this$cpuRealtimePeriod == null ? other$cpuRealtimePeriod != null : !((Object)this$cpuRealtimePeriod).equals(other$cpuRealtimePeriod)) {
            return false;
        }
        Long this$cpuRealtimeRuntime = this.getCpuRealtimeRuntime();
        Long other$cpuRealtimeRuntime = other.getCpuRealtimeRuntime();
        if (this$cpuRealtimeRuntime == null ? other$cpuRealtimeRuntime != null : !((Object)this$cpuRealtimeRuntime).equals(other$cpuRealtimeRuntime)) {
            return false;
        }
        Integer this$cpuShares = this.getCpuShares();
        Integer other$cpuShares = other.getCpuShares();
        if (this$cpuShares == null ? other$cpuShares != null : !((Object)this$cpuShares).equals(other$cpuShares)) {
            return false;
        }
        Long this$cpuQuota = this.getCpuQuota();
        Long other$cpuQuota = other.getCpuQuota();
        if (this$cpuQuota == null ? other$cpuQuota != null : !((Object)this$cpuQuota).equals(other$cpuQuota)) {
            return false;
        }
        Long this$diskQuota = this.getDiskQuota();
        Long other$diskQuota = other.getDiskQuota();
        if (this$diskQuota == null ? other$diskQuota != null : !((Object)this$diskQuota).equals(other$diskQuota)) {
            return false;
        }
        Long this$memory = this.getMemory();
        Long other$memory = other.getMemory();
        if (this$memory == null ? other$memory != null : !((Object)this$memory).equals(other$memory)) {
            return false;
        }
        Long this$memorySwap = this.getMemorySwap();
        Long other$memorySwap = other.getMemorySwap();
        if (this$memorySwap == null ? other$memorySwap != null : !((Object)this$memorySwap).equals(other$memorySwap)) {
            return false;
        }
        Long this$memoryReservation = this.getMemoryReservation();
        Long other$memoryReservation = other.getMemoryReservation();
        if (this$memoryReservation == null ? other$memoryReservation != null : !((Object)this$memoryReservation).equals(other$memoryReservation)) {
            return false;
        }
        Long this$kernelMemory = this.getKernelMemory();
        Long other$kernelMemory = other.getKernelMemory();
        if (this$kernelMemory == null ? other$kernelMemory != null : !((Object)this$kernelMemory).equals(other$kernelMemory)) {
            return false;
        }
        Boolean this$oomKillDisable = this.getOomKillDisable();
        Boolean other$oomKillDisable = other.getOomKillDisable();
        if (this$oomKillDisable == null ? other$oomKillDisable != null : !((Object)this$oomKillDisable).equals(other$oomKillDisable)) {
            return false;
        }
        Boolean this$init = this.getInit();
        Boolean other$init = other.getInit();
        if (this$init == null ? other$init != null : !((Object)this$init).equals(other$init)) {
            return false;
        }
        Boolean this$autoRemove = this.getAutoRemove();
        Boolean other$autoRemove = other.getAutoRemove();
        if (this$autoRemove == null ? other$autoRemove != null : !((Object)this$autoRemove).equals(other$autoRemove)) {
            return false;
        }
        Integer this$oomScoreAdj = this.getOomScoreAdj();
        Integer other$oomScoreAdj = other.getOomScoreAdj();
        if (this$oomScoreAdj == null ? other$oomScoreAdj != null : !((Object)this$oomScoreAdj).equals(other$oomScoreAdj)) {
            return false;
        }
        Boolean this$privileged = this.getPrivileged();
        Boolean other$privileged = other.getPrivileged();
        if (this$privileged == null ? other$privileged != null : !((Object)this$privileged).equals(other$privileged)) {
            return false;
        }
        Boolean this$publishAllPorts = this.getPublishAllPorts();
        Boolean other$publishAllPorts = other.getPublishAllPorts();
        if (this$publishAllPorts == null ? other$publishAllPorts != null : !((Object)this$publishAllPorts).equals(other$publishAllPorts)) {
            return false;
        }
        Boolean this$readonlyRootfs = this.getReadonlyRootfs();
        Boolean other$readonlyRootfs = other.getReadonlyRootfs();
        if (this$readonlyRootfs == null ? other$readonlyRootfs != null : !((Object)this$readonlyRootfs).equals(other$readonlyRootfs)) {
            return false;
        }
        Long this$cpuCount = this.getCpuCount();
        Long other$cpuCount = other.getCpuCount();
        if (this$cpuCount == null ? other$cpuCount != null : !((Object)this$cpuCount).equals(other$cpuCount)) {
            return false;
        }
        Long this$cpuPercent = this.getCpuPercent();
        Long other$cpuPercent = other.getCpuPercent();
        if (this$cpuPercent == null ? other$cpuPercent != null : !((Object)this$cpuPercent).equals(other$cpuPercent)) {
            return false;
        }
        Long this$ioMaximumIOps = this.getIoMaximumIOps();
        Long other$ioMaximumIOps = other.getIoMaximumIOps();
        if (this$ioMaximumIOps == null ? other$ioMaximumIOps != null : !((Object)this$ioMaximumIOps).equals(other$ioMaximumIOps)) {
            return false;
        }
        Long this$ioMaximumBandwidth = this.getIoMaximumBandwidth();
        Long other$ioMaximumBandwidth = other.getIoMaximumBandwidth();
        if (this$ioMaximumBandwidth == null ? other$ioMaximumBandwidth != null : !((Object)this$ioMaximumBandwidth).equals(other$ioMaximumBandwidth)) {
            return false;
        }
        Long this$shmSize = this.getShmSize();
        Long other$shmSize = other.getShmSize();
        if (this$shmSize == null ? other$shmSize != null : !((Object)this$shmSize).equals(other$shmSize)) {
            return false;
        }
        Long this$pidsLimit = this.getPidsLimit();
        Long other$pidsLimit = other.getPidsLimit();
        if (this$pidsLimit == null ? other$pidsLimit != null : !((Object)this$pidsLimit).equals(other$pidsLimit)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getBinds(), other.getBinds())) {
            return false;
        }
        List<BlkioWeightDevice> this$blkioWeightDevice = this.getBlkioWeightDevice();
        List<BlkioWeightDevice> other$blkioWeightDevice = other.getBlkioWeightDevice();
        if (this$blkioWeightDevice == null ? other$blkioWeightDevice != null : !((Object)this$blkioWeightDevice).equals(other$blkioWeightDevice)) {
            return false;
        }
        List<BlkioRateDevice> this$blkioDeviceReadBps = this.getBlkioDeviceReadBps();
        List<BlkioRateDevice> other$blkioDeviceReadBps = other.getBlkioDeviceReadBps();
        if (this$blkioDeviceReadBps == null ? other$blkioDeviceReadBps != null : !((Object)this$blkioDeviceReadBps).equals(other$blkioDeviceReadBps)) {
            return false;
        }
        List<BlkioRateDevice> this$blkioDeviceWriteBps = this.getBlkioDeviceWriteBps();
        List<BlkioRateDevice> other$blkioDeviceWriteBps = other.getBlkioDeviceWriteBps();
        if (this$blkioDeviceWriteBps == null ? other$blkioDeviceWriteBps != null : !((Object)this$blkioDeviceWriteBps).equals(other$blkioDeviceWriteBps)) {
            return false;
        }
        List<BlkioRateDevice> this$blkioDeviceReadIOps = this.getBlkioDeviceReadIOps();
        List<BlkioRateDevice> other$blkioDeviceReadIOps = other.getBlkioDeviceReadIOps();
        if (this$blkioDeviceReadIOps == null ? other$blkioDeviceReadIOps != null : !((Object)this$blkioDeviceReadIOps).equals(other$blkioDeviceReadIOps)) {
            return false;
        }
        List<BlkioRateDevice> this$blkioDeviceWriteIOps = this.getBlkioDeviceWriteIOps();
        List<BlkioRateDevice> other$blkioDeviceWriteIOps = other.getBlkioDeviceWriteIOps();
        if (this$blkioDeviceWriteIOps == null ? other$blkioDeviceWriteIOps != null : !((Object)this$blkioDeviceWriteIOps).equals(other$blkioDeviceWriteIOps)) {
            return false;
        }
        Map<String, String> this$annotations = this.getAnnotations();
        Map<String, String> other$annotations = other.getAnnotations();
        if (this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations)) {
            return false;
        }
        if (!Arrays.deepEquals((Object[])this.getCapAdd(), (Object[])other.getCapAdd())) {
            return false;
        }
        if (!Arrays.deepEquals((Object[])this.getCapDrop(), (Object[])other.getCapDrop())) {
            return false;
        }
        String this$containerIDFile = this.getContainerIDFile();
        String other$containerIDFile = other.getContainerIDFile();
        if (this$containerIDFile == null ? other$containerIDFile != null : !this$containerIDFile.equals(other$containerIDFile)) {
            return false;
        }
        String this$cpusetCpus = this.getCpusetCpus();
        String other$cpusetCpus = other.getCpusetCpus();
        if (this$cpusetCpus == null ? other$cpusetCpus != null : !this$cpusetCpus.equals(other$cpusetCpus)) {
            return false;
        }
        String this$cpusetMems = this.getCpusetMems();
        String other$cpusetMems = other.getCpusetMems();
        if (this$cpusetMems == null ? other$cpusetMems != null : !this$cpusetMems.equals(other$cpusetMems)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getDevices(), other.getDevices())) {
            return false;
        }
        List<String> this$deviceCgroupRules = this.getDeviceCgroupRules();
        List<String> other$deviceCgroupRules = other.getDeviceCgroupRules();
        if (this$deviceCgroupRules == null ? other$deviceCgroupRules != null : !((Object)this$deviceCgroupRules).equals(other$deviceCgroupRules)) {
            return false;
        }
        List<DeviceRequest> this$deviceRequests = this.getDeviceRequests();
        List<DeviceRequest> other$deviceRequests = other.getDeviceRequests();
        if (this$deviceRequests == null ? other$deviceRequests != null : !((Object)this$deviceRequests).equals(other$deviceRequests)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getDns(), other.getDns())) {
            return false;
        }
        List<String> this$dnsOptions = this.getDnsOptions();
        List<String> other$dnsOptions = other.getDnsOptions();
        if (this$dnsOptions == null ? other$dnsOptions != null : !((Object)this$dnsOptions).equals(other$dnsOptions)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getDnsSearch(), other.getDnsSearch())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getExtraHosts(), other.getExtraHosts())) {
            return false;
        }
        List<String> this$groupAdd = this.getGroupAdd();
        List<String> other$groupAdd = other.getGroupAdd();
        if (this$groupAdd == null ? other$groupAdd != null : !((Object)this$groupAdd).equals(other$groupAdd)) {
            return false;
        }
        String this$ipcMode = this.getIpcMode();
        String other$ipcMode = other.getIpcMode();
        if (this$ipcMode == null ? other$ipcMode != null : !this$ipcMode.equals(other$ipcMode)) {
            return false;
        }
        String this$cgroup = this.getCgroup();
        String other$cgroup = other.getCgroup();
        if (this$cgroup == null ? other$cgroup != null : !this$cgroup.equals(other$cgroup)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getLinks(), other.getLinks())) {
            return false;
        }
        LogConfig this$logConfig = this.getLogConfig();
        LogConfig other$logConfig = other.getLogConfig();
        if (this$logConfig == null ? other$logConfig != null : !((Object)this$logConfig).equals(other$logConfig)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getLxcConf(), other.getLxcConf())) {
            return false;
        }
        String this$networkMode = this.getNetworkMode();
        String other$networkMode = other.getNetworkMode();
        if (this$networkMode == null ? other$networkMode != null : !this$networkMode.equals(other$networkMode)) {
            return false;
        }
        Ports this$portBindings = this.getPortBindings();
        Ports other$portBindings = other.getPortBindings();
        if (this$portBindings == null ? other$portBindings != null : !this$portBindings.equals(other$portBindings)) {
            return false;
        }
        RestartPolicy this$restartPolicy = this.getRestartPolicy();
        RestartPolicy other$restartPolicy = other.getRestartPolicy();
        if (this$restartPolicy == null ? other$restartPolicy != null : !((Object)this$restartPolicy).equals(other$restartPolicy)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getUlimits(), other.getUlimits())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getVolumesFrom(), other.getVolumesFrom())) {
            return false;
        }
        List<Mount> this$mounts = this.getMounts();
        List<Mount> other$mounts = other.getMounts();
        if (this$mounts == null ? other$mounts != null : !((Object)this$mounts).equals(other$mounts)) {
            return false;
        }
        String this$pidMode = this.getPidMode();
        String other$pidMode = other.getPidMode();
        if (this$pidMode == null ? other$pidMode != null : !this$pidMode.equals(other$pidMode)) {
            return false;
        }
        Isolation this$isolation = this.getIsolation();
        Isolation other$isolation = other.getIsolation();
        if (this$isolation == null ? other$isolation != null : !this$isolation.equals(other$isolation)) {
            return false;
        }
        List<String> this$securityOpts = this.getSecurityOpts();
        List<String> other$securityOpts = other.getSecurityOpts();
        if (this$securityOpts == null ? other$securityOpts != null : !((Object)this$securityOpts).equals(other$securityOpts)) {
            return false;
        }
        Map<String, String> this$storageOpt = this.getStorageOpt();
        Map<String, String> other$storageOpt = other.getStorageOpt();
        if (this$storageOpt == null ? other$storageOpt != null : !((Object)this$storageOpt).equals(other$storageOpt)) {
            return false;
        }
        String this$cgroupParent = this.getCgroupParent();
        String other$cgroupParent = other.getCgroupParent();
        if (this$cgroupParent == null ? other$cgroupParent != null : !this$cgroupParent.equals(other$cgroupParent)) {
            return false;
        }
        String this$volumeDriver = this.getVolumeDriver();
        String other$volumeDriver = other.getVolumeDriver();
        if (this$volumeDriver == null ? other$volumeDriver != null : !this$volumeDriver.equals(other$volumeDriver)) {
            return false;
        }
        String this$runtime = this.getRuntime();
        String other$runtime = other.getRuntime();
        if (this$runtime == null ? other$runtime != null : !this$runtime.equals(other$runtime)) {
            return false;
        }
        Map<String, String> this$tmpFs = this.getTmpFs();
        Map<String, String> other$tmpFs = other.getTmpFs();
        if (this$tmpFs == null ? other$tmpFs != null : !((Object)this$tmpFs).equals(other$tmpFs)) {
            return false;
        }
        String this$utSMode = this.getUtSMode();
        String other$utSMode = other.getUtSMode();
        if (this$utSMode == null ? other$utSMode != null : !this$utSMode.equals(other$utSMode)) {
            return false;
        }
        String this$usernsMode = this.getUsernsMode();
        String other$usernsMode = other.getUsernsMode();
        if (this$usernsMode == null ? other$usernsMode != null : !this$usernsMode.equals(other$usernsMode)) {
            return false;
        }
        Map<String, String> this$sysctls = this.getSysctls();
        Map<String, String> other$sysctls = other.getSysctls();
        if (this$sysctls == null ? other$sysctls != null : !((Object)this$sysctls).equals(other$sysctls)) {
            return false;
        }
        List<Integer> this$consoleSize = this.getConsoleSize();
        List<Integer> other$consoleSize = other.getConsoleSize();
        if (this$consoleSize == null ? other$consoleSize != null : !((Object)this$consoleSize).equals(other$consoleSize)) {
            return false;
        }
        String this$cgroupnsMode = this.getCgroupnsMode();
        String other$cgroupnsMode = other.getCgroupnsMode();
        return !(this$cgroupnsMode == null ? other$cgroupnsMode != null : !this$cgroupnsMode.equals(other$cgroupnsMode));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HostConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $blkioWeight = this.getBlkioWeight();
        result = result * 59 + ($blkioWeight == null ? 43 : ((Object)$blkioWeight).hashCode());
        Long $memorySwappiness = this.getMemorySwappiness();
        result = result * 59 + ($memorySwappiness == null ? 43 : ((Object)$memorySwappiness).hashCode());
        Long $nanoCPUs = this.getNanoCPUs();
        result = result * 59 + ($nanoCPUs == null ? 43 : ((Object)$nanoCPUs).hashCode());
        Long $cpuPeriod = this.getCpuPeriod();
        result = result * 59 + ($cpuPeriod == null ? 43 : ((Object)$cpuPeriod).hashCode());
        Long $cpuRealtimePeriod = this.getCpuRealtimePeriod();
        result = result * 59 + ($cpuRealtimePeriod == null ? 43 : ((Object)$cpuRealtimePeriod).hashCode());
        Long $cpuRealtimeRuntime = this.getCpuRealtimeRuntime();
        result = result * 59 + ($cpuRealtimeRuntime == null ? 43 : ((Object)$cpuRealtimeRuntime).hashCode());
        Integer $cpuShares = this.getCpuShares();
        result = result * 59 + ($cpuShares == null ? 43 : ((Object)$cpuShares).hashCode());
        Long $cpuQuota = this.getCpuQuota();
        result = result * 59 + ($cpuQuota == null ? 43 : ((Object)$cpuQuota).hashCode());
        Long $diskQuota = this.getDiskQuota();
        result = result * 59 + ($diskQuota == null ? 43 : ((Object)$diskQuota).hashCode());
        Long $memory = this.getMemory();
        result = result * 59 + ($memory == null ? 43 : ((Object)$memory).hashCode());
        Long $memorySwap = this.getMemorySwap();
        result = result * 59 + ($memorySwap == null ? 43 : ((Object)$memorySwap).hashCode());
        Long $memoryReservation = this.getMemoryReservation();
        result = result * 59 + ($memoryReservation == null ? 43 : ((Object)$memoryReservation).hashCode());
        Long $kernelMemory = this.getKernelMemory();
        result = result * 59 + ($kernelMemory == null ? 43 : ((Object)$kernelMemory).hashCode());
        Boolean $oomKillDisable = this.getOomKillDisable();
        result = result * 59 + ($oomKillDisable == null ? 43 : ((Object)$oomKillDisable).hashCode());
        Boolean $init = this.getInit();
        result = result * 59 + ($init == null ? 43 : ((Object)$init).hashCode());
        Boolean $autoRemove = this.getAutoRemove();
        result = result * 59 + ($autoRemove == null ? 43 : ((Object)$autoRemove).hashCode());
        Integer $oomScoreAdj = this.getOomScoreAdj();
        result = result * 59 + ($oomScoreAdj == null ? 43 : ((Object)$oomScoreAdj).hashCode());
        Boolean $privileged = this.getPrivileged();
        result = result * 59 + ($privileged == null ? 43 : ((Object)$privileged).hashCode());
        Boolean $publishAllPorts = this.getPublishAllPorts();
        result = result * 59 + ($publishAllPorts == null ? 43 : ((Object)$publishAllPorts).hashCode());
        Boolean $readonlyRootfs = this.getReadonlyRootfs();
        result = result * 59 + ($readonlyRootfs == null ? 43 : ((Object)$readonlyRootfs).hashCode());
        Long $cpuCount = this.getCpuCount();
        result = result * 59 + ($cpuCount == null ? 43 : ((Object)$cpuCount).hashCode());
        Long $cpuPercent = this.getCpuPercent();
        result = result * 59 + ($cpuPercent == null ? 43 : ((Object)$cpuPercent).hashCode());
        Long $ioMaximumIOps = this.getIoMaximumIOps();
        result = result * 59 + ($ioMaximumIOps == null ? 43 : ((Object)$ioMaximumIOps).hashCode());
        Long $ioMaximumBandwidth = this.getIoMaximumBandwidth();
        result = result * 59 + ($ioMaximumBandwidth == null ? 43 : ((Object)$ioMaximumBandwidth).hashCode());
        Long $shmSize = this.getShmSize();
        result = result * 59 + ($shmSize == null ? 43 : ((Object)$shmSize).hashCode());
        Long $pidsLimit = this.getPidsLimit();
        result = result * 59 + ($pidsLimit == null ? 43 : ((Object)$pidsLimit).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getBinds());
        List<BlkioWeightDevice> $blkioWeightDevice = this.getBlkioWeightDevice();
        result = result * 59 + ($blkioWeightDevice == null ? 43 : ((Object)$blkioWeightDevice).hashCode());
        List<BlkioRateDevice> $blkioDeviceReadBps = this.getBlkioDeviceReadBps();
        result = result * 59 + ($blkioDeviceReadBps == null ? 43 : ((Object)$blkioDeviceReadBps).hashCode());
        List<BlkioRateDevice> $blkioDeviceWriteBps = this.getBlkioDeviceWriteBps();
        result = result * 59 + ($blkioDeviceWriteBps == null ? 43 : ((Object)$blkioDeviceWriteBps).hashCode());
        List<BlkioRateDevice> $blkioDeviceReadIOps = this.getBlkioDeviceReadIOps();
        result = result * 59 + ($blkioDeviceReadIOps == null ? 43 : ((Object)$blkioDeviceReadIOps).hashCode());
        List<BlkioRateDevice> $blkioDeviceWriteIOps = this.getBlkioDeviceWriteIOps();
        result = result * 59 + ($blkioDeviceWriteIOps == null ? 43 : ((Object)$blkioDeviceWriteIOps).hashCode());
        Map<String, String> $annotations = this.getAnnotations();
        result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
        result = result * 59 + Arrays.deepHashCode((Object[])this.getCapAdd());
        result = result * 59 + Arrays.deepHashCode((Object[])this.getCapDrop());
        String $containerIDFile = this.getContainerIDFile();
        result = result * 59 + ($containerIDFile == null ? 43 : $containerIDFile.hashCode());
        String $cpusetCpus = this.getCpusetCpus();
        result = result * 59 + ($cpusetCpus == null ? 43 : $cpusetCpus.hashCode());
        String $cpusetMems = this.getCpusetMems();
        result = result * 59 + ($cpusetMems == null ? 43 : $cpusetMems.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getDevices());
        List<String> $deviceCgroupRules = this.getDeviceCgroupRules();
        result = result * 59 + ($deviceCgroupRules == null ? 43 : ((Object)$deviceCgroupRules).hashCode());
        List<DeviceRequest> $deviceRequests = this.getDeviceRequests();
        result = result * 59 + ($deviceRequests == null ? 43 : ((Object)$deviceRequests).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getDns());
        List<String> $dnsOptions = this.getDnsOptions();
        result = result * 59 + ($dnsOptions == null ? 43 : ((Object)$dnsOptions).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getDnsSearch());
        result = result * 59 + Arrays.deepHashCode(this.getExtraHosts());
        List<String> $groupAdd = this.getGroupAdd();
        result = result * 59 + ($groupAdd == null ? 43 : ((Object)$groupAdd).hashCode());
        String $ipcMode = this.getIpcMode();
        result = result * 59 + ($ipcMode == null ? 43 : $ipcMode.hashCode());
        String $cgroup = this.getCgroup();
        result = result * 59 + ($cgroup == null ? 43 : $cgroup.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getLinks());
        LogConfig $logConfig = this.getLogConfig();
        result = result * 59 + ($logConfig == null ? 43 : ((Object)$logConfig).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getLxcConf());
        String $networkMode = this.getNetworkMode();
        result = result * 59 + ($networkMode == null ? 43 : $networkMode.hashCode());
        Ports $portBindings = this.getPortBindings();
        result = result * 59 + ($portBindings == null ? 43 : $portBindings.hashCode());
        RestartPolicy $restartPolicy = this.getRestartPolicy();
        result = result * 59 + ($restartPolicy == null ? 43 : ((Object)$restartPolicy).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getUlimits());
        result = result * 59 + Arrays.deepHashCode(this.getVolumesFrom());
        List<Mount> $mounts = this.getMounts();
        result = result * 59 + ($mounts == null ? 43 : ((Object)$mounts).hashCode());
        String $pidMode = this.getPidMode();
        result = result * 59 + ($pidMode == null ? 43 : $pidMode.hashCode());
        Isolation $isolation = this.getIsolation();
        result = result * 59 + ($isolation == null ? 43 : $isolation.hashCode());
        List<String> $securityOpts = this.getSecurityOpts();
        result = result * 59 + ($securityOpts == null ? 43 : ((Object)$securityOpts).hashCode());
        Map<String, String> $storageOpt = this.getStorageOpt();
        result = result * 59 + ($storageOpt == null ? 43 : ((Object)$storageOpt).hashCode());
        String $cgroupParent = this.getCgroupParent();
        result = result * 59 + ($cgroupParent == null ? 43 : $cgroupParent.hashCode());
        String $volumeDriver = this.getVolumeDriver();
        result = result * 59 + ($volumeDriver == null ? 43 : $volumeDriver.hashCode());
        String $runtime = this.getRuntime();
        result = result * 59 + ($runtime == null ? 43 : $runtime.hashCode());
        Map<String, String> $tmpFs = this.getTmpFs();
        result = result * 59 + ($tmpFs == null ? 43 : ((Object)$tmpFs).hashCode());
        String $utSMode = this.getUtSMode();
        result = result * 59 + ($utSMode == null ? 43 : $utSMode.hashCode());
        String $usernsMode = this.getUsernsMode();
        result = result * 59 + ($usernsMode == null ? 43 : $usernsMode.hashCode());
        Map<String, String> $sysctls = this.getSysctls();
        result = result * 59 + ($sysctls == null ? 43 : ((Object)$sysctls).hashCode());
        List<Integer> $consoleSize = this.getConsoleSize();
        result = result * 59 + ($consoleSize == null ? 43 : ((Object)$consoleSize).hashCode());
        String $cgroupnsMode = this.getCgroupnsMode();
        result = result * 59 + ($cgroupnsMode == null ? 43 : $cgroupnsMode.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "HostConfig(binds=" + Arrays.deepToString(this.getBinds()) + ", blkioWeight=" + this.getBlkioWeight() + ", blkioWeightDevice=" + this.getBlkioWeightDevice() + ", blkioDeviceReadBps=" + this.getBlkioDeviceReadBps() + ", blkioDeviceWriteBps=" + this.getBlkioDeviceWriteBps() + ", blkioDeviceReadIOps=" + this.getBlkioDeviceReadIOps() + ", blkioDeviceWriteIOps=" + this.getBlkioDeviceWriteIOps() + ", memorySwappiness=" + this.getMemorySwappiness() + ", nanoCPUs=" + this.getNanoCPUs() + ", annotations=" + this.getAnnotations() + ", capAdd=" + Arrays.deepToString((Object[])this.getCapAdd()) + ", capDrop=" + Arrays.deepToString((Object[])this.getCapDrop()) + ", containerIDFile=" + this.getContainerIDFile() + ", cpuPeriod=" + this.getCpuPeriod() + ", cpuRealtimePeriod=" + this.getCpuRealtimePeriod() + ", cpuRealtimeRuntime=" + this.getCpuRealtimeRuntime() + ", cpuShares=" + this.getCpuShares() + ", cpuQuota=" + this.getCpuQuota() + ", cpusetCpus=" + this.getCpusetCpus() + ", cpusetMems=" + this.getCpusetMems() + ", devices=" + Arrays.deepToString(this.getDevices()) + ", deviceCgroupRules=" + this.getDeviceCgroupRules() + ", deviceRequests=" + this.getDeviceRequests() + ", diskQuota=" + this.getDiskQuota() + ", dns=" + Arrays.deepToString(this.getDns()) + ", dnsOptions=" + this.getDnsOptions() + ", dnsSearch=" + Arrays.deepToString(this.getDnsSearch()) + ", extraHosts=" + Arrays.deepToString(this.getExtraHosts()) + ", groupAdd=" + this.getGroupAdd() + ", ipcMode=" + this.getIpcMode() + ", cgroup=" + this.getCgroup() + ", links=" + Arrays.deepToString(this.getLinks()) + ", logConfig=" + this.getLogConfig() + ", lxcConf=" + Arrays.deepToString(this.getLxcConf()) + ", memory=" + this.getMemory() + ", memorySwap=" + this.getMemorySwap() + ", memoryReservation=" + this.getMemoryReservation() + ", kernelMemory=" + this.getKernelMemory() + ", networkMode=" + this.getNetworkMode() + ", oomKillDisable=" + this.getOomKillDisable() + ", init=" + this.getInit() + ", autoRemove=" + this.getAutoRemove() + ", oomScoreAdj=" + this.getOomScoreAdj() + ", portBindings=" + this.getPortBindings() + ", privileged=" + this.getPrivileged() + ", publishAllPorts=" + this.getPublishAllPorts() + ", readonlyRootfs=" + this.getReadonlyRootfs() + ", restartPolicy=" + this.getRestartPolicy() + ", ulimits=" + Arrays.deepToString(this.getUlimits()) + ", cpuCount=" + this.getCpuCount() + ", cpuPercent=" + this.getCpuPercent() + ", ioMaximumIOps=" + this.getIoMaximumIOps() + ", ioMaximumBandwidth=" + this.getIoMaximumBandwidth() + ", volumesFrom=" + Arrays.deepToString(this.getVolumesFrom()) + ", mounts=" + this.getMounts() + ", pidMode=" + this.getPidMode() + ", isolation=" + this.getIsolation() + ", securityOpts=" + this.getSecurityOpts() + ", storageOpt=" + this.getStorageOpt() + ", cgroupParent=" + this.getCgroupParent() + ", volumeDriver=" + this.getVolumeDriver() + ", shmSize=" + this.getShmSize() + ", pidsLimit=" + this.getPidsLimit() + ", runtime=" + this.getRuntime() + ", tmpFs=" + this.getTmpFs() + ", utSMode=" + this.getUtSMode() + ", usernsMode=" + this.getUsernsMode() + ", sysctls=" + this.getSysctls() + ", consoleSize=" + this.getConsoleSize() + ", cgroupnsMode=" + this.getCgroupnsMode() + ")";
    }
}

