/*
 * Decompiled with CFR 0.152.
 */
package be.quodlibet.boxable.line;

import java.awt.Color;
import java.util.Objects;

public class LineStyle {
    private final Color color;
    private final float width;
    private float[] dashArray;
    private float dashPhase;

    public LineStyle(Color color, float width) {
        this.color = color;
        this.width = width;
    }

    public static LineStyle produceDotted(Color color, int width) {
        LineStyle line = new LineStyle(color, width);
        line.dashArray = new float[]{1.0f};
        line.dashPhase = 0.0f;
        return line;
    }

    public static LineStyle produceDashed(Color color, int width) {
        return LineStyle.produceDashed(color, width, new float[]{5.0f}, 0.0f);
    }

    public static LineStyle produceDashed(Color color, int width, float[] dashArray, float dashPhase) {
        LineStyle line = new LineStyle(color, width);
        line.dashArray = dashArray;
        line.dashPhase = dashPhase;
        return line;
    }

    public Color getColor() {
        return this.color;
    }

    public float getWidth() {
        return this.width;
    }

    public float[] getDashArray() {
        return this.dashArray;
    }

    public float getDashPhase() {
        return this.dashPhase;
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Objects.hashCode(this.color);
        hash = 89 * hash + Float.floatToIntBits(this.width);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LineStyle other = (LineStyle)obj;
        if (!Objects.equals(this.color, other.color)) {
            return false;
        }
        return Float.floatToIntBits(this.width) == Float.floatToIntBits(other.width);
    }
}

